/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.network.serialization;

import com.infinityraider.infinitylib.InfinityLib;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PacketBufferUtil {
    public static PacketBuffer writeBoolean(PacketBuffer buf, boolean data) {
        buf.writeBoolean(data);
        return buf;
    }

    public static boolean readBoolean(PacketBuffer buf) {
        return buf.readBoolean();
    }

    public static PacketBuffer writeByte(PacketBuffer buf, byte data) {
        buf.writeByte((int)data);
        return buf;
    }

    public static byte readByte(PacketBuffer buf) {
        return buf.readByte();
    }

    public static PacketBuffer writeShort(PacketBuffer buf, short data) {
        buf.writeShort((int)data);
        return buf;
    }

    public static short readShort(PacketBuffer buf) {
        return buf.readShort();
    }

    public static PacketBuffer writeInt(PacketBuffer buf, int data) {
        buf.writeInt(data);
        return buf;
    }

    public static int readInt(PacketBuffer buf) {
        return buf.readInt();
    }

    public static PacketBuffer writeLong(PacketBuffer buf, long data) {
        buf.writeLong(data);
        return buf;
    }

    public static long readLong(PacketBuffer buf) {
        return buf.readLong();
    }

    public static PacketBuffer writeFloat(PacketBuffer buf, float data) {
        buf.writeFloat(data);
        return buf;
    }

    public static float readFloat(PacketBuffer buf) {
        return buf.readFloat();
    }

    public static PacketBuffer writeDouble(PacketBuffer buf, double data) {
        buf.writeDouble(data);
        return buf;
    }

    public static double readDouble(PacketBuffer buf) {
        return buf.readDouble();
    }

    public static PacketBuffer writeChar(PacketBuffer buf, char data) {
        buf.writeChar((int)data);
        return buf;
    }

    public static char readChar(PacketBuffer buf) {
        return buf.readChar();
    }

    public static PacketBuffer writeString(PacketBuffer buf, String string) {
        buf.func_180714_a(string);
        return buf;
    }

    public static String readString(PacketBuffer buf) {
        return buf.func_150789_c(Short.MAX_VALUE);
    }

    public static PacketBuffer writeResourceLocation(PacketBuffer buf, ResourceLocation rl) {
        buf.func_192572_a(rl);
        return buf;
    }

    public static ResourceLocation readResourceLocation(PacketBuffer buf) {
        return buf.func_192575_l();
    }

    public static <T> PacketBuffer writeRegistryKey(PacketBuffer buf, RegistryKey<T> key) {
        ResourceLocation parent = key.getRegistryName();
        ResourceLocation name = key.func_240901_a_();
        PacketBufferUtil.writeResourceLocation(buf, parent);
        PacketBufferUtil.writeResourceLocation(buf, name);
        return buf;
    }

    public static <T> RegistryKey<T> readRegistryKey(PacketBuffer buf) {
        ResourceLocation parent = PacketBufferUtil.readResourceLocation(buf);
        ResourceLocation name = PacketBufferUtil.readResourceLocation(buf);
        return RegistryKey.func_240903_a_((RegistryKey)RegistryKey.func_240904_a_((ResourceLocation)parent), (ResourceLocation)name);
    }

    public static PacketBuffer writeEntity(PacketBuffer buf, Entity e) {
        if (e == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(e.func_145782_y());
            PacketBufferUtil.writeRegistryKey(buf, e.func_130014_f_().func_234923_W_());
        }
        return buf;
    }

    public static Entity readEntity(PacketBuffer buf) {
        int id = buf.readInt();
        if (id < 0) {
            return null;
        }
        RegistryKey dimension = PacketBufferUtil.readRegistryKey(buf);
        return InfinityLib.instance.getEntityById(dimension, id);
    }

    public static PacketBuffer writeTileEntity(PacketBuffer buf, TileEntity tile) {
        PacketBufferUtil.writeRegistryKey(buf, tile.func_145831_w().func_234923_W_());
        return PacketBufferUtil.writeBlockPos(buf, tile.func_174877_v());
    }

    public static TileEntity readTileEntity(PacketBuffer buf) {
        RegistryKey dimension = PacketBufferUtil.readRegistryKey(buf);
        BlockPos pos = PacketBufferUtil.readBlockPos(buf);
        World world = InfinityLib.instance.getWorldFromDimension(dimension);
        return world == null ? null : world.func_175625_s(pos);
    }

    public static PacketBuffer writeBlockPos(PacketBuffer buf, BlockPos pos) {
        buf.func_179255_a(pos);
        return buf;
    }

    public static BlockPos readBlockPos(PacketBuffer buf) {
        return buf.func_179259_c();
    }

    public static PacketBuffer writeBlock(PacketBuffer buf, Block block) {
        return PacketBufferUtil.writeRegistryEntry(buf, block);
    }

    public static Block readBlock(PacketBuffer buf) {
        return PacketBufferUtil.readRegistryEntry(buf, Block.class);
    }

    public static PacketBuffer writeItem(PacketBuffer buf, Item item) {
        return PacketBufferUtil.writeRegistryEntry(buf, item);
    }

    public static Item readItem(PacketBuffer buf) {
        return PacketBufferUtil.readRegistryEntry(buf, Item.class);
    }

    public static <T extends IForgeRegistryEntry<T>> PacketBuffer writeRegistryEntry(PacketBuffer buf, T entry) {
        buf.writeRegistryId(entry);
        return buf;
    }

    public static <T extends IForgeRegistryEntry<T>> T readRegistryEntry(PacketBuffer buf, Class<T> clazz) {
        return (T)buf.readRegistryIdSafe(clazz);
    }

    public static PacketBuffer writeItemStack(PacketBuffer buf, ItemStack stack) {
        buf.func_150788_a(stack);
        return buf;
    }

    public static ItemStack readItemStack(PacketBuffer buf) {
        return buf.func_150791_c();
    }

    public static PacketBuffer writeNBT(PacketBuffer buf, CompoundNBT tag) {
        buf.func_150786_a(tag);
        return buf;
    }

    public static CompoundNBT readNBT(PacketBuffer buf) {
        return buf.func_150793_b();
    }

    public static PacketBuffer writeVec3d(PacketBuffer buf, Vector3d data) {
        buf.writeDouble(data.field_72450_a);
        buf.writeDouble(data.field_72448_b);
        buf.writeDouble(data.field_72449_c);
        return buf;
    }

    public static Vector3d readVec3d(PacketBuffer buf) {
        return new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static PacketBuffer writeTextComponent(PacketBuffer buf, ITextComponent component) {
        return PacketBufferUtil.writeString(buf, ITextComponent.Serializer.func_150696_a((ITextComponent)component));
    }

    public static ITextComponent readTextComponent(PacketBuffer buf) {
        return ITextComponent.Serializer.func_240643_a_((String)PacketBufferUtil.readString(buf));
    }
}

