/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.dualwield;

import com.infinityraider.infinitylib.modules.playeranimations.PlayerAnimationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ArmSwingHandler {
    private static final ArmSwingHandler INSTANCE = new ArmSwingHandler();
    private final Map<UUID, Map<Hand, SwingProgress>> swingHandlers = new HashMap<UUID, Map<Hand, SwingProgress>>();

    public static ArmSwingHandler getInstance() {
        return INSTANCE;
    }

    private ArmSwingHandler() {
    }

    public void swingArm(PlayerEntity player, Hand hand) {
        this.getSwingProgressForPlayerAndHand(player, hand).swingArm();
    }

    public float getSwingProgress(PlayerEntity player, Hand hand, float partialTick) {
        return this.getSwingProgressForPlayerAndHand(player, hand).getSwingProgress(partialTick);
    }

    public SwingProgress getSwingProgressForPlayerAndHand(PlayerEntity player, Hand hand) {
        if (!this.swingHandlers.containsKey(player.func_110124_au())) {
            SwingProgress progress = new SwingProgress(player, hand);
            HashMap<Hand, SwingProgress> subMap = new HashMap<Hand, SwingProgress>();
            subMap.put(hand, progress);
            this.swingHandlers.put(player.func_110124_au(), subMap);
            return progress;
        }
        Map<Hand, SwingProgress> subMap = this.swingHandlers.get(player.func_110124_au());
        if (!subMap.containsKey(hand)) {
            SwingProgress progress = new SwingProgress(player, hand);
            subMap.put(hand, progress);
            return progress;
        }
        return subMap.get(hand);
    }

    @SubscribeEvent
    public void onUpdateTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map<Hand, SwingProgress> subMap : this.swingHandlers.values()) {
                subMap.values().forEach(rec$ -> ((SwingProgress)rec$).onUpdate());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRenderCall(RenderPlayerEvent.Pre event) {
        float left = this.getSwingProgress(event.getPlayer(), Hand.OFF_HAND, event.getPartialRenderTick());
        float right = this.getSwingProgress(event.getPlayer(), Hand.MAIN_HAND, event.getPartialRenderTick());
        PlayerAnimationManager.setSwingProgress(event.getRenderer(), left, right);
    }

    private static class SwingProgress {
        private final PlayerEntity player;
        private final Hand hand;
        private float swingProgress;
        private float swingProgressPrev;
        private int swingProgressInt;
        private boolean isSwingInProgress;

        private SwingProgress(PlayerEntity player, Hand hand) {
            this.player = player;
            this.hand = hand;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public Hand getHand() {
            return this.hand;
        }

        public float getSwingProgress(float partialTick) {
            float f = this.swingProgress - this.swingProgressPrev;
            if (f < 0.0f) {
                f += 1.0f;
            }
            return this.swingProgressPrev + f * partialTick;
        }

        private void onUpdate() {
            this.swingProgressPrev = this.swingProgress;
            this.updateArmSwingProgress();
        }

        private void updateArmSwingProgress() {
            int i = this.getArmSwingAnimationEnd();
            if (this.isSwingInProgress) {
                ++this.swingProgressInt;
                if (this.swingProgressInt >= i) {
                    this.swingProgressInt = 0;
                    this.isSwingInProgress = false;
                }
            } else {
                this.swingProgressInt = 0;
            }
            this.swingProgress = (float)this.swingProgressInt / (float)i;
        }

        public void swingArm() {
            ItemStack stack = this.getPlayer().func_184586_b(this.getHand());
            if (stack != null && stack.func_77973_b().onEntitySwing(stack, (LivingEntity)this.getPlayer())) {
                return;
            }
            if (!this.isSwingInProgress || this.swingProgressInt >= this.getArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
                this.swingProgressInt = -1;
            }
            this.isSwingInProgress = true;
        }

        private int getArmSwingAnimationEnd() {
            return this.getPlayer().func_70644_a(Effects.field_76422_e) ? 6 - (1 + this.getPlayer().func_70660_b(Effects.field_76422_e).func_76458_c()) : (this.getPlayer().func_70644_a(Effects.field_76419_f) ? 6 + (1 + this.getPlayer().func_70660_b(Effects.field_76419_f).func_76458_c()) * 2 : 6);
        }
    }
}

