/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.item;

import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.block.BlockDynamicTexture;
import com.infinityraider.infinitylib.item.BlockItemBase;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BlockItemDynamicTexture
extends BlockItemBase {
    private static final Set<BlockItemDynamicTexture> ITEMS = Sets.newConcurrentHashSet();
    private static final ITextComponent TOOLTIP = new TranslationTextComponent(InfinityLib.instance.getModId() + ".tooltip.material");
    private static final ITextComponent COLON = new StringTextComponent(": ");
    private static final ITextComponent UNKNOWN = new TranslationTextComponent(InfinityLib.instance.getModId() + ".tooltip.unknown");

    public static Set<BlockItemDynamicTexture> getAll() {
        return ITEMS;
    }

    public BlockItemDynamicTexture(BlockDynamicTexture<?> block, Item.Properties properties) {
        super(block, properties);
        ITEMS.add(this);
    }

    public final void setMaterial(ItemStack stack, ItemStack material) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        this.setMaterial(tag, material);
    }

    protected final void setMaterial(CompoundNBT tag, ItemStack material) {
        tag.func_218657_a("IL_MATERIAL", (INBT)material.func_77955_b(new CompoundNBT()));
    }

    public final ItemStack getMaterial(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        if (!tag.func_74764_b("IL_MATERIAL")) {
            this.setMaterial(stack, this.getDefaultMaterial());
        }
        return ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("IL_MATERIAL"));
    }

    public abstract ItemStack getDefaultMaterial();

    @OnlyIn(value=Dist.CLIENT)
    public final void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag advanced) {
        ItemStack material = this.getMaterial(stack);
        IFormattableTextComponent tooltip = new StringTextComponent("").func_230529_a_(TOOLTIP).func_230529_a_(COLON);
        if (material.func_190926_b()) {
            tooltips.add((ITextComponent)tooltip.func_230529_a_(UNKNOWN));
        } else {
            tooltips.add((ITextComponent)tooltip.func_230529_a_(material.func_200301_q()));
        }
        this.addInformation(stack, world, tooltips::add, advanced);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addInformation(@Nonnull ItemStack stack, @Nullable World world, @Nonnull Consumer<ITextComponent> tooltip, @Nonnull ITooltipFlag advanced) {
    }
}

