/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.infinityraider.infinitylib.entity.IInfinityLivingEntityType;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class AmbientSpawnHandler {
    private static final AmbientSpawnHandler INSTANCE = new AmbientSpawnHandler();
    private final Map<EntityClassification, Set<SpawnData>> spawnMap = Maps.newIdentityHashMap();

    public static AmbientSpawnHandler getInstance() {
        return INSTANCE;
    }

    private AmbientSpawnHandler() {
    }

    public AmbientSpawnHandler registerSpawnRule(EntityType<?> type, IInfinityLivingEntityType.SpawnRule rule) {
        Set set = this.spawnMap.get(rule.classification());
        if (set == null) {
            set = Sets.newIdentityHashSet();
            this.spawnMap.put(rule.classification(), set);
        }
        set.add(new SpawnData(type, rule));
        return this;
    }

    @SubscribeEvent
    public void onPotentialSpawnEvent(final WorldEvent.PotentialSpawns event) {
        if (!this.spawnMap.containsKey(event.getType())) {
            return;
        }
        final Biome biome = event.getWorld().func_226691_t_(event.getPos());
        final BlockState state = event.getWorld().func_180495_p(event.getPos().func_177977_b());
        IInfinityLivingEntityType.SpawnRule.Context context = new IInfinityLivingEntityType.SpawnRule.Context(){

            @Override
            public IWorld world() {
                return event.getWorld();
            }

            @Override
            public BlockPos pos() {
                return event.getPos();
            }

            @Override
            public BlockState stateBelow() {
                return state;
            }

            @Override
            public Biome biome() {
                return biome;
            }
        };
        this.spawnMap.get(event.getType()).stream().filter(data -> ((SpawnData)data).canSpawnAt(context)).map(rec$ -> ((SpawnData)rec$).getSpawnInfo()).forEach(info -> event.getList().add(info));
    }

    private static final class SpawnData {
        private final MobSpawnInfo.Spawners spawnInfo;
        private final Predicate<IInfinityLivingEntityType.SpawnRule.Context> rule;

        private SpawnData(EntityType<?> type, IInfinityLivingEntityType.SpawnRule rule) {
            this.spawnInfo = new MobSpawnInfo.Spawners(type, rule.weight(), rule.min(), rule.max());
            this.rule = rule.spawnRule();
        }

        private boolean canSpawnAt(IInfinityLivingEntityType.SpawnRule.Context context) {
            return this.rule.test(context);
        }

        private MobSpawnInfo.Spawners getSpawnInfo() {
            return this.spawnInfo;
        }
    }
}

