/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.crafting;

import com.google.common.collect.Maps;
import com.infinityraider.infinitylib.crafting.IInfIngredientSerializer;
import com.infinityraider.infinitylib.crafting.dynamictexture.ShapedDynamicTextureRecipe;
import com.infinityraider.infinitylib.crafting.dynamictexture.ShapelessDynamicTextureRecipe;
import com.infinityraider.infinitylib.crafting.fallback.FallbackIngredient;
import java.util.Map;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class RecipeSerializers {
    private static final RecipeSerializers INSTANCE = new RecipeSerializers();
    private final Map<ResourceLocation, IInfIngredientSerializer<?>> ingredientSerializers = Maps.newConcurrentMap();
    public final IInfIngredientSerializer<FallbackIngredient> fallbackIngredient = FallbackIngredient.SERIALIZER;
    public final IRecipeSerializer<ShapedDynamicTextureRecipe> shapedDynamicTextureRecipe = ShapedDynamicTextureRecipe.SERIALIZER;
    public final IRecipeSerializer<ShapelessDynamicTextureRecipe> shapelessDynamicTextureRecipe = ShapelessDynamicTextureRecipe.SERIALIZER;

    public static RecipeSerializers getInstance() {
        return INSTANCE;
    }

    private RecipeSerializers() {
    }

    public void registerSerializer(IInfIngredientSerializer<?> serializer) {
        this.ingredientSerializers.putIfAbsent(serializer.getId(), serializer);
    }

    public void registerSerializers() {
        this.ingredientSerializers.values().forEach(serializer -> CraftingHelper.register((ResourceLocation)serializer.getId(), (IIngredientSerializer)serializer));
    }
}

