/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2dc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class Vector3d
implements Externalizable,
Vector3dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double d) {
        this(d, d, d);
    }

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d(Vector3fc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
    }

    public Vector3d(Vector2fc v, double z) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
    }

    public Vector3d(Vector3dc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
    }

    public Vector3d(Vector2dc v, double z) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
    }

    public Vector3d(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3d(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector3d(DoubleBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3d(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Vector3d set(Vector3dc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        return this;
    }

    public Vector3d set(Vector2dc v, double z) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        return this;
    }

    public Vector3d set(Vector3fc v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        return this;
    }

    public Vector3d set(Vector2fc v, double z) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        return this;
    }

    public Vector3d set(double d) {
        return this.set(d, d, d);
    }

    public Vector3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3d set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3d set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3d set(DoubleBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3d set(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3d setComponent(int component, double value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public DoubleBuffer get(DoubleBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public DoubleBuffer get(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector3d sub(Vector3dc v) {
        this.x -= v.x();
        this.y -= v.y();
        this.z -= v.z();
        return this;
    }

    public Vector3d sub(Vector3dc v, Vector3d dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        dest.z = this.z - v.z();
        return dest;
    }

    public Vector3d sub(Vector3fc v) {
        this.x -= (double)v.x();
        this.y -= (double)v.y();
        this.z -= (double)v.z();
        return this;
    }

    public Vector3d sub(Vector3fc v, Vector3d dest) {
        dest.x = this.x - (double)v.x();
        dest.y = this.y - (double)v.y();
        dest.z = this.z - (double)v.z();
        return dest;
    }

    public Vector3d sub(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3d sub(double x, double y, double z, Vector3d dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        return dest;
    }

    public Vector3d add(Vector3dc v) {
        this.x += v.x();
        this.y += v.y();
        this.z += v.z();
        return this;
    }

    public Vector3d add(Vector3dc v, Vector3d dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        dest.z = this.z + v.z();
        return dest;
    }

    public Vector3d add(Vector3fc v) {
        this.x += (double)v.x();
        this.y += (double)v.y();
        this.z += (double)v.z();
        return this;
    }

    public Vector3d add(Vector3fc v, Vector3d dest) {
        dest.x = this.x + (double)v.x();
        dest.y = this.y + (double)v.y();
        dest.z = this.z + (double)v.z();
        return dest;
    }

    public Vector3d add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3d add(double x, double y, double z, Vector3d dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        return dest;
    }

    public Vector3d fma(Vector3dc a, Vector3dc b) {
        this.x += a.x() * b.x();
        this.y += a.y() * b.y();
        this.z += a.z() * b.z();
        return this;
    }

    public Vector3d fma(double a, Vector3dc b) {
        this.x += a * b.x();
        this.y += a * b.y();
        this.z += a * b.z();
        return this;
    }

    public Vector3d fma(Vector3fc a, Vector3fc b) {
        this.x += (double)(a.x() * b.x());
        this.y += (double)(a.y() * b.y());
        this.z += (double)(a.z() * b.z());
        return this;
    }

    public Vector3d fma(double a, Vector3fc b) {
        this.x += a * (double)b.x();
        this.y += a * (double)b.y();
        this.z += a * (double)b.z();
        return this;
    }

    public Vector3d fma(Vector3dc a, Vector3dc b, Vector3d dest) {
        dest.x = this.x + a.x() * b.x();
        dest.y = this.y + a.y() * b.y();
        dest.z = this.z + a.z() * b.z();
        return dest;
    }

    public Vector3d fma(double a, Vector3dc b, Vector3d dest) {
        dest.x = this.x + a * b.x();
        dest.y = this.y + a * b.y();
        dest.z = this.z + a * b.z();
        return dest;
    }

    public Vector3d fma(Vector3dc a, Vector3fc b, Vector3d dest) {
        dest.x = this.x + a.x() * (double)b.x();
        dest.y = this.y + a.y() * (double)b.y();
        dest.z = this.z + a.z() * (double)b.z();
        return dest;
    }

    public Vector3d fma(double a, Vector3fc b, Vector3d dest) {
        dest.x = this.x + a * (double)b.x();
        dest.y = this.y + a * (double)b.y();
        dest.z = this.z + a * (double)b.z();
        return dest;
    }

    public Vector3d mul(Vector3dc v) {
        this.x *= v.x();
        this.y *= v.y();
        this.z *= v.z();
        return this;
    }

    public Vector3d mul(Vector3fc v) {
        this.x *= (double)v.x();
        this.y *= (double)v.y();
        this.z *= (double)v.z();
        return this;
    }

    public Vector3d mul(Vector3fc v, Vector3d dest) {
        dest.x = this.x * (double)v.x();
        dest.y = this.y * (double)v.y();
        dest.z = this.z * (double)v.z();
        return dest;
    }

    public Vector3d mul(Vector3dc v, Vector3d dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        return dest;
    }

    public Vector3d div(Vector3d v) {
        this.x /= v.x();
        this.y /= v.y();
        this.z /= v.z();
        return this;
    }

    public Vector3d div(Vector3fc v) {
        this.x /= (double)v.x();
        this.y /= (double)v.y();
        this.z /= (double)v.z();
        return this;
    }

    public Vector3d div(Vector3fc v, Vector3d dest) {
        dest.x = this.x / (double)v.x();
        dest.y = this.y / (double)v.y();
        dest.z = this.z / (double)v.z();
        return dest;
    }

    public Vector3d div(Vector3dc v, Vector3d dest) {
        dest.x = this.x / v.x();
        dest.y = this.y / v.y();
        dest.z = this.z / v.z();
        return dest;
    }

    public Vector3d mulProject(Matrix4dc mat, Vector3d dest) {
        double invW = 1.0 / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33());
        dest.set((mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30()) * invW, (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31()) * invW, (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32()) * invW);
        return dest;
    }

    public Vector3d mulProject(Matrix4dc mat) {
        return this.mulProject(mat, this);
    }

    public Vector3d mulProject(Matrix4fc mat, Vector3d dest) {
        double invW = 1.0 / ((double)mat.m03() * this.x + (double)mat.m13() * this.y + (double)mat.m23() * this.z + (double)mat.m33());
        dest.set(((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30()) * invW, ((double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31()) * invW, ((double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32()) * invW);
        return dest;
    }

    public Vector3d mulProject(Matrix4fc mat) {
        return this.mulProject(mat, this);
    }

    public Vector3d mul(Matrix3fc mat) {
        return this.mul(mat, this);
    }

    public Vector3d mul(Matrix3dc mat) {
        return this.mul(mat, this);
    }

    public Vector3d mul(Matrix3dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3d mul(Matrix3fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z, (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z, (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z);
        return dest;
    }

    public Vector3d mul(Matrix3x2dc mat) {
        return this.mul(mat, this);
    }

    public Vector3d mul(Matrix3x2dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z, this.z);
        return dest;
    }

    public Vector3d mulTranspose(Matrix3dc mat) {
        return this.mul(mat, this);
    }

    public Vector3d mulTranspose(Matrix3dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z, mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z, mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulTranspose(Matrix3fc mat) {
        return this.mul(mat, this);
    }

    public Vector3d mulTranspose(Matrix3fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m01() * this.y + (double)mat.m02() * this.z, (double)mat.m10() * this.x + (double)mat.m11() * this.y + (double)mat.m12() * this.z, (double)mat.m20() * this.x + (double)mat.m21() * this.y + (double)mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulPosition(Matrix4fc mat) {
        return this.mulPosition(mat, this);
    }

    public Vector3d mulPosition(Matrix4dc mat) {
        return this.mulPosition(mat, this);
    }

    public Vector3d mulPosition(Matrix4x3dc mat) {
        return this.mulPosition(mat, this);
    }

    public Vector3d mulPosition(Matrix4x3fc mat) {
        return this.mulPosition(mat, this);
    }

    public Vector3d mulPosition(Matrix4dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30(), mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31(), mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32());
        return dest;
    }

    public Vector3d mulPosition(Matrix4fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30(), (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31(), (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32());
        return dest;
    }

    public Vector3d mulPosition(Matrix4x3dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30(), mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31(), mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32());
        return dest;
    }

    public Vector3d mulPosition(Matrix4x3fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30(), (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31(), (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32());
        return dest;
    }

    public Vector3d mulTransposePosition(Matrix4dc mat) {
        return this.mulTransposePosition(mat, this);
    }

    public Vector3d mulTransposePosition(Matrix4dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z + mat.m03(), mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z + mat.m13(), mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z + mat.m23());
        return dest;
    }

    public Vector3d mulTransposePosition(Matrix4fc mat) {
        return this.mulTransposePosition(mat, this);
    }

    public Vector3d mulTransposePosition(Matrix4fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m01() * this.y + (double)mat.m02() * this.z + (double)mat.m03(), (double)mat.m10() * this.x + (double)mat.m11() * this.y + (double)mat.m12() * this.z + (double)mat.m13(), (double)mat.m20() * this.x + (double)mat.m21() * this.y + (double)mat.m22() * this.z + (double)mat.m23());
        return dest;
    }

    public double mulPositionW(Matrix4fc mat) {
        return this.mulPositionW(mat, this);
    }

    public double mulPositionW(Matrix4fc mat, Vector3d dest) {
        double w = (double)mat.m03() * this.x + (double)mat.m13() * this.y + (double)mat.m23() * this.z + (double)mat.m33();
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30(), (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31(), (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32());
        return w;
    }

    public double mulPositionW(Matrix4dc mat) {
        return this.mulPositionW(mat, this);
    }

    public double mulPositionW(Matrix4dc mat, Vector3d dest) {
        double w = mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33();
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30(), mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31(), mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32());
        return w;
    }

    public Vector3d mulDirection(Matrix4fc mat) {
        return this.mulDirection(mat, this);
    }

    public Vector3d mulDirection(Matrix4dc mat) {
        return this.mulDirection(mat, this);
    }

    public Vector3d mulDirection(Matrix4x3dc mat) {
        return this.mulDirection(mat, this);
    }

    public Vector3d mulDirection(Matrix4x3fc mat) {
        return this.mulDirection(mat, this);
    }

    public Vector3d mulDirection(Matrix4dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulDirection(Matrix4fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z, (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z, (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulDirection(Matrix4x3dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulDirection(Matrix4x3fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z, (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z, (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulTransposeDirection(Matrix4dc mat) {
        return this.mulTransposeDirection(mat, this);
    }

    public Vector3d mulTransposeDirection(Matrix4dc mat, Vector3d dest) {
        dest.set(mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z, mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z, mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3d mulTransposeDirection(Matrix4fc mat) {
        return this.mulTransposeDirection(mat, this);
    }

    public Vector3d mulTransposeDirection(Matrix4fc mat, Vector3d dest) {
        dest.set((double)mat.m00() * this.x + (double)mat.m01() * this.y + (double)mat.m02() * this.z, (double)mat.m10() * this.x + (double)mat.m11() * this.y + (double)mat.m12() * this.z, (double)mat.m20() * this.x + (double)mat.m21() * this.y + (double)mat.m22() * this.z);
        return dest;
    }

    public Vector3d mul(double scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3d mul(double scalar, Vector3d dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        return dest;
    }

    public Vector3d mul(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3d mul(double x, double y, double z, Vector3d dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        return dest;
    }

    public Vector3d rotate(Quaterniondc quat) {
        quat.transform(this, this);
        return this;
    }

    public Vector3d rotate(Quaterniondc quat, Vector3d dest) {
        quat.transform(this, dest);
        return dest;
    }

    public Quaterniond rotationTo(Vector3dc toDir, Quaterniond dest) {
        return dest.rotationTo(this, toDir);
    }

    public Quaterniond rotationTo(double toDirX, double toDirY, double toDirZ, Quaterniond dest) {
        return dest.rotationTo(this.x, this.y, this.z, toDirX, toDirY, toDirZ);
    }

    public Vector3d div(double scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        return this;
    }

    public Vector3d div(double scalar, Vector3d dest) {
        dest.x = this.x / scalar;
        dest.y = this.y / scalar;
        dest.z = this.z / scalar;
        return dest;
    }

    public Vector3d div(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector3d div(double x, double y, double z, Vector3d dest) {
        dest.x = this.x / x;
        dest.y = this.y / y;
        dest.z = this.z / z;
        return dest;
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public Vector3d normalize() {
        double invLength = 1.0 / this.length();
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        return this;
    }

    public Vector3d normalize(Vector3d dest) {
        double invLength = 1.0 / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        return dest;
    }

    public Vector3d cross(Vector3dc v) {
        this.set(this.y * v.z() - this.z * v.y(), this.z * v.x() - this.x * v.z(), this.x * v.y() - this.y * v.x());
        return this;
    }

    public Vector3d cross(double x, double y, double z) {
        return this.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public Vector3d cross(Vector3dc v, Vector3d dest) {
        dest.set(this.y * v.z() - this.z * v.y(), this.z * v.x() - this.x * v.z(), this.x * v.y() - this.y * v.x());
        return dest;
    }

    public Vector3d cross(double x, double y, double z, Vector3d dest) {
        return dest.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public double distance(Vector3dc v) {
        double dx = v.x() - this.x;
        double dy = v.y() - this.y;
        double dz = v.z() - this.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distance(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distanceSquared(Vector3dc v) {
        double dx = v.x() - this.x;
        double dy = v.y() - this.y;
        double dz = v.z() - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceSquared(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double dot(Vector3dc v) {
        return this.x * v.x() + this.y * v.y() + this.z * v.z();
    }

    public double dot(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public double angleCos(Vector3dc v) {
        double length1Sqared = this.x * this.x + this.y * this.y + this.z * this.z;
        double length2Sqared = v.x() * v.x() + v.y() * v.y() + v.z() * v.z();
        double dot = this.x * v.x() + this.y * v.y() + this.z * v.z();
        return dot / Math.sqrt(length1Sqared * length2Sqared);
    }

    public double angle(Vector3dc v) {
        double cos = this.angleCos(v);
        cos = cos < 1.0 ? cos : 1.0;
        cos = cos > -1.0 ? cos : -1.0;
        return Math.acos(cos);
    }

    public Vector3d zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        String str = this.toString(formatter);
        StringBuffer res = new StringBuffer();
        int eIndex = Integer.MIN_VALUE;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'E') {
                eIndex = i;
            } else {
                if (c == ' ' && eIndex == i - 1) {
                    res.append('+');
                    continue;
                }
                if (Character.isDigit(c) && eIndex == i - 1) {
                    res.append('+');
                }
            }
            res.append(c);
        }
        return res.toString();
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    public Vector3d negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3d negate(Vector3d dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3d other = (Vector3d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public Vector3d reflect(Vector3dc normal) {
        double dot = this.dot(normal);
        this.x -= (dot + dot) * normal.x();
        this.y -= (dot + dot) * normal.y();
        this.z -= (dot + dot) * normal.z();
        return this;
    }

    public Vector3d reflect(double x, double y, double z) {
        double dot = this.dot(x, y, z);
        this.x -= (dot + dot) * x;
        this.y -= (dot + dot) * y;
        this.z -= (dot + dot) * z;
        return this;
    }

    public Vector3d reflect(Vector3dc normal, Vector3d dest) {
        double dot = this.dot(normal);
        dest.x = this.x - (dot + dot) * normal.x();
        dest.y = this.y - (dot + dot) * normal.y();
        dest.z = this.z - (dot + dot) * normal.z();
        return dest;
    }

    public Vector3d reflect(double x, double y, double z, Vector3d dest) {
        double dot = this.dot(x, y, z);
        dest.x = this.x - (dot + dot) * x;
        dest.y = this.y - (dot + dot) * y;
        dest.z = this.z - (dot + dot) * z;
        return dest;
    }

    public Vector3d half(Vector3dc other) {
        return this.add(other).normalize();
    }

    public Vector3d half(double x, double y, double z) {
        return this.add(x, y, z).normalize();
    }

    public Vector3d half(Vector3dc other, Vector3d dest) {
        return dest.set(this).add(other).normalize();
    }

    public Vector3d half(double x, double y, double z, Vector3d dest) {
        return dest.set(this).add(x, y, z).normalize();
    }

    public Vector3d smoothStep(Vector3dc v, double t, Vector3d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v.x() - v.x()) * t3 + (3.0 * v.x() - 3.0 * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y() - v.y()) * t3 + (3.0 * v.y() - 3.0 * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z() - v.z()) * t3 + (3.0 * v.z() - 3.0 * this.z) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3d hermite(Vector3dc t0, Vector3dc v1, Vector3dc t1, double t, Vector3d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x() - v1.x() + t1.x() + t0.x()) * t3 + (3.0 * v1.x() - 3.0 * this.x - t0.x() - t0.x() - t1.x()) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y() - v1.y() + t1.y() + t0.y()) * t3 + (3.0 * v1.y() - 3.0 * this.y - t0.y() - t0.y() - t1.y()) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z() - v1.z() + t1.z() + t0.z()) * t3 + (3.0 * v1.z() - 3.0 * this.z - t0.z() - t0.z() - t1.z()) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3d lerp(Vector3dc other, double t) {
        return this.lerp(other, t, this);
    }

    public Vector3d lerp(Vector3dc other, double t, Vector3d dest) {
        dest.x = this.x + (other.x() - this.x) * t;
        dest.y = this.y + (other.y() - this.y) * t;
        dest.z = this.z + (other.z() - this.z) * t;
        return dest;
    }

    public double get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public int maxComponent() {
        double absX = Math.abs(this.x);
        double absY = Math.abs(this.y);
        double absZ = Math.abs(this.z);
        if (absX >= absY && absX >= absZ) {
            return 0;
        }
        if (absY >= absZ) {
            return 1;
        }
        return 2;
    }

    public int minComponent() {
        double absX = Math.abs(this.x);
        double absY = Math.abs(this.y);
        double absZ = Math.abs(this.z);
        if (absX < absY && absX < absZ) {
            return 0;
        }
        if (absY < absZ) {
            return 1;
        }
        return 2;
    }

    public Vector3d orthogonalize(Vector3dc v, Vector3d dest) {
        double invLenV = 1.0 / Math.sqrt(v.x() * v.x() + v.y() * v.y() + v.z() * v.z());
        double vx = v.x() * invLenV;
        double vy = v.y() * invLenV;
        double vz = v.z() * invLenV;
        double dot = vx * this.x + vy * this.y + vz * this.z;
        double rx = this.x - dot * vx;
        double ry = this.y - dot * vy;
        double rz = this.z - dot * vz;
        double invLen = 1.0 / Math.sqrt(rx * rx + ry * ry + rz * rz);
        dest.x = rx * invLen;
        dest.y = ry * invLen;
        dest.z = rz * invLen;
        return dest;
    }

    public Vector3d orthogonalize(Vector3dc v) {
        return this.orthogonalize(v, this);
    }

    public Vector3d orthogonalizeUnit(Vector3dc v, Vector3d dest) {
        double vx = v.x();
        double vy = v.y();
        double vz = v.z();
        double dot = vx * this.x + vy * this.y + vz * this.z;
        double rx = this.x - dot * vx;
        double ry = this.y - dot * vy;
        double rz = this.z - dot * vz;
        double invLen = 1.0 / Math.sqrt(rx * rx + ry * ry + rz * rz);
        dest.x = rx * invLen;
        dest.y = ry * invLen;
        dest.z = rz * invLen;
        return dest;
    }

    public Vector3d orthogonalizeUnit(Vector3dc v) {
        return this.orthogonalizeUnit(v, this);
    }

    public Vector3dc toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Vector3dc {
        private final Vector3dc delegate;

        Proxy(Vector3dc delegate) {
            this.delegate = delegate;
        }

        public double x() {
            return this.delegate.x();
        }

        public double y() {
            return this.delegate.y();
        }

        public double z() {
            return this.delegate.z();
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public DoubleBuffer get(DoubleBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public DoubleBuffer get(int index, DoubleBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public Vector3d sub(Vector3dc v, Vector3d dest) {
            return this.delegate.sub(v, dest);
        }

        public Vector3d sub(Vector3fc v, Vector3d dest) {
            return this.delegate.sub(v, dest);
        }

        public Vector3d sub(double x, double y, double z, Vector3d dest) {
            return this.delegate.sub(x, y, z, dest);
        }

        public Vector3d add(Vector3dc v, Vector3d dest) {
            return this.delegate.add(v, dest);
        }

        public Vector3d add(Vector3fc v, Vector3d dest) {
            return this.delegate.add(v, dest);
        }

        public Vector3d add(double x, double y, double z, Vector3d dest) {
            return this.delegate.add(x, y, z, dest);
        }

        public Vector3d fma(Vector3dc a, Vector3dc b, Vector3d dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector3d fma(double a, Vector3dc b, Vector3d dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector3d fma(Vector3dc a, Vector3fc b, Vector3d dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector3d fma(double a, Vector3fc b, Vector3d dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector3d mul(Vector3fc v, Vector3d dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector3d mul(Vector3dc v, Vector3d dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector3d div(Vector3fc v, Vector3d dest) {
            return this.delegate.div(v, dest);
        }

        public Vector3d div(Vector3dc v, Vector3d dest) {
            return this.delegate.div(v, dest);
        }

        public Vector3d mulProject(Matrix4dc mat, Vector3d dest) {
            return this.delegate.mulProject(mat, dest);
        }

        public Vector3d mulProject(Matrix4fc mat, Vector3d dest) {
            return this.delegate.mulProject(mat, dest);
        }

        public Vector3d mul(Matrix3dc mat, Vector3d dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector3d mul(Matrix3fc mat, Vector3d dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector3d mulTranspose(Matrix3dc mat, Vector3d dest) {
            return this.delegate.mulTranspose(mat, dest);
        }

        public Vector3d mulTranspose(Matrix3fc mat, Vector3d dest) {
            return this.delegate.mulTranspose(mat, dest);
        }

        public Vector3d mulPosition(Matrix4dc mat, Vector3d dest) {
            return this.delegate.mulPosition(mat, dest);
        }

        public Vector3d mulPosition(Matrix4fc mat, Vector3d dest) {
            return this.delegate.mulPosition(mat, dest);
        }

        public Vector3d mulPosition(Matrix4x3dc mat, Vector3d dest) {
            return this.delegate.mulPosition(mat, dest);
        }

        public Vector3d mulPosition(Matrix4x3fc mat, Vector3d dest) {
            return this.delegate.mulPosition(mat, dest);
        }

        public Vector3d mulTransposePosition(Matrix4dc mat, Vector3d dest) {
            return this.delegate.mulTransposePosition(mat, dest);
        }

        public Vector3d mulTransposePosition(Matrix4fc mat, Vector3d dest) {
            return this.delegate.mulTransposePosition(mat, dest);
        }

        public double mulPositionW(Matrix4fc mat, Vector3d dest) {
            return this.delegate.mulPositionW(mat, dest);
        }

        public double mulPositionW(Matrix4dc mat, Vector3d dest) {
            return this.delegate.mulPositionW(mat, dest);
        }

        public Vector3d mulDirection(Matrix4dc mat, Vector3d dest) {
            return this.delegate.mulDirection(mat, dest);
        }

        public Vector3d mulDirection(Matrix4fc mat, Vector3d dest) {
            return this.delegate.mulDirection(mat, dest);
        }

        public Vector3d mulDirection(Matrix4x3dc mat, Vector3d dest) {
            return this.delegate.mulDirection(mat, dest);
        }

        public Vector3d mulDirection(Matrix4x3fc mat, Vector3d dest) {
            return this.delegate.mulDirection(mat, dest);
        }

        public Vector3d mulTransposeDirection(Matrix4dc mat, Vector3d dest) {
            return this.delegate.mulTransposeDirection(mat, dest);
        }

        public Vector3d mulTransposeDirection(Matrix4fc mat, Vector3d dest) {
            return this.delegate.mulTransposeDirection(mat, dest);
        }

        public Vector3d mul(double scalar, Vector3d dest) {
            return this.delegate.mul(scalar, dest);
        }

        public Vector3d mul(double x, double y, double z, Vector3d dest) {
            return this.delegate.mul(x, y, z, dest);
        }

        public Vector3d rotate(Quaterniondc quat, Vector3d dest) {
            return this.delegate.rotate(quat, dest);
        }

        public Vector3d div(double scalar, Vector3d dest) {
            return this.delegate.div(scalar, dest);
        }

        public Vector3d div(double x, double y, double z, Vector3d dest) {
            return this.delegate.div(x, y, z, dest);
        }

        public double lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public double length() {
            return this.delegate.length();
        }

        public Vector3d normalize(Vector3d dest) {
            return this.delegate.normalize(dest);
        }

        public Vector3d cross(Vector3dc v, Vector3d dest) {
            return this.delegate.cross(v, dest);
        }

        public Vector3d cross(double x, double y, double z, Vector3d dest) {
            return this.delegate.cross(x, y, z, dest);
        }

        public double distance(Vector3dc v) {
            return this.delegate.distance(v);
        }

        public double distance(double x, double y, double z) {
            return this.delegate.distance(x, y, z);
        }

        public double distanceSquared(Vector3dc v) {
            return this.delegate.distanceSquared(v);
        }

        public double distanceSquared(double x, double y, double z) {
            return this.delegate.distanceSquared(x, y, z);
        }

        public double dot(Vector3dc v) {
            return this.delegate.dot(v);
        }

        public double dot(double x, double y, double z) {
            return this.delegate.dot(x, y, z);
        }

        public double angleCos(Vector3dc v) {
            return this.delegate.angleCos(v);
        }

        public double angle(Vector3dc v) {
            return this.delegate.angle(v);
        }

        public Vector3d negate(Vector3d dest) {
            return this.delegate.negate(dest);
        }

        public Vector3d reflect(Vector3dc normal, Vector3d dest) {
            return this.delegate.reflect(normal, dest);
        }

        public Vector3d reflect(double x, double y, double z, Vector3d dest) {
            return this.delegate.reflect(x, y, z, dest);
        }

        public Vector3d half(Vector3dc other, Vector3d dest) {
            return this.delegate.half(other, dest);
        }

        public Vector3d half(double x, double y, double z, Vector3d dest) {
            return this.delegate.half(x, y, z, dest);
        }

        public Vector3d smoothStep(Vector3dc v, double t, Vector3d dest) {
            return this.delegate.smoothStep(v, t, dest);
        }

        public Vector3d hermite(Vector3dc t0, Vector3dc v1, Vector3dc t1, double t, Vector3d dest) {
            return this.delegate.hermite(t0, v1, t1, t, dest);
        }

        public Vector3d lerp(Vector3dc other, double t, Vector3d dest) {
            return this.delegate.lerp(other, t, dest);
        }

        public double get(int component) throws IllegalArgumentException {
            return this.delegate.get(component);
        }

        public int maxComponent() {
            return this.delegate.maxComponent();
        }

        public int minComponent() {
            return this.delegate.minComponent();
        }

        public Vector3d orthogonalize(Vector3dc v, Vector3d dest) {
            return this.delegate.orthogonalize(v, dest);
        }

        public Vector3d orthogonalizeUnit(Vector3dc v, Vector3d dest) {
            return this.delegate.orthogonalizeUnit(v, dest);
        }
    }
}

