/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class HashableBlockState {
    @Nonnull
    private final Block block;
    @Nullable
    private final EnumFacing side;
    @Nonnull
    private final ImmutableMap<IProperty<?>, Comparable<?>> listedProperties;
    @Nonnull
    private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;

    public HashableBlockState(@Nonnull IBlockState state) {
        this(state, null);
    }

    public HashableBlockState(@Nonnull IBlockState state, @Nullable EnumFacing side) {
        this(state.func_177230_c(), state.func_177228_b(), state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).getUnlistedProperties() : ImmutableMap.of(), side);
    }

    public HashableBlockState(@Nonnull Block block, @Nonnull ImmutableMap<IProperty<?>, Comparable<?>> listedProperties, @Nonnull ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, @Nullable EnumFacing side) {
        this.block = (Block)Preconditions.checkNotNull((Object)block);
        this.listedProperties = (ImmutableMap)Preconditions.checkNotNull(listedProperties);
        this.unlistedProperties = (ImmutableMap)Preconditions.checkNotNull(unlistedProperties);
        this.side = side;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HashableBlockState) {
            HashableBlockState other = (HashableBlockState)obj;
            return Objects.equals(this.block, other.block) && Objects.equals(this.side, other.side) && Objects.equals(this.listedProperties, other.listedProperties) && Objects.equals(this.unlistedProperties, other.unlistedProperties);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + Objects.hashCode(this.block);
        hash = 31 * hash + Objects.hashCode(this.side);
        hash = 31 * hash + Objects.hashCode(this.listedProperties);
        hash = 31 * hash + Objects.hashCode(this.unlistedProperties);
        return hash;
    }
}

