/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.tessellation;

import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.joml.MatrixStackf;
import org.joml.Vector3f;
import org.joml.Vector4f;

@SideOnly(value=Side.CLIENT)
public abstract class TessellatorAbstractBase
implements ITessellator {
    public static final float STANDARD_COLOR = 1.0f;
    public static final int STANDARD_BRIGHTNESS = 0xF000000;
    public static final Vector3f STANDARD_NORMAL = new Vector3f(0.0f, 1.0f, 0.0f);
    protected final MatrixStackf matrices = new MatrixStackf(64);
    protected VertexFormat format;
    protected final Vector3f normal = new Vector3f(STANDARD_NORMAL);
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected float a = 1.0f;
    protected int l;
    protected int tintIndex = -1;
    protected boolean applyDiffuseLighting = false;

    protected TessellatorAbstractBase() {
    }

    @Override
    public final void startDrawingQuads(VertexFormat vertexFormat) {
        this.format = vertexFormat;
        this.onStartDrawingQuadsCall();
    }

    protected abstract void onStartDrawingQuadsCall();

    @Override
    public final void draw() {
        this.onDrawCall();
        this.format = null;
        this.normal.set(STANDARD_NORMAL);
        this.setColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        this.setBrightness(0xF000000);
        this.tintIndex = -1;
        this.applyDiffuseLighting = false;
        this.matrices.clear();
    }

    protected abstract void onDrawCall();

    @Override
    public final VertexFormat getVertexFormat() {
        return this.format;
    }

    @Override
    public void pushMatrix() {
        this.matrices.pushMatrix();
    }

    @Override
    public void popMatrix() {
        this.matrices.popMatrix();
    }

    @Override
    public void addVertexWithUV(float x, float y, float z, TextureAtlasSprite icon, float u, float v) {
        if (icon == null) {
            icon = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        this.addVertexWithUV(x, y, z, icon.func_94214_a((double)u), icon.func_94207_b((double)v));
    }

    @Override
    public void addScaledVertexWithUV(float x, float y, float z, TextureAtlasSprite icon, float u, float v) {
        this.addVertexWithUV(x * 0.0625f, y * 0.0625f, z * 0.0625f, icon, u, v);
    }

    @Override
    public void drawScaledFace(float minX, float minY, float maxX, float maxY, EnumFacing face, TextureAtlasSprite icon, float offset) {
        float v1;
        float v2;
        float v3;
        float v4;
        float u1;
        float u4;
        float u2;
        float u3;
        float y1;
        float y2;
        float y3;
        float y4;
        float z3;
        float z4;
        float z1;
        float z2;
        float x2;
        float x3;
        float x1;
        float x4;
        int uv = 17;
        switch (face) {
            case UP: {
                x1 = x4 = maxX;
                x2 = x3 = minX;
                z1 = z2 = minY;
                z3 = z4 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u2 = u3 = minX % 17.0f;
                u1 = u4 = maxX % 17.0f;
                v3 = v4 = maxY % 17.0f;
                v1 = v2 = minY % 17.0f;
                break;
            }
            case DOWN: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                z1 = z4 = minY;
                z2 = z3 = maxY;
                y3 = y4 = offset;
                y2 = y4;
                y1 = y4;
                u1 = u2 = maxX % 17.0f;
                u3 = u4 = minX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            case WEST: {
                z1 = z2 = maxX;
                z3 = z4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1 = u2 = maxX % 17.0f;
                u3 = u4 = minX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            case EAST: {
                z1 = z2 = minX;
                z3 = z4 = maxX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                x3 = x4 = offset;
                x2 = x4;
                x1 = x4;
                u1 = u2 = 16.0f - minX % 17.0f;
                u3 = u4 = 16.0f - maxX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            case NORTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = maxY;
                y2 = y3 = minY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1 = u2 = 16.0f - maxX % 17.0f;
                u3 = u4 = 16.0f - minX % 17.0f;
                v1 = v4 = 16.0f - maxY % 17.0f;
                v2 = v3 = 16.0f - minY % 17.0f;
                break;
            }
            case SOUTH: {
                x1 = x2 = maxX;
                x3 = x4 = minX;
                y1 = y4 = minY;
                y2 = y3 = maxY;
                z3 = z4 = offset;
                z2 = z4;
                z1 = z4;
                u1 = u2 = maxX % 17.0f;
                u3 = u4 = minX % 17.0f;
                v1 = v4 = 16.0f - minY % 17.0f;
                v2 = v3 = 16.0f - maxY % 17.0f;
                break;
            }
            default: {
                return;
            }
        }
        float rPrev = this.r;
        float gPrev = this.g;
        float bPrev = this.b;
        float aPrev = this.a;
        this.applyColorMultiplier(face);
        this.setNormal(face.func_82601_c(), face.func_96559_d(), face.func_82599_e());
        this.addScaledVertexWithUV(x1, y1, z1, icon, u1, v1);
        this.addScaledVertexWithUV(x2, y2, z2, icon, u2, v2);
        this.addScaledVertexWithUV(x3, y3, z3, icon, u3, v3);
        this.addScaledVertexWithUV(x4, y4, z4, icon, u4, v4);
        this.setColorRGBA(rPrev, gPrev, bPrev, aPrev);
    }

    @Override
    public void drawScaledFaceDouble(float minX, float minY, float maxX, float maxY, EnumFacing face, TextureAtlasSprite icon, float offset) {
        EnumFacing opposite;
        switch (face) {
            case NORTH: {
                opposite = EnumFacing.SOUTH;
                break;
            }
            case SOUTH: {
                opposite = EnumFacing.NORTH;
                break;
            }
            case EAST: {
                opposite = EnumFacing.WEST;
                break;
            }
            case WEST: {
                opposite = EnumFacing.EAST;
                break;
            }
            case UP: {
                opposite = EnumFacing.DOWN;
                break;
            }
            case DOWN: {
                opposite = EnumFacing.UP;
                break;
            }
            default: {
                return;
            }
        }
        this.drawScaledFace(minX, minY, maxX, maxY, face, icon, offset);
        this.drawScaledFace(minX, minY, maxX, maxY, opposite, icon, offset);
    }

    @Override
    public void drawScaledPrism(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, TextureAtlasSprite icon) {
        this.drawScaledFace(minX, minZ, maxX, maxZ, EnumFacing.DOWN, icon, minY);
        this.drawScaledFace(minX, minZ, maxX, maxZ, EnumFacing.UP, icon, maxY);
        this.drawScaledFace(minX, minY, maxX, maxY, EnumFacing.NORTH, icon, minZ);
        this.drawScaledFace(minX, minY, maxX, maxY, EnumFacing.SOUTH, icon, maxZ);
        this.drawScaledFace(minZ, minY, maxZ, maxY, EnumFacing.WEST, icon, minX);
        this.drawScaledFace(minZ, minY, maxZ, maxY, EnumFacing.EAST, icon, maxX);
    }

    @Override
    public void translate(BlockPos pos) {
        this.translate(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void translate(float x, float y, float z) {
        this.matrices.translate(x, y, z);
    }

    @Override
    public void rotate(float angle, float x, float y, float z) {
        this.matrices.rotate((float)Math.toRadians(angle), x, y, z);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.matrices.scale(x, y, z);
    }

    @Override
    public TextureAtlasSprite getIcon(ResourceLocation loc) {
        if (loc != null) {
            return (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(loc);
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    @Override
    public void bindTexture(ResourceLocation loc) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(loc);
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.normal.set(x, y, z);
    }

    @Override
    public void setNormal(Vector3f vec) {
        this.normal.set(vec);
    }

    @Override
    public Vector3f getNormal() {
        return this.normal;
    }

    @Override
    public int getColor() {
        return (int)(this.r * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.b * 255.0f);
    }

    @Override
    public void setColorRGB(float red, float green, float blue) {
        this.setColorRGBA(red, green, blue, 1.0f);
    }

    @Override
    public void setColorRGBA(float red, float green, float blue, float alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.a = alpha;
    }

    @Override
    public float getRed() {
        return this.r;
    }

    @Override
    public float getGreen() {
        return this.g;
    }

    @Override
    public float getBlue() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.a;
    }

    @Override
    public void setBrightness(int value) {
        this.l = value;
    }

    @Override
    public int getBrightness() {
        return this.l;
    }

    @Override
    public void setTintIndex(int index) {
        this.tintIndex = index;
    }

    @Override
    public int getTintIndex() {
        return this.tintIndex;
    }

    @Override
    public void setApplyDiffuseLighting(boolean value) {
        this.applyDiffuseLighting = value;
    }

    @Override
    public boolean getApplyDiffuseLighting() {
        return this.applyDiffuseLighting;
    }

    protected abstract void applyColorMultiplier(EnumFacing var1);

    @Override
    public final void transform(Vector4f pos) {
        this.matrices.transform(pos);
    }

    public final UnpackedBakedQuad transformQuad(BakedQuad quad) {
        VertexFormat format = quad.getFormat();
        float[][][] vertexData = new float[4][format.func_177345_h()][4];
        Vector4f temp = new Vector4f();
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < format.func_177345_h(); ++e) {
                LightUtil.unpack((int[])quad.func_178209_a(), (float[])vertexData[v][e], (VertexFormat)format, (int)v, (int)e);
                this.transformUnpackedVertexDataElement(format.func_177348_c(e).func_177375_c(), vertexData[v][e], temp);
            }
        }
        return new UnpackedBakedQuad(vertexData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), format);
    }

    public final void transformUnpackedVertexDataElement(VertexFormatElement.EnumUsage type, float[] data, Vector4f temp) {
        switch (type) {
            case POSITION: 
            case NORMAL: {
                this.matrices.transform(data[0], data[1], data[2], 1.0f, temp);
                data[0] = temp.x;
                data[1] = temp.y;
                data[2] = temp.z;
                break;
            }
            case COLOR: {
                data[0] = this.getRed();
                data[1] = this.getGreen();
                data[2] = this.getBlue();
                data[3] = this.getAlpha();
            }
        }
    }
}

