/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.capability;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.capability.CapabilityProvider;
import com.infinityraider.infinitylib.capability.CapabilityStorage;
import com.infinityraider.infinitylib.capability.ICapabilityImplementation;
import com.infinityraider.infinitylib.utility.ISerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityHandler {
    private static final CapabilityHandler INSTANCE = new CapabilityHandler();
    private final Map<Class<? extends ICapabilityProvider>, List<ICapabilityImplementation<ICapabilityProvider, ? extends ISerializable>>> map = new HashMap<Class<? extends ICapabilityProvider>, List<ICapabilityImplementation<ICapabilityProvider, ? extends ISerializable>>>();

    public static CapabilityHandler getInstance() {
        return INSTANCE;
    }

    private CapabilityHandler() {
        InfinityLib.proxy.registerEventHandler(this);
    }

    public void registerCapability(ICapabilityImplementation implementation) {
        if (!this.map.containsKey(implementation.getCarrierClass())) {
            this.map.put(implementation.getCarrierClass(), new ArrayList());
        }
        this.map.get(implementation.getCarrierClass()).add(implementation);
        CapabilityManager.INSTANCE.register(implementation.getCapabilityClass(), new CapabilityStorage(), () -> null);
    }

    protected <T extends ICapabilityProvider, C extends ISerializable> void addCapability(AttachCapabilitiesEvent event, ICapabilityImplementation<T, C> implementation, T carrier) {
        C value = implementation.createNewValue(carrier);
        event.addCapability(implementation.getCapabilityKey(), new CapabilityProvider<C>(implementation.getCapability(), value));
    }

    protected <T extends ICapabilityProvider> void addCapabilities(AttachCapabilitiesEvent<T> event) {
        Object object = event.getObject();
        ICapabilityProvider carrier = (ICapabilityProvider)object;
        Class<?> clazz = carrier.getClass();
        this.map.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(clazz)).forEach(entry -> ((List)entry.getValue()).stream().filter(impl -> impl.getCarrierClass().isAssignableFrom(clazz)).filter(impl -> impl.shouldApplyCapability(carrier)).forEach(impl -> this.addCapability(event, (ICapabilityImplementation)impl, (ICapabilityProvider)carrier)));
    }

    @SubscribeEvent
    public void addEntityCapabilitiesRaw(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof ICapabilityProvider) {
            this.addCapabilities(event);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        if (oldPlayer != null && newPlayer != null && !oldPlayer.func_130014_f_().field_72995_K) {
            List<ICapabilityImplementation<ICapabilityProvider, ? extends ISerializable>> list = this.map.get(oldPlayer.getClass());
            if (list == null) {
                return;
            }
            list.stream().filter(impl -> EntityPlayer.class.isAssignableFrom(impl.getCarrierClass())).filter(impl -> oldPlayer.hasCapability(impl.getCapability(), null)).forEach(impl -> {
                ISerializable oldProps = (ISerializable)oldPlayer.getCapability(impl.getCapability(), null);
                ISerializable newProps = (ISerializable)oldPlayer.getCapability(impl.getCapability(), null);
                if (newProps != null && oldProps != null) {
                    newProps.readFromNBT(oldProps.writeToNBT());
                }
            });
        }
    }
}

