/*
 * Decompiled with CFR 0.152.
 */
package ichun.common.core.updateChecker;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import ichun.common.core.CommonProxy;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.updateChecker.ModVersionChecker;
import ichun.common.iChunUtil;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;

public class PacketModsList
extends AbstractPacket {
    public int id;
    public boolean isOp;

    public PacketModsList() {
    }

    public PacketModsList(int i, boolean op) {
        this.id = i;
        this.isOp = op;
    }

    @Override
    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeInt(this.id);
        buffer.writeBoolean(this.isOp);
        ModVersionChecker.writeToBuffer(buffer);
    }

    @Override
    public void readFrom(ByteBuf buffer, Side side) {
        this.id = buffer.readInt();
        this.isOp = buffer.readBoolean();
        HashMap<String, String> versions = new HashMap<String, String>();
        String name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        while (!name.equalsIgnoreCase("##endPacket")) {
            versions.put(name, ByteBufUtils.readUTF8String((ByteBuf)buffer));
            name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        if (iChunUtil.config.getInt("versionNotificationTypes") == 1 && !this.isOp) {
            if (CommonProxy.tickHandlerClient.modUpdateNotification != null) {
                CommonProxy.tickHandlerClient.modUpdateNotification.clearModUpdates();
            }
        }
        if (iChunUtil.config.getInt("versionNotificationTypes") == 0 || iChunUtil.config.getInt("versionNotificationTypes") == 1 && this.isOp) {
            ModVersionChecker.compareServerVersions(versions);
        }
    }

    @Override
    public void execute(Side side, EntityPlayer player) {
    }
}

