/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.window;

import java.util.ArrayList;
import me.ichun.mods.ichunutil.client.gui.window.IWorkspace;
import me.ichun.mods.ichunutil.client.gui.window.Window;
import me.ichun.mods.ichunutil.client.gui.window.element.ElementTitle;
import me.ichun.mods.ichunutil.client.gui.window.element.ElementWindow;

public class WindowTabs
extends Window {
    public ArrayList<ElementWindow> tabs = new ArrayList();
    public int selectedTab;

    public WindowTabs(IWorkspace parent, Window original) {
        super(parent, original.posX, original.posY, original.width, original.height, original.minWidth, original.minHeight, "", true);
        this.docked = original.docked;
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!(this.elements.get(i) instanceof ElementTitle)) continue;
            this.elements.remove(i);
        }
        this.addWindow(original, false);
    }

    @Override
    public int onClick(int mouseX, int mouseY, int id) {
        this.tabs.get((int)this.selectedTab).mountedWindow.onClick(mouseX, mouseY, id);
        return super.onClick(mouseX, mouseY, id);
    }

    public void addWindow(Window window, boolean select) {
        if (window instanceof WindowTabs) {
            WindowTabs windowTabs = (WindowTabs)window;
            for (int i = 0; i < windowTabs.tabs.size(); ++i) {
                this.addWindow(windowTabs.tabs.get((int)i).mountedWindow, i == windowTabs.selectedTab && select);
            }
        } else {
            this.tabs.add(new ElementWindow((Window)this, 0, 0, 10, 10, this.tabs.size(), window));
            this.elements.add(this.tabs.get(this.tabs.size() - 1));
            if (select) {
                this.selectedTab = this.tabs.size() - 1;
            }
            window.docked = this.docked;
            if (window.minWidth > this.minWidth) {
                this.minWidth = window.minWidth;
                if (this.width < this.minWidth) {
                    this.oriWidth = this.width = this.minWidth;
                }
            }
            if (window.minHeight > this.minHeight) {
                this.minHeight = window.minHeight;
                if (this.height < this.minHeight) {
                    this.oriHeight = this.height = this.minHeight;
                }
            }
            window.width = this.width;
            window.height = this.height;
        }
        this.resized();
    }

    public static Window detach(ElementWindow element) {
        WindowTabs tab = (WindowTabs)element.parent;
        tab.tabs.remove(element);
        tab.elements.remove(element);
        if (tab.tabs.size() <= 1) {
            if (tab.docked >= 0) {
                for (int i = element.parent.workspace.levels.get(tab.docked).size() - 1; i >= 0; --i) {
                    Window w = element.parent.workspace.levels.get(tab.docked).get(i);
                    if (w != tab) continue;
                    element.parent.workspace.levels.get(tab.docked).remove(i);
                    if (tab.tabs.size() == 1) {
                        element.parent.workspace.levels.get(tab.docked).add(i, tab.tabs.get((int)0).mountedWindow);
                    }
                    break;
                }
            } else {
                element.parent.workspace.removeWindow(tab);
                if (tab.tabs.size() == 1) {
                    Window window = tab.tabs.get((int)0).mountedWindow;
                    element.parent.workspace.addWindowOnTop(window);
                    window.resized();
                }
            }
        } else {
            for (int i = 0; i < tab.tabs.size(); ++i) {
                tab.tabs.get((int)i).id = i;
            }
            while (tab.selectedTab >= tab.tabs.size() && tab.selectedTab > 0) {
                --tab.selectedTab;
            }
            tab.resized();
        }
        element.parent.workspace.addWindowOnTop(element.mountedWindow);
        return element.mountedWindow;
    }

    @Override
    public boolean allowMultipleInstances() {
        return true;
    }
}

