/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldData;
import com.github.alexthe666.iceandfire.world.feature.SpawnDeathWorm;
import com.github.alexthe666.iceandfire.world.feature.SpawnDragonSkeleton;
import com.github.alexthe666.iceandfire.world.feature.SpawnHippocampus;
import com.github.alexthe666.iceandfire.world.feature.SpawnSeaSerpent;
import com.github.alexthe666.iceandfire.world.feature.SpawnStymphalianBird;
import com.github.alexthe666.iceandfire.world.feature.SpawnWanderingCyclops;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenPixieVillage;
import com.github.alexthe666.iceandfire.world.gen.WorldGenSirenIsland;
import com.github.alexthe666.iceandfire.world.structure.DreadMausoleumStructure;
import com.github.alexthe666.iceandfire.world.structure.DummyPiece;
import com.github.alexthe666.iceandfire.world.structure.GorgonTempleStructure;
import com.github.alexthe666.iceandfire.world.structure.GraveyardStructure;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class IafWorldRegistry {
    public static Feature<NoFeatureConfig> FIRE_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> ICE_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> LIGHTNING_DRAGON_ROOST;
    public static Feature<NoFeatureConfig> FIRE_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> ICE_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> LIGHTNING_DRAGON_CAVE;
    public static Feature<NoFeatureConfig> CYCLOPS_CAVE;
    public static Feature<NoFeatureConfig> PIXIE_VILLAGE;
    public static Feature<NoFeatureConfig> SIREN_ISLAND;
    public static Feature<NoFeatureConfig> HYDRA_CAVE;
    public static Feature<NoFeatureConfig> MYRMEX_HIVE_DESERT;
    public static Feature<NoFeatureConfig> MYRMEX_HIVE_JUNGLE;
    public static Feature<NoFeatureConfig> SPAWN_DEATH_WORM;
    public static Feature<NoFeatureConfig> SPAWN_DRAGON_SKELETON_L;
    public static Feature<NoFeatureConfig> SPAWN_DRAGON_SKELETON_F;
    public static Feature<NoFeatureConfig> SPAWN_DRAGON_SKELETON_I;
    public static Feature<NoFeatureConfig> SPAWN_HIPPOCAMPUS;
    public static Feature<NoFeatureConfig> SPAWN_SEA_SERPENT;
    public static Feature<NoFeatureConfig> SPAWN_STYMPHALIAN_BIRD;
    public static Feature<NoFeatureConfig> SPAWN_WANDERING_CYCLOPS;
    public static IStructurePieceType DUMMY_PIECE;
    public static Structure<NoFeatureConfig> MAUSOLEUM;
    public static Structure<NoFeatureConfig> GORGON_TEMPLE;
    public static Structure<NoFeatureConfig> GRAVEYARD;
    public static ConfiguredFeature FIRE_LILY_CF;
    public static ConfiguredFeature FROST_LILY_CF;
    public static ConfiguredFeature LIGHTNING_LILY_CF;
    public static ConfiguredFeature COPPER_ORE_CF;
    public static ConfiguredFeature SILVER_ORE_CF;
    public static ConfiguredFeature SAPPHIRE_ORE_CF;
    public static ConfiguredFeature AMETHYST_ORE_CF;
    public static ConfiguredFeature FIRE_DRAGON_ROOST_CF;
    public static ConfiguredFeature ICE_DRAGON_ROOST_CF;
    public static ConfiguredFeature LIGHTNING_DRAGON_ROOST_CF;
    public static ConfiguredFeature FIRE_DRAGON_CAVE_CF;
    public static ConfiguredFeature ICE_DRAGON_CAVE_CF;
    public static ConfiguredFeature LIGHTNING_DRAGON_CAVE_CF;
    public static ConfiguredFeature CYCLOPS_CAVE_CF;
    public static ConfiguredFeature PIXIE_VILLAGE_CF;
    public static ConfiguredFeature SIREN_ISLAND_CF;
    public static ConfiguredFeature HYDRA_CAVE_CF;
    public static ConfiguredFeature MYRMEX_HIVE_DESERT_CF;
    public static ConfiguredFeature MYRMEX_HIVE_JUNGLE_CF;
    public static ConfiguredFeature SPAWN_DEATH_WORM_CF;
    public static ConfiguredFeature SPAWN_DRAGON_SKELETON_L_CF;
    public static ConfiguredFeature SPAWN_DRAGON_SKELETON_F_CF;
    public static ConfiguredFeature SPAWN_DRAGON_SKELETON_I_CF;
    public static ConfiguredFeature SPAWN_HIPPOCAMPUS_CF;
    public static ConfiguredFeature SPAWN_SEA_SERPENT_CF;
    public static ConfiguredFeature SPAWN_STYMPHALIAN_BIRD_CF;
    public static ConfiguredFeature SPAWN_WANDERING_CYCLOPS_CF;
    public static StructureFeature GORGON_TEMPLE_CF;
    public static StructureFeature MAUSOLEUM_CF;
    public static StructureFeature GRAVEYARD_CF;
    public static List<Feature<?>> featureList;
    public static List<Structure<?>> structureFeatureList;
    public static HashMap<String, Boolean> LOADED_FEATURES;

    public static void register() {
        FIRE_DRAGON_ROOST = IafWorldRegistry.registerFeature("iceandfire:fire_dragon_roost", new WorldGenFireDragonRoosts((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        ICE_DRAGON_ROOST = IafWorldRegistry.registerFeature("iceandfire:ice_dragon_roost", new WorldGenIceDragonRoosts((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        LIGHTNING_DRAGON_ROOST = IafWorldRegistry.registerFeature("iceandfire:lightning_dragon_roost", new WorldGenLightningDragonRoosts((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        FIRE_DRAGON_CAVE = IafWorldRegistry.registerFeature("iceandfire:fire_dragon_cave", new WorldGenFireDragonCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        ICE_DRAGON_CAVE = IafWorldRegistry.registerFeature("iceandfire:ice_dragon_cave", new WorldGenIceDragonCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        LIGHTNING_DRAGON_CAVE = IafWorldRegistry.registerFeature("iceandfire:lightning_dragon_cave", new WorldGenLightningDragonCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        CYCLOPS_CAVE = IafWorldRegistry.registerFeature("iceandfire:cyclops_cave", new WorldGenCyclopsCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        PIXIE_VILLAGE = IafWorldRegistry.registerFeature("iceandfire:pixie_village", new WorldGenPixieVillage((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SIREN_ISLAND = IafWorldRegistry.registerFeature("iceandfire:siren_island", new WorldGenSirenIsland((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        HYDRA_CAVE = IafWorldRegistry.registerFeature("iceandfire:hydra_cave", new WorldGenHydraCave((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        MYRMEX_HIVE_DESERT = IafWorldRegistry.registerFeature("iceandfire:myrmex_hive_desert", new WorldGenMyrmexHive(false, false, (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        MYRMEX_HIVE_JUNGLE = IafWorldRegistry.registerFeature("iceandfire:myrmex_hive_jungle", new WorldGenMyrmexHive(false, true, (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_DEATH_WORM = IafWorldRegistry.registerFeature("iceandfire:spawn_death_worm", new SpawnDeathWorm((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_DRAGON_SKELETON_L = IafWorldRegistry.registerFeature("iceandfire:spawn_dragon_skeleton_l", new SpawnDragonSkeleton(IafEntityRegistry.LIGHTNING_DRAGON, (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_DRAGON_SKELETON_F = IafWorldRegistry.registerFeature("iceandfire:spawn_dragon_skeleton_f", new SpawnDragonSkeleton(IafEntityRegistry.FIRE_DRAGON, (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_DRAGON_SKELETON_I = IafWorldRegistry.registerFeature("iceandfire:spawn_dragon_skeleton_i", new SpawnDragonSkeleton(IafEntityRegistry.ICE_DRAGON, (Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_HIPPOCAMPUS = IafWorldRegistry.registerFeature("iceandfire:spawn_hippocampus", new SpawnHippocampus((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_SEA_SERPENT = IafWorldRegistry.registerFeature("iceandfire:spawn_sea_serpent", new SpawnSeaSerpent((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_STYMPHALIAN_BIRD = IafWorldRegistry.registerFeature("iceandfire:spawn_stymphalian_bird", new SpawnStymphalianBird((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        SPAWN_WANDERING_CYCLOPS = IafWorldRegistry.registerFeature("iceandfire:spawn_wandering_cyclops", new SpawnWanderingCyclops((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
        DUMMY_PIECE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:gorgon_piece", DummyPiece::new);
        Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:mausoleum_piece", DummyPiece::new);
        Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:gorgon_piece_empty", DummyPiece::new);
        Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"iceandfire:graveyard_piece", DummyPiece::new);
        MAUSOLEUM = IafWorldRegistry.registerStructureFeature("iceandfire:mausoleum", MAUSOLEUM);
        IafWorldRegistry.putStructureOnAList("iceandfire:mausoleum", MAUSOLEUM);
        GORGON_TEMPLE = IafWorldRegistry.registerStructureFeature("iceandfire:gorgon_temple", GORGON_TEMPLE);
        IafWorldRegistry.putStructureOnAList("iceandfire:gorgon_temple", GORGON_TEMPLE);
        GRAVEYARD = IafWorldRegistry.registerStructureFeature("iceandfire:graveyard", GRAVEYARD);
        IafWorldRegistry.putStructureOnAList("iceandfire:graveyard", GRAVEYARD);
        IafWorldRegistry.addStructureSeperation((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, GORGON_TEMPLE, new StructureSeparationSettings(Math.max(IafConfig.spawnGorgonsChance, 2), Math.max(IafConfig.spawnGorgonsChance / 2, 1), 342226450));
        IafWorldRegistry.addStructureSeperation((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, MAUSOLEUM, new StructureSeparationSettings(Math.max(IafConfig.generateMausoleumChance, 2), Math.max(IafConfig.generateMausoleumChance / 2, 1), 342226451));
        IafWorldRegistry.addStructureSeperation((RegistryKey<DimensionSettings>)DimensionSettings.field_242734_c, GRAVEYARD, new StructureSeparationSettings(Math.max(IafConfig.generateGraveyardChance * 3, 2), Math.max(IafConfig.generateGraveyardChance * 3 / 2, 1), 342226440));
        GORGON_TEMPLE_CF = (StructureFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243654_f, (String)"iceandfire:gorgon_temple", (Object)GORGON_TEMPLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        MAUSOLEUM_CF = (StructureFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243654_f, (String)"iceandfire:mausoleum", (Object)MAUSOLEUM.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        GRAVEYARD_CF = (StructureFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243654_f, (String)"iceandfire:graveyard", (Object)GRAVEYARD.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e));
        Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object[])new Structure[]{GORGON_TEMPLE, MAUSOLEUM, GRAVEYARD}).build();
        COPPER_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:copper_ore", (Object)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, IafBlockRegistry.COPPER_ORE.func_176223_P(), 5)).func_242733_d(128)).func_242728_a()).func_242731_b(5));
        SILVER_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:silver_ore", (Object)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, IafBlockRegistry.SILVER_ORE.func_176223_P(), 8)).func_242733_d(32)).func_242728_a()).func_242731_b(2));
        SAPPHIRE_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:sapphire_ore", (Object)Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), IafBlockRegistry.SAPPHIRE_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        AMETHYST_ORE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:amythest_ore", (Object)Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), IafBlockRegistry.AMYTHEST_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        FIRE_LILY_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:fire_lily", (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.FIRE_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l));
        FROST_LILY_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:frost_lily", (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.FROST_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l));
        LIGHTNING_LILY_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:lightning_lily", (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(IafBlockRegistry.LIGHTNING_LILY.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(1).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l));
        FIRE_DRAGON_ROOST_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:fire_dragon_roost", (Object)FIRE_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        ICE_DRAGON_ROOST_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:ice_dragon_roost", (Object)ICE_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        LIGHTNING_DRAGON_ROOST_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:lightning_dragon_roost", (Object)LIGHTNING_DRAGON_ROOST.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        FIRE_DRAGON_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:fire_dragon_cave", (Object)FIRE_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        ICE_DRAGON_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:ice_dragon_cave", (Object)ICE_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        LIGHTNING_DRAGON_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:lightning_dragon_cave", (Object)LIGHTNING_DRAGON_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        CYCLOPS_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:cyclops_cave", (Object)CYCLOPS_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        PIXIE_VILLAGE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:pixie_village", (Object)PIXIE_VILLAGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SIREN_ISLAND_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:siren_island", (Object)SIREN_ISLAND.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        HYDRA_CAVE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:hydra_cave", (Object)HYDRA_CAVE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        MYRMEX_HIVE_DESERT_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:myrmex_hive_desert", (Object)MYRMEX_HIVE_DESERT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        MYRMEX_HIVE_JUNGLE_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:myrmex_hive_jungle", (Object)MYRMEX_HIVE_JUNGLE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_DEATH_WORM_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_death_worm_misc", (Object)SPAWN_DEATH_WORM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_DRAGON_SKELETON_L_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_dragon_skeleton_l_misc", (Object)SPAWN_DRAGON_SKELETON_L.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_DRAGON_SKELETON_F_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_dragon_skeleton_f_misc", (Object)SPAWN_DRAGON_SKELETON_F.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_DRAGON_SKELETON_I_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_dragon_skeleton_i_misc", (Object)SPAWN_DRAGON_SKELETON_I.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_HIPPOCAMPUS_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_hippocampus_misc", (Object)SPAWN_HIPPOCAMPUS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_SEA_SERPENT_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_sea_serpent_misc", (Object)SPAWN_SEA_SERPENT.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_STYMPHALIAN_BIRD_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_stymphalian_bird_misc", (Object)SPAWN_STYMPHALIAN_BIRD.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        SPAWN_WANDERING_CYCLOPS_CF = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"iceandfire:spawn_wandering_cyclops_misc", (Object)SPAWN_WANDERING_CYCLOPS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addStructureSeperation(RegistryKey<DimensionSettings> preset, Structure structure, StructureSeparationSettings settings) {
        ((DimensionSettings)WorldGenRegistries.field_243658_j.func_230516_a_(preset)).func_236108_a_().func_236195_a_().put(structure, settings);
    }

    public static <F extends Structure<?>> void putStructureOnAList(String nameForList, F structure) {
        Structure.field_236365_a_.put((Object)nameForList.toLowerCase(Locale.ROOT), structure);
    }

    private static Feature<NoFeatureConfig> registerFeature(String registryName, Feature<NoFeatureConfig> feature) {
        featureList.add((Feature<?>)feature.setRegistryName(registryName));
        return feature;
    }

    private static Structure<NoFeatureConfig> registerStructureFeature(String registryName, Structure<NoFeatureConfig> feature) {
        structureFeatureList.add(feature);
        return feature;
    }

    public static void setup() {
    }

    public static boolean isFarEnoughFromSpawn(IWorld world, BlockPos pos) {
        BlockPos spawnRelative = new BlockPos(0, pos.func_177956_o(), 0);
        boolean spawnCheck = !spawnRelative.func_218141_a((Vector3i)pos, IafConfig.dangerousWorldGenDistanceLimit);
        return spawnCheck;
    }

    public static boolean isDimensionListedForFeatures(IServerWorld world) {
        ResourceLocation name = world.func_201672_e().func_234923_W_().func_240901_a_();
        if (name == null) {
            return false;
        }
        if (IafConfig.useDimensionBlackList) {
            for (String string : IafConfig.featureBlacklistedDimensions) {
                if (!name.toString().equals(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.featureWhitelistedDimensions) {
            if (!name.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDimensionListedForDragons(IServerWorld world) {
        ResourceLocation name = world.func_201672_e().func_234923_W_().func_240901_a_();
        if (name == null) {
            return false;
        }
        if (IafConfig.useDimensionBlackList) {
            for (String string : IafConfig.dragonBlacklistedDimensions) {
                if (!name.toString().equals(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.dragonWhitelistedDimensions) {
            if (!name.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDimensionListedForMobs(IServerWorld world) {
        ResourceLocation name = world.func_201672_e().func_234923_W_().func_240901_a_();
        if (name == null) {
            return false;
        }
        if (IafConfig.useDimensionBlackList) {
            for (String string : IafConfig.mobBlacklistedDimensions) {
                if (!name.toString().equals(string)) continue;
                return false;
            }
            return true;
        }
        for (String string : IafConfig.mobWhitelistedDimensions) {
            if (!name.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFarEnoughFromDangerousGen(IServerWorld world, BlockPos pos) {
        boolean canGen = true;
        IafWorldData data = IafWorldData.get((World)world.func_201672_e());
        if (data != null) {
            BlockPos last = data.lastGeneratedDangerousStructure;
            boolean bl = canGen = last.func_177951_i((Vector3i)pos) > IafConfig.dangerousWorldGenSeparationLimit * IafConfig.dangerousWorldGenSeparationLimit;
            if (canGen) {
                data.setLastGeneratedDangerousStructure(pos);
            }
        }
        return canGen;
    }

    public static void onBiomesLoad(BiomeLoadingEvent event) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        if (BiomeConfig.test(BiomeConfig.fireLilyBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FIRE_LILY_CF);
            LOADED_FEATURES.put("FIRE_LILY_CF", true);
        }
        if (BiomeConfig.test(BiomeConfig.lightningLilyBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LIGHTNING_LILY_CF);
            LOADED_FEATURES.put("LIGHTNING_LILY_CF", true);
        }
        if (BiomeConfig.test(BiomeConfig.iceLilyBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, FROST_LILY_CF);
            LOADED_FEATURES.put("FROST_LILY_CF", true);
        }
        if (BiomeConfig.test(BiomeConfig.oreGenBiomes, biome)) {
            if (IafConfig.generateSilverOre) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, SILVER_ORE_CF);
                LOADED_FEATURES.put("SILVER_ORE_CF", true);
            }
            if (IafConfig.generateCopperOre) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, COPPER_ORE_CF);
                LOADED_FEATURES.put("COPPER_ORE_CF", true);
            }
        }
        if (IafConfig.generateSapphireOre && BiomeConfig.test(BiomeConfig.sapphireBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, SAPPHIRE_ORE_CF);
            LOADED_FEATURES.put("SAPPHIRE_ORE_CF", true);
        }
        if (IafConfig.generateAmythestOre && BiomeConfig.test(BiomeConfig.amethystBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, AMETHYST_ORE_CF);
            LOADED_FEATURES.put("AMETHYST_ORE_CF", true);
        }
        if (IafConfig.generateDragonRoosts) {
            if (BiomeConfig.test(BiomeConfig.fireDragonBiomes, biome)) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FIRE_DRAGON_ROOST_CF);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, FIRE_DRAGON_CAVE_CF);
                LOADED_FEATURES.put("FIRE_DRAGON_ROOST_CF", true);
                LOADED_FEATURES.put("FIRE_DRAGON_CAVE_CF", true);
            }
            if (BiomeConfig.test(BiomeConfig.lightningDragonBiomes, biome)) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, LIGHTNING_DRAGON_ROOST_CF);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, LIGHTNING_DRAGON_CAVE_CF);
                LOADED_FEATURES.put("LIGHTNING_DRAGON_ROOST_CF", true);
                LOADED_FEATURES.put("LIGHTNING_DRAGON_CAVE_CF", true);
            }
            if (BiomeConfig.test(BiomeConfig.iceDragonBiomes, biome)) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ICE_DRAGON_ROOST_CF);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ICE_DRAGON_CAVE_CF);
                LOADED_FEATURES.put("ICE_DRAGON_ROOST_CF", true);
                LOADED_FEATURES.put("ICE_DRAGON_CAVE_CF", true);
            }
        }
        if (IafConfig.generateCyclopsCaves && BiomeConfig.test(BiomeConfig.cyclopsCaveBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, CYCLOPS_CAVE_CF);
            LOADED_FEATURES.put("CYCLOPS_CAVE_CF", true);
        }
        if (IafConfig.spawnGorgons && BiomeConfig.test(BiomeConfig.gorgonTempleBiomes, biome)) {
            event.getGeneration().func_242516_a(GORGON_TEMPLE_CF);
            LOADED_FEATURES.put("GORGON_TEMPLE_CF", true);
        }
        if (IafConfig.spawnPixies && BiomeConfig.test(BiomeConfig.pixieBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, PIXIE_VILLAGE_CF);
        }
        if (IafConfig.generateHydraCaves && BiomeConfig.test(BiomeConfig.hydraBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, HYDRA_CAVE_CF);
            LOADED_FEATURES.put("HYDRA_CAVE_CF", true);
        }
        if (IafConfig.generateMausoleums && BiomeConfig.test(BiomeConfig.mausoleumBiomes, biome)) {
            event.getGeneration().func_242516_a(MAUSOLEUM_CF);
            LOADED_FEATURES.put("MAUSOLEUM_CF", true);
        }
        if (IafConfig.generateGraveyards && BiomeConfig.test(BiomeConfig.graveyardBiomes, biome)) {
            event.getGeneration().func_242516_a(GRAVEYARD_CF);
            LOADED_FEATURES.put("GRAVEYARD_CF", true);
        }
        if (IafConfig.generateMyrmexColonies && BiomeConfig.test(BiomeConfig.desertMyrmexBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MYRMEX_HIVE_DESERT_CF);
            LOADED_FEATURES.put("MYRMEX_HIVE_DESERT_CF", true);
        }
        if (IafConfig.generateMyrmexColonies && BiomeConfig.test(BiomeConfig.jungleMyrmexBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MYRMEX_HIVE_JUNGLE_CF);
            LOADED_FEATURES.put("MYRMEX_HIVE_JUNGLE_CF", true);
        }
        if (IafConfig.generateSirenIslands && BiomeConfig.test(BiomeConfig.sirenBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SIREN_ISLAND_CF);
            LOADED_FEATURES.put("SIREN_ISLAND_CF", true);
        }
        if (IafConfig.spawnDeathWorm && BiomeConfig.test(BiomeConfig.deathwormBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_DEATH_WORM_CF);
            LOADED_FEATURES.put("SPAWN_DEATH_WORM_CF", true);
        }
        if (IafConfig.generateWanderingCyclops && BiomeConfig.test(BiomeConfig.wanderingCyclopsBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_WANDERING_CYCLOPS_CF);
            LOADED_FEATURES.put("SPAWN_WANDERING_CYCLOPS_CF", true);
        }
        if (IafConfig.generateDragonSkeletons) {
            if (BiomeConfig.test(BiomeConfig.lightningDragonSkeletonBiomes, biome)) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_DRAGON_SKELETON_L_CF);
                LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_L_CF", true);
            }
            if (BiomeConfig.test(BiomeConfig.fireDragonSkeletonBiomes, biome)) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_DRAGON_SKELETON_F_CF);
                LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_F_CF", true);
            }
            if (BiomeConfig.test(BiomeConfig.iceDragonSkeletonBiomes, biome)) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_DRAGON_SKELETON_I_CF);
                LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_I_CF", true);
            }
        }
        if (IafConfig.spawnHippocampus && BiomeConfig.test(BiomeConfig.hippocampusBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_HIPPOCAMPUS_CF);
            LOADED_FEATURES.put("SPAWN_HIPPOCAMPUS_CF", true);
        }
        if (IafConfig.spawnSeaSerpents && BiomeConfig.test(BiomeConfig.seaSerpentBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_SEA_SERPENT_CF);
            LOADED_FEATURES.put("SPAWN_SEA_SERPENT_CF", true);
        }
        if (IafConfig.spawnStymphalianBirds && BiomeConfig.test(BiomeConfig.stymphalianBiomes, biome)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, SPAWN_STYMPHALIAN_BIRD_CF);
            LOADED_FEATURES.put("SPAWN_STYMPHALIAN_BIRD_CF", true);
        }
    }

    static {
        MAUSOLEUM = new DreadMausoleumStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        GORGON_TEMPLE = new GorgonTempleStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        GRAVEYARD = new GraveyardStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        featureList = new ArrayList();
        structureFeatureList = new ArrayList();
        LOADED_FEATURES = new HashMap();
        LOADED_FEATURES.put("FIRE_LILY_CF", false);
        LOADED_FEATURES.put("FROST_LILY_CF", false);
        LOADED_FEATURES.put("LIGHTNING_LILY_CF", false);
        LOADED_FEATURES.put("COPPER_ORE_CF", false);
        LOADED_FEATURES.put("SILVER_ORE_CF", false);
        LOADED_FEATURES.put("SAPPHIRE_ORE_CF", false);
        LOADED_FEATURES.put("AMETHYST_ORE_CF", false);
        LOADED_FEATURES.put("FIRE_DRAGON_ROOST_CF", false);
        LOADED_FEATURES.put("ICE_DRAGON_ROOST_CF", false);
        LOADED_FEATURES.put("LIGHTNING_DRAGON_ROOST_CF", false);
        LOADED_FEATURES.put("FIRE_DRAGON_CAVE_CF", false);
        LOADED_FEATURES.put("ICE_DRAGON_CAVE_CF", false);
        LOADED_FEATURES.put("LIGHTNING_DRAGON_CAVE_CF", false);
        LOADED_FEATURES.put("CYCLOPS_CAVE_CF", false);
        LOADED_FEATURES.put("PIXIE_VILLAGE_CF", false);
        LOADED_FEATURES.put("SIREN_ISLAND_CF", false);
        LOADED_FEATURES.put("HYDRA_CAVE_CF", false);
        LOADED_FEATURES.put("MYRMEX_HIVE_DESERT_CF", false);
        LOADED_FEATURES.put("MYRMEX_HIVE_JUNGLE_CF", false);
        LOADED_FEATURES.put("SPAWN_DEATH_WORM_CF", false);
        LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_L_CF", false);
        LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_F_CF", false);
        LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_I_CF", false);
        LOADED_FEATURES.put("SPAWN_HIPPOCAMPUS_CF", false);
        LOADED_FEATURES.put("SPAWN_SEA_SERPENT_CF", false);
        LOADED_FEATURES.put("SPAWN_STYMPHALIAN_BIRD_CF", false);
        LOADED_FEATURES.put("SPAWN_WANDERING_CYCLOPS_CF", false);
        LOADED_FEATURES.put("GORGON_TEMPLE_CF", false);
        LOADED_FEATURES.put("MAUSOLEUM_CF", false);
        LOADED_FEATURES.put("GRAVEYARD_CF", false);
    }
}

