/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockBreakExplosion
extends Explosion {
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final MobEntity exploder;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<PlayerEntity, Vector3d> playerKnockbackMap = Maps.newHashMap();
    private final Vector3d position;
    private Explosion.Mode mode;

    public BlockBreakExplosion(World world, MobEntity entity, double x, double y, double z, float size) {
        super(world, (Entity)entity, null, null, x, y, z, size, false, Explosion.Mode.DESTROY);
        this.world = world;
        this.exploder = entity;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.position = new Vector3d(x, y, z);
    }

    private static void handleExplosionDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
        int i = dropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)dropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            dropPositionArray.set(j, (Object)Pair.of((Object)itemstack1, (Object)pair.getSecond()));
            if (!stack.func_190926_b()) continue;
            return;
        }
        dropPositionArray.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.world.func_180495_p(blockpos);
                        FluidState ifluidstate = this.world.func_204610_c(blockpos);
                        if (!blockstate.isAir((IBlockReader)this.world, blockpos) || !ifluidstate.func_206888_e()) {
                            float f2 = Math.max(blockstate.getExplosionResistance((IBlockReader)this.world, blockpos, (Explosion)this), ifluidstate.getExplosionResistance((IBlockReader)this.world, blockpos, (Explosion)this));
                            if (this.exploder != null) {
                                f2 = this.exploder.func_180428_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.size * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f3 + 1.0));
        List list = this.world.func_72839_b((Entity)this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
        Vector3d Vector3d2 = new Vector3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            PlayerEntity playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || entity instanceof ItemEntity || !((d12 = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(Vector3d2)) / f3)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.x) * d5 + (d7 = entity.func_226280_cw_() - this.y) * d7 + (d9 = entity.func_226281_cx_() - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = BlockBreakExplosion.func_222259_a((Vector3d)Vector3d2, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(this.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.playerKnockbackMap.put(playerentity, new Vector3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        boolean flag;
        if (this.world.field_72995_K) {
            this.world.func_184134_a(this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Explosion.Mode.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.affectedBlockPositions, this.world.field_73012_v);
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState blockstate = this.world.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (blockstate.isAir((IBlockReader)this.world, blockpos)) continue;
                BlockPos blockpos1 = blockpos.func_185334_h();
                this.world.func_217381_Z().func_76320_a("explosion_blocks");
                if (blockstate.canDropFromExplosion((IBlockReader)this.world, blockpos, (Explosion)this) && this.world instanceof ServerWorld) {
                    TileEntity tileentity = blockstate.hasTileEntity() ? this.world.func_175625_s(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.exploder);
                    if (this.mode == Explosion.Mode.DESTROY) {
                        lootcontext$builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.size));
                    }
                    blockstate.func_215693_a(lootcontext$builder).forEach(stack -> BlockBreakExplosion.handleExplosionDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                }
                blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
                this.world.func_217381_Z().func_76319_b();
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
    }

    public Map<PlayerEntity, Vector3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public LivingEntity func_94613_c() {
        return this.exploder;
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vector3d getPosition() {
        return this.position;
    }
}

