/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIForage;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIForageForItems;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIPickupBabies;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIStoreBabies;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIStoreItems;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.MyrmexTrades;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemMyrmexEgg;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityMyrmexWorker
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final ResourceLocation DESERT_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_worker_desert");
    public static final ResourceLocation JUNGLE_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_worker_jungle");
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_worker.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_worker.png");
    public boolean keepSearching = true;

    public EntityMyrmexWorker(EntityType t, World worldIn) {
        super(t, worldIn);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 3;
    }

    @Override
    public boolean isSmallerThanBlock() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemMyrmexEgg) {
            boolean isJungle = this.func_184586_b(Hand.MAIN_HAND).func_77973_b() == IafItemRegistry.MYRMEX_JUNGLE_EGG;
            CompoundNBT tag = this.func_184586_b(Hand.MAIN_HAND).func_77978_p();
            int metadata = 0;
            if (tag != null) {
                metadata = tag.func_74762_e("EggOrdinal");
            }
            EntityMyrmexEgg egg = new EntityMyrmexEgg(IafEntityRegistry.MYRMEX_EGG, this.field_70170_p);
            egg.func_82149_j((Entity)this);
            egg.setJungle(isJungle);
            egg.setMyrmexCaste(metadata);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)egg);
            }
            egg.func_184220_m((Entity)this);
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if (!this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityMyrmexBase) || ((EntityMyrmexBase)entity).getGrowthStage() < 2) continue;
                entity.func_184210_p();
            }
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MyrmexAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new MyrmexAIStoreBabies(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new MyrmexAIStoreItems(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new MyrmexAIReEnterHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new MyrmexAILeaveHive(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new MyrmexAIForage(this, 2));
        this.field_70714_bg.func_75776_a(7, (Goal)new MyrmexAIMoveThroughHive(this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(2, new MyrmexAIForageForItems(this));
        this.field_70715_bh.func_75776_a(3, new MyrmexAIPickupBabies(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, true, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return EntityMyrmexWorker.this.func_184614_ca().func_190926_b() && entity != null && !EntityMyrmexBase.haveSameHive(EntityMyrmexWorker.this, (Entity)entity) && DragonUtils.isAlive(entity) && !(entity instanceof IMob);
            }
        }));
    }

    @Override
    public boolean shouldWander() {
        return super.shouldWander() && this.canSeeSky();
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel1Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_WORKER.get(1) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_WORKER.get(1);
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel2Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_WORKER.get(2) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_WORKER.get(2);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, IafConfig.myrmexBaseAttackStrength).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.6f;
    }

    @Override
    public boolean shouldLeaveHive() {
        return !this.holdingSomething();
    }

    @Override
    public boolean shouldEnterHive() {
        return this.holdingSomething() || !this.field_70170_p.func_72935_r();
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return !this.shouldLeaveHive() && !this.holdingSomething();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
            float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
            this.func_130011_c(entityIn);
            boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
            if (this.getAnimation() == ANIMATION_STING && flag) {
                this.playStingSound();
                if (entityIn instanceof LivingEntity) {
                    ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 2));
                    this.func_70624_b((LivingEntity)entityIn);
                }
            } else {
                this.playBiteSound();
            }
            if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(Hand.MAIN_HAND) != ItemStack.field_190927_a) {
                this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
            if (!this.func_184188_bt().isEmpty()) {
                for (Entity entity : this.func_184188_bt()) {
                    entity.func_184210_p();
                }
            }
            return true;
        }
        return false;
    }

    public boolean holdingSomething() {
        return this.getHeldEntity() != null || !this.func_184586_b(Hand.MAIN_HAND).func_190926_b() || this.func_70638_az() != null;
    }

    public boolean holdingBaby() {
        return this.getHeldEntity() != null && (this.getHeldEntity() instanceof EntityMyrmexBase || this.getHeldEntity() instanceof EntityMyrmexEgg);
    }

    @Override
    public int getCasteImportance() {
        return 0;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            float radius = 1.05f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + 0.25, this.func_226281_cx_() + extraZ);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if ((double)amount >= 1.0 && !this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(Hand.MAIN_HAND) != ItemStack.field_190927_a) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if ((double)amount >= 1.0 && !this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                entity.func_184210_p();
            }
        }
        return super.func_70097_a(source, amount);
    }

    public Entity getHeldEntity() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public void onPickupItem(ItemEntity itemEntity) {
        Item item = itemEntity.func_92059_d().func_77973_b();
        if (item == IafItemRegistry.MYRMEX_JUNGLE_RESIN && this.isJungle() || item == IafItemRegistry.MYRMEX_DESERT_RESIN && !this.isJungle()) {
            PlayerEntity owner = null;
            try {
                if (itemEntity.func_200214_m() != null) {
                    owner = this.field_70170_p.func_217371_b(itemEntity.func_200214_m());
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Myrmex picked up resin that wasn't thrown!");
            }
            if (owner != null && this.getHive() != null) {
                this.getHive().modifyPlayerReputation(owner.func_110124_au(), 5);
                this.func_184185_a(SoundEvents.field_187886_fs, 1.0f, 1.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_(), 1 + this.field_70146_Z.nextInt(3)));
                }
            }
        }
    }

    public int func_213708_dV() {
        return 0;
    }

    public boolean func_213705_dZ() {
        return false;
    }
}

