/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSwarmer;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIFindMate;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIMoveToMate;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWander;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWanderHiveCenter;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.MyrmexTrades;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityMyrmexRoyal
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final ResourceLocation DESERT_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_royal_desert");
    public static final ResourceLocation JUNGLE_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_royal_jungle");
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_royal.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_royal.png");
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntityMyrmexRoyal.class, (IDataSerializer)DataSerializers.field_187198_h);
    public int releaseTicks = 0;
    public int daylightTicks = 0;
    public float flyProgress;
    public EntityMyrmexRoyal mate;
    private int hiveTicks = 0;
    private int breedingTicks = 0;
    private boolean isFlying;
    private boolean isLandNavigator;
    private boolean isMating = false;

    public EntityMyrmexRoyal(EntityType t, World worldIn) {
        super(t, worldIn);
        this.switchNavigator(true);
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel1Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_ROYAL.get(1) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_ROYAL.get(1);
    }

    @Override
    protected VillagerTrades.ITrade[] getLevel2Trades() {
        return this.isJungle() ? (VillagerTrades.ITrade[])MyrmexTrades.JUNGLE_ROYAL.get(2) : (VillagerTrades.ITrade[])MyrmexTrades.DESERT_ROYAL.get(2);
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, World world, double x, double z, Random rand) {
        BlockPos pos = new BlockPos(x, entity.func_226278_cu_(), z);
        for (int yDown = 0; yDown < 10; ++yDown) {
            if (world.func_175623_d(pos.func_177979_c(yDown))) continue;
            return pos.func_177981_b(yDown);
        }
        return pos;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return 10;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = this.createNavigator(this.field_70170_p, AdvancedPathNavigate.MovementType.CLIMBING);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new FlyMoveHelper(this);
            this.field_70699_by = this.createNavigator(this.field_70170_p, AdvancedPathNavigate.MovementType.FLYING);
            this.isLandNavigator = false;
        }
    }

    public boolean isFlying() {
        if (this.field_70170_p.field_72995_K) {
            this.isFlying = (Boolean)this.field_70180_af.func_187225_a(FLYING);
            return this.isFlying;
        }
        return this.isFlying;
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
        if (!this.field_70170_p.field_72995_K) {
            this.isFlying = flying;
        }
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("HiveTicks", this.hiveTicks);
        tag.func_74768_a("ReleaseTicks", this.releaseTicks);
        tag.func_74757_a("Flying", this.isFlying());
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.hiveTicks = tag.func_74762_e("HiveTicks");
        this.releaseTicks = tag.func_74762_e("ReleaseTicks");
        this.setFlying(tag.func_74767_n("Flying"));
    }

    public void func_70636_d() {
        boolean flying;
        super.func_70636_d();
        boolean bl = flying = this.isFlying() && !this.field_70122_E;
        if (flying && this.flyProgress < 20.0f) {
            this.flyProgress += 1.0f;
        } else if (!flying && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (flying) {
            double up = this.func_70090_H() ? 0.16 : 0.08;
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, up, 0.0));
        }
        if (flying && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!flying && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        this.daylightTicks = this.canSeeSky() ? ++this.daylightTicks : 0;
        if (flying && this.canSeeSky() && this.isBreedingSeason()) {
            ++this.releaseTicks;
        }
        if (!flying && this.canSeeSky() && this.daylightTicks > 300 && this.isBreedingSeason() && this.func_70638_az() == null && this.canMove() && this.func_233570_aj_() && !this.isMating) {
            this.setFlying(true);
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.42, 0.0));
        }
        if (this.getGrowthStage() >= 2) {
            ++this.hiveTicks;
        }
        if (this.getAnimation() == ANIMATION_BITE && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.func_70638_az() != null && this.getAnimationTick() == 6) {
            this.playStingSound();
            if (this.getAttackBounds().func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 2));
                this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76436_u, 70, 1));
            }
        }
        if (this.mate != null) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)77);
            if (this.func_70032_d((Entity)this.mate) < 10.0f) {
                this.setFlying(false);
                this.mate.setFlying(false);
                this.isMating = true;
                if (this.func_233570_aj_() && this.mate.field_70122_E) {
                    ++this.breedingTicks;
                    if (this.breedingTicks > 100) {
                        if (this.func_70089_S()) {
                            this.mate.func_70106_y();
                            this.func_70106_y();
                            EntityMyrmexQueen queen = new EntityMyrmexQueen(IafEntityRegistry.MYRMEX_QUEEN, this.field_70170_p);
                            queen.func_82149_j((Entity)this);
                            queen.setJungleVariant(this.isJungle());
                            queen.setMadeHome(false);
                            if (!this.field_70170_p.field_72995_K) {
                                this.field_70170_p.func_217376_c((Entity)queen);
                            }
                        }
                        this.isMating = false;
                    }
                }
            }
            this.mate.mate = this;
            if (!this.mate.func_70089_S()) {
                this.mate.mate = null;
                this.mate = null;
            }
        }
    }

    protected double attackDistance() {
        return 8.0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAITradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MyrmexAIMoveToMate(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (Goal)new AIFlyAtTarget());
        this.field_70714_bg.func_75776_a(2, (Goal)new AIFlyRandom());
        this.field_70714_bg.func_75776_a(3, (Goal)new MyrmexAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (Goal)new MyrmexAILeaveHive(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new MyrmexAIReEnterHive(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new MyrmexAIMoveThroughHive(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new MyrmexAIWanderHiveCenter(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new MyrmexAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MyrmexAIDefendHive(this));
        this.field_70715_bh.func_75776_a(2, new MyrmexAIFindMate(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new MyrmexAIAttackPlayers(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, true, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                if (entity instanceof EntityMyrmexBase && EntityMyrmexRoyal.this.isBreedingSeason() || entity instanceof EntityMyrmexRoyal) {
                    return false;
                }
                return entity != null && !EntityMyrmexBase.haveSameHive(EntityMyrmexRoyal.this, (Entity)entity) && DragonUtils.isAlive(entity) && !(entity instanceof IMob);
            }
        }));
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this || otherAnimal == null) {
            return false;
        }
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        if (otherAnimal instanceof EntityMyrmexBase) {
            if (((EntityMyrmexBase)otherAnimal).getHive() != null && this.getHive() != null) {
                return !this.getHive().equals(((EntityMyrmexBase)otherAnimal).getHive());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, IafConfig.myrmexBaseAttackStrength * 2.0).func_233815_a_(Attributes.field_233819_b_, 64.0).func_233815_a_(Attributes.field_233826_i_, 9.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 1.25f;
    }

    @Override
    public int getCasteImportance() {
        return 2;
    }

    @Override
    public boolean shouldLeaveHive() {
        return this.isBreedingSeason();
    }

    @Override
    public boolean shouldEnterHive() {
        return !this.isBreedingSeason();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
            return true;
        }
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }

    public boolean isBreedingSeason() {
        return this.getGrowthStage() >= 2 && (this.getHive() == null || this.getHive().reproduces);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 76) {
            this.playEffect(20);
        } else if (id == 77) {
            this.playEffect(7);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void playEffect(int hearts) {
        for (int i = 0; i < hearts; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public int func_213708_dV() {
        return 0;
    }

    public boolean func_213705_dZ() {
        return false;
    }

    protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
        Vector3d vector3d1;
        Vector3d vector3d = Vector3d.func_237489_a_((Vector3i)posVec31);
        return this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1 = Vector3d.func_237489_a_((Vector3i)posVec32), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    class AIFlyAtTarget
    extends Goal {
        public boolean func_75250_a() {
            if (EntityMyrmexRoyal.this.func_70638_az() != null && !EntityMyrmexRoyal.this.func_70605_aq().func_75640_a() && EntityMyrmexRoyal.this.field_70146_Z.nextInt(7) == 0) {
                return EntityMyrmexRoyal.this.func_70068_e((Entity)EntityMyrmexRoyal.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityMyrmexRoyal.this.func_70605_aq().func_75640_a() && EntityMyrmexRoyal.this.func_70638_az() != null && EntityMyrmexRoyal.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            LivingEntity LivingEntity2 = EntityMyrmexRoyal.this.func_70638_az();
            Vector3d Vector3d2 = LivingEntity2.func_174824_e(1.0f);
            EntityMyrmexRoyal.this.field_70765_h.func_75642_a(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c, 1.0);
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity LivingEntity2 = EntityMyrmexRoyal.this.func_70638_az();
            if (LivingEntity2 != null) {
                if (EntityMyrmexRoyal.this.func_174813_aQ().func_72326_a(LivingEntity2.func_174813_aQ())) {
                    EntityMyrmexRoyal.this.func_70652_k((Entity)LivingEntity2);
                } else {
                    double d0 = EntityMyrmexRoyal.this.func_70068_e((Entity)LivingEntity2);
                    if (d0 < 9.0) {
                        Vector3d Vector3d2 = LivingEntity2.func_174824_e(1.0f);
                        EntityMyrmexRoyal.this.field_70765_h.func_75642_a(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c, 1.0);
                    }
                }
            }
        }
    }

    class AIFlyRandom
    extends Goal {
        BlockPos target;

        public AIFlyRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (EntityMyrmexRoyal.this.isFlying() && EntityMyrmexRoyal.this.func_70638_az() == null) {
                if (EntityMyrmexRoyal.this instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner() != null) {
                    LivingEntity summon = ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner();
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((Entity)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.field_70170_p, summon.func_226277_ct_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(10) - 5.0, summon.func_226281_cx_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(10) - 5.0, EntityMyrmexRoyal.this.field_70146_Z);
                } else {
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((Entity)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.field_70170_p, EntityMyrmexRoyal.this.func_226277_ct_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(30) - 15.0, EntityMyrmexRoyal.this.func_226281_cx_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(30) - 15.0, EntityMyrmexRoyal.this.field_70146_Z);
                }
                return EntityMyrmexRoyal.this.isDirectPathBetweenPoints(EntityMyrmexRoyal.this.func_233580_cy_(), this.target) && !EntityMyrmexRoyal.this.func_70605_aq().func_75640_a() && EntityMyrmexRoyal.this.field_70146_Z.nextInt(2) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!EntityMyrmexRoyal.this.isDirectPathBetweenPoints(EntityMyrmexRoyal.this.func_233580_cy_(), this.target)) {
                if (EntityMyrmexRoyal.this instanceof EntityMyrmexSwarmer && ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner() != null) {
                    LivingEntity summon = ((EntityMyrmexSwarmer)EntityMyrmexRoyal.this).getSummoner();
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((Entity)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.field_70170_p, summon.func_226277_ct_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(10) - 5.0, summon.func_226281_cx_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(10) - 5.0, EntityMyrmexRoyal.this.field_70146_Z);
                } else {
                    this.target = EntityMyrmexRoyal.getPositionRelativetoGround((Entity)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.field_70170_p, EntityMyrmexRoyal.this.func_226277_ct_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(30) - 15.0, EntityMyrmexRoyal.this.func_226281_cx_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(30) - 15.0, EntityMyrmexRoyal.this.field_70146_Z);
                }
            }
            if (EntityMyrmexRoyal.this.field_70170_p.func_175623_d(this.target)) {
                EntityMyrmexRoyal.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityMyrmexRoyal.this.func_70638_az() == null) {
                    EntityMyrmexRoyal.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class FlyMoveHelper
    extends MovementController {
        public FlyMoveHelper(EntityMyrmexRoyal pixie) {
            super((MobEntity)pixie);
            this.field_75645_e = 1.75;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                if (EntityMyrmexRoyal.this.field_70123_F) {
                    EntityMyrmexRoyal.this.field_70177_z += 180.0f;
                    this.field_75645_e = 0.1f;
                    BlockPos target = EntityMyrmexRoyal.getPositionRelativetoGround((Entity)EntityMyrmexRoyal.this, EntityMyrmexRoyal.this.field_70170_p, EntityMyrmexRoyal.this.func_226277_ct_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(15) - 7.0, EntityMyrmexRoyal.this.func_226281_cx_() + (double)EntityMyrmexRoyal.this.field_70146_Z.nextInt(15) - 7.0, EntityMyrmexRoyal.this.field_70146_Z);
                    this.field_75646_b = target.func_177958_n();
                    this.field_75647_c = target.func_177956_o();
                    this.field_75644_d = target.func_177952_p();
                }
                double d0 = this.field_75646_b - EntityMyrmexRoyal.this.func_226277_ct_();
                double d1 = this.field_75647_c - EntityMyrmexRoyal.this.func_226278_cu_();
                double d2 = this.field_75644_d - EntityMyrmexRoyal.this.func_226281_cx_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityMyrmexRoyal.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityMyrmexRoyal.this.func_213317_d(EntityMyrmexRoyal.this.func_213322_ci().func_216372_d(0.5, 0.5, 0.5));
                } else {
                    EntityMyrmexRoyal.this.func_213317_d(EntityMyrmexRoyal.this.func_213322_ci().func_72441_c(d0 / d3 * 0.1 * this.field_75645_e, d1 / d3 * 0.1 * this.field_75645_e, d2 / d3 * 0.1 * this.field_75645_e));
                    if (EntityMyrmexRoyal.this.func_70638_az() == null) {
                        EntityMyrmexRoyal.this.field_70761_aq = EntityMyrmexRoyal.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityMyrmexRoyal.this.func_213322_ci().field_72450_a, (double)EntityMyrmexRoyal.this.func_213322_ci().field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityMyrmexRoyal.this.func_70638_az().func_226277_ct_() - EntityMyrmexRoyal.this.func_226277_ct_();
                        double d5 = EntityMyrmexRoyal.this.func_70638_az().func_226281_cx_() - EntityMyrmexRoyal.this.func_226281_cx_();
                        EntityMyrmexRoyal.this.field_70761_aq = EntityMyrmexRoyal.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

