/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityDragonSkull
extends AnimalEntity
implements IBlacklistedFromStatues,
IDeadMob {
    private static final DataParameter<Integer> DRAGON_TYPE = EntityDataManager.func_187226_a(EntityDragonSkull.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DRAGON_AGE = EntityDataManager.func_187226_a(EntityDragonSkull.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DRAGON_STAGE = EntityDataManager.func_187226_a(EntityDragonSkull.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DRAGON_DIRECTION = EntityDataManager.func_187226_a(EntityDragonSkull.class, (IDataSerializer)DataSerializers.field_187193_c);
    public final float minSize = 0.3f;
    public final float maxSize = 8.58f;

    public EntityDragonSkull(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70158_ak = true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.0);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_180431_b(DamageSource i) {
        return i.func_76346_g() != null && super.func_180431_b(i);
    }

    public boolean func_175446_cd() {
        return true;
    }

    public boolean isOnWall() {
        return this.field_70170_p.func_175623_d(this.func_233580_cy_().func_177977_b());
    }

    public void onUpdate() {
        this.field_70760_ar = 0.0f;
        this.field_70758_at = 0.0f;
        this.field_70761_aq = 0.0f;
        this.field_70759_as = 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DRAGON_TYPE, (Object)0);
        this.func_184212_Q().func_187214_a(DRAGON_AGE, (Object)0);
        this.func_184212_Q().func_187214_a(DRAGON_STAGE, (Object)0);
        this.func_184212_Q().func_187214_a(DRAGON_DIRECTION, (Object)Float.valueOf(0.0f));
    }

    public float getYaw() {
        return ((Float)this.func_184212_Q().func_187225_a(DRAGON_DIRECTION)).floatValue();
    }

    public void setYaw(float var1) {
        this.func_184212_Q().func_187227_b(DRAGON_DIRECTION, (Object)Float.valueOf(var1));
    }

    public int getDragonType() {
        return (Integer)this.func_184212_Q().func_187225_a(DRAGON_TYPE);
    }

    public void setDragonType(int var1) {
        this.func_184212_Q().func_187227_b(DRAGON_TYPE, (Object)var1);
    }

    public int getStage() {
        return (Integer)this.func_184212_Q().func_187225_a(DRAGON_STAGE);
    }

    public void setStage(int var1) {
        this.func_184212_Q().func_187227_b(DRAGON_STAGE, (Object)var1);
    }

    public int getDragonAge() {
        return (Integer)this.func_184212_Q().func_187225_a(DRAGON_AGE);
    }

    public void setDragonAge(int var1) {
        this.func_184212_Q().func_187227_b(DRAGON_AGE, (Object)var1);
    }

    public SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return null;
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        this.turnIntoItem();
        return super.func_70097_a(var1, var2);
    }

    public void turnIntoItem() {
        if (this.field_70128_L) {
            return;
        }
        this.func_70106_y();
        ItemStack stack = new ItemStack((IItemProvider)this.getDragonSkullItem());
        stack.func_77982_d(new CompoundNBT());
        stack.func_77978_p().func_74768_a("Stage", this.getStage());
        stack.func_77978_p().func_74768_a("DragonAge", this.getDragonAge());
        if (!this.field_70170_p.field_72995_K) {
            this.func_70099_a(stack, 0.0f);
        }
    }

    public Item getDragonSkullItem() {
        switch (this.getDragonType()) {
            case 0: {
                return IafItemRegistry.DRAGON_SKULL_FIRE;
            }
            case 1: {
                return IafItemRegistry.DRAGON_SKULL_ICE;
            }
            case 2: {
                return IafItemRegistry.DRAGON_SKULL_LIGHTNING;
            }
        }
        return IafItemRegistry.DRAGON_SKULL_FIRE;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageable) {
        return null;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (player.func_225608_bj_()) {
            this.setYaw(player.field_70177_z);
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setDragonType(compound.func_74762_e("Type"));
        this.setStage(compound.func_74762_e("Stage"));
        this.setDragonAge(compound.func_74762_e("DragonAge"));
        this.setYaw(compound.func_74760_g("DragonYaw"));
        super.func_70037_a(compound);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Type", this.getDragonType());
        compound.func_74768_a("Stage", this.getStage());
        compound.func_74768_a("DragonAge", this.getDragonAge());
        compound.func_74776_a("DragonYaw", this.getYaw());
        super.func_213281_b(compound);
    }

    public float getDragonSize() {
        float step = -0.06624f;
        if (this.getDragonAge() > 125) {
            return this.minSize + step * 125.0f;
        }
        return this.minSize + step * (float)this.getDragonAge();
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    @Override
    public boolean isMobDead() {
        return true;
    }

    public int getDragonStage() {
        return Math.max(this.getStage(), 1);
    }

    public boolean func_104002_bU() {
        return true;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

