/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.github.alexthe666.iceandfire.entity.IafDragonDestructionManager;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.IDragonProjectile;
import com.github.alexthe666.iceandfire.misc.IafDamageRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityDragonIceCharge
extends AbstractFireballEntity
implements IDragonProjectile {
    public int ticksInAir;

    public EntityDragonIceCharge(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public EntityDragonIceCharge(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(IafEntityRegistry.ICE_DRAGON_CHARGE, worldIn);
    }

    public EntityDragonIceCharge(EntityType type, World worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(type, posX, posY, posZ, accelX, accelY, accelZ, worldIn);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.07;
        this.field_70233_c = accelY / d0 * 0.07;
        this.field_70230_d = accelZ / d0 * 0.07;
    }

    public EntityDragonIceCharge(EntityType type, World worldIn, EntityDragonBase shooter, double accelX, double accelY, double accelZ) {
        super(type, (LivingEntity)shooter, accelX, accelY, accelZ, worldIn);
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.07;
        this.field_70233_c = accelY / d0 * 0.07;
        this.field_70230_d = accelZ / d0 * 0.07;
    }

    protected boolean func_184564_k() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70071_h_() {
        Entity shootingEntity = this.func_234616_v_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 14; ++i) {
                IceAndFire.PROXY.spawnParticle("dragonice", this.func_226277_ct_() + this.field_70146_Z.nextDouble() * 1.0 * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 1.0 * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1), this.func_226281_cx_() + this.field_70146_Z.nextDouble() * 1.0 * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1), 0.0, 0.0, 0.0);
            }
        }
        if (this.field_70170_p.field_72995_K || (shootingEntity == null || shootingEntity.func_70089_S()) && this.field_70170_p.func_175667_e(this.func_233580_cy_())) {
            super.func_70071_h_();
            ++this.ticksInAir;
            Vector3d Vector3d2 = this.func_213322_ci();
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::canHitMob);
            if (!this.field_70170_p.field_72995_K && raytraceresult != null) {
                this.func_70227_a(raytraceresult);
            }
            double d0 = this.func_226277_ct_() + Vector3d2.field_72450_a;
            double d1 = this.func_226278_cu_() + Vector3d2.field_72448_b;
            double d2 = this.func_226281_cx_() + Vector3d2.field_72449_c;
            float f = MathHelper.func_76133_a((double)EntityDragonIceCharge.func_213296_b((Vector3d)Vector3d2));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72450_a, (double)Vector3d2.field_72449_c) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)Vector3d2.field_72448_b, (double)f) * 57.2957763671875);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
            float f1 = 0.99f;
            float f2 = 0.06f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() - this.func_213322_ci().field_72450_a * 0.25, this.func_226278_cu_() - this.func_213322_ci().field_72448_b * 0.25, this.func_226281_cx_() - this.func_213322_ci().field_72449_c * 0.25, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                }
                f = 0.8f;
            }
            this.func_70107_b(d0, d1, d2);
            this.field_70170_p.func_195594_a(this.func_195057_f(), this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        } else {
            this.func_70106_y();
        }
    }

    protected boolean canHitMob(Entity hitMob) {
        Entity shooter = this.func_234616_v_();
        return hitMob != this && super.func_230298_a_(hitMob) && shooter != null && !hitMob.func_184191_r(shooter) && !(hitMob instanceof EntityDragonPart);
    }

    protected void func_70227_a(RayTraceResult movingObject) {
        Entity shootingEntity = this.func_234616_v_();
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
        if (!this.field_70170_p.field_72995_K && movingObject.func_216346_c() == RayTraceResult.Type.ENTITY) {
            EntityDragonBase dragon;
            Entity entity = ((EntityRayTraceResult)movingObject).func_216348_a();
            if (entity != null && entity instanceof IDragonProjectile) {
                return;
            }
            if (entity != null && shootingEntity != null && shootingEntity instanceof EntityDragonBase && entity != null && ((dragon = (EntityDragonBase)shootingEntity).func_184191_r(entity) || dragon.func_70028_i(entity) || dragon.isPart(entity))) {
                return;
            }
            if (entity == null || !(entity instanceof IDragonProjectile) && entity != shootingEntity && shootingEntity instanceof EntityDragonBase) {
                dragon = (EntityDragonBase)shootingEntity;
                if (shootingEntity != null && (entity == shootingEntity || entity instanceof TameableEntity && ((EntityDragonBase)shootingEntity).func_152114_e(((EntityDragonBase)shootingEntity).func_70902_q()))) {
                    return;
                }
                if (dragon != null) {
                    dragon.randomizeAttacks();
                }
                this.func_70106_y();
            }
            if (entity != null && !(entity instanceof IDragonProjectile) && !entity.func_70028_i(shootingEntity)) {
                if (shootingEntity != null && (entity.func_70028_i(shootingEntity) || shootingEntity instanceof EntityDragonBase & entity instanceof TameableEntity && ((EntityDragonBase)shootingEntity).func_70902_q() == ((TameableEntity)entity).func_70902_q())) {
                    return;
                }
                if (shootingEntity != null && shootingEntity instanceof EntityDragonBase) {
                    float damageAmount = (float)IafConfig.dragonAttackDamageIce * (float)((EntityDragonBase)shootingEntity).getDragonStage();
                    entity.func_70097_a(IafDamageRegistry.DRAGON_ICE, damageAmount);
                    if (entity instanceof LivingEntity && ((LivingEntity)entity).func_110143_aJ() == 0.0f) {
                        ((EntityDragonBase)shootingEntity).randomizeAttacks();
                    }
                }
                if (shootingEntity instanceof LivingEntity) {
                    this.func_174815_a((LivingEntity)shootingEntity, entity);
                }
                this.func_70106_y();
            }
        }
        if (movingObject.func_216346_c() != RayTraceResult.Type.MISS) {
            if (shootingEntity instanceof EntityDragonBase && IafConfig.dragonGriefing != 2 && !this.func_70090_H()) {
                IafDragonDestructionManager.destroyAreaIceCharge(this.field_70170_p, this.func_233580_cy_(), (EntityDragonBase)shootingEntity);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

