/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.network.MessageReceiveData;
import mcp.mobius.waila.utils.NBTUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageRequestEntity
implements IMessage {
    public int dim;
    public int entityId;
    public Set<String> keys = Sets.newHashSet();

    public MessageRequestEntity() {
    }

    public MessageRequestEntity(Entity entity, Set<String> keys) {
        this.dim = entity.func_130014_f_().field_73011_w.getDimension();
        this.entityId = entity.func_145782_y();
        this.keys = keys;
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.entityId = buf.readInt();
        int nKeys = buf.readInt();
        for (int i = 0; i < nKeys; ++i) {
            this.keys.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.entityId);
        buf.writeInt(this.keys.size());
        for (String key : this.keys) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)key);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageRequestEntity, IMessage> {
        public IMessage onMessage(MessageRequestEntity message, MessageContext ctx) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            server.func_152344_a(() -> {
                WorldServer world = DimensionManager.getWorld((int)message.dim);
                Entity entity = world.func_73045_a(message.entityId);
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (entity == null) {
                    return;
                }
                NBTTagCompound tag = new NBTTagCompound();
                if (ModuleRegistrar.instance().hasNBTEntityProviders(entity)) {
                    for (List<IWailaEntityProvider> providersList : ModuleRegistrar.instance().getNBTEntityProviders(entity).values()) {
                        for (IWailaEntityProvider provider : providersList) {
                            tag = provider.getNBTData(player, entity, tag, (World)world);
                        }
                    }
                } else {
                    entity.func_189511_e(tag);
                    tag = NBTUtil.createTag(tag, message.keys);
                }
                tag.func_74768_a("WailaEntityID", entity.func_145782_y());
                Waila.NETWORK_WRAPPER.sendTo((IMessage)new MessageReceiveData(tag), player);
            });
            return null;
        }
    }
}

