/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.configs;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.headcrumbs.Headcrumbs;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public Configuration configFile;
    public String[] usedCategories = new String[]{"general", "heads", "mob"};

    public void init(File file) {
        this.configFile = new Configuration(file);
        this.syncConfigs();
    }

    private void syncConfigs() {
        Headcrumbs.enableRandomHeadDrop = this.configFile.get("general", "Heads drop randomly", Headcrumbs.enableRandomHeadDrop, "Heads will drop randomly when entities or players die").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.enableVanillaHeadsDrop = this.configFile.get("general", "Vanilla heads drop randomly", Headcrumbs.enableVanillaHeadsDrop, "Vanilla Heads (creeper, skeleton, zombie) will drop randomly when entities die").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.addPlayerHeadsAsDungeonLoot = this.configFile.get("general", "Add player heads as dungeon loot", Headcrumbs.addPlayerHeadsAsDungeonLoot).setRequiresMcRestart(false).getBoolean();
        Headcrumbs.enableMobsAndAnimalHeads = this.configFile.get("general", "Enable mobs and animals heads", Headcrumbs.enableMobsAndAnimalHeads, "Setting this to false will cause only player heads to show in the creative tab and drop updon death").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.hidePlayerHeadsFromTab = this.configFile.get("general", "Hide player heads from tab", Headcrumbs.hidePlayerHeadsFromTab, "Setting this to true will hide the named player heads from the creative tab and NEI").setRequiresMcRestart(true).getBoolean();
        Headcrumbs.enableChargedCreeperKills = this.configFile.get("general", "Enable charged creeper kills", Headcrumbs.enableChargedCreeperKills, "Setting this to true will cause heads to drop 100% of the time when an entity is killed by a charged creeper").setRequiresMcRestart(true).getBoolean();
        Headcrumbs.enablePlayerStatues = this.configFile.get("general", "Enable player statues", Headcrumbs.enablePlayerStatues, "Setting this to true allow statues to be built (Turning this off won't destroy existing statues)").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.enableTooltips = this.configFile.get("general", "Enable head item tooltips", Headcrumbs.enableTooltips, "Enables tooltips with informations about certain names (mod authors mostly)").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.enableHeadConversion = this.configFile.get("general", "Enable head conversions", Headcrumbs.enableHeadConversion, "Enables recipes to convert from the vanilla player heads to the Headcrumbs' player head ad vice versa").setRequiresMcRestart(true).getBoolean();
        Headcrumbs.headDropChance = this.configFile.get("general", "Chance of random head drop", Headcrumbs.headDropChance, "Random.nextInt(X / (fortune+1)) == 0").setRequiresMcRestart(false).getInt();
        Headcrumbs.headsDungeonLootMaxWeight = this.configFile.get("general", "Player heads loot weight", Headcrumbs.headsDungeonLootMaxWeight, "The bigger this number the easier it will be to find heads in dungeons.\nSome heads will be rarer than others.\nExamples: Diamond is 1, Redstone is 10").setRequiresMcRestart(true).getInt();
        Headcrumbs.others = this.configFile.get("heads", "others", Headcrumbs.others).setRequiresMcRestart(true).getStringList();
        Headcrumbs.modders = this.configFile.get("heads", "modders", Headcrumbs.modders).setRequiresMcRestart(true).getStringList();
        Headcrumbs.youtubers = this.configFile.get("heads", "youtubers", Headcrumbs.youtubers).setRequiresMcRestart(true).getStringList();
        Headcrumbs.mojang = this.configFile.get("heads", "mojang", Headcrumbs.mojang).setRequiresMcRestart(true).getStringList();
        Headcrumbs.mindCrack = this.configFile.get("heads", "mindCrack", Headcrumbs.mindCrack).setRequiresMcRestart(true).getStringList();
        Headcrumbs.hermitcraft = this.configFile.get("heads", "hermitcraft", Headcrumbs.hermitcraft).setRequiresMcRestart(true).getStringList();
        Headcrumbs.forgeCraft = this.configFile.get("heads", "forgeCraft", Headcrumbs.forgeCraft).setRequiresMcRestart(true).getStringList();
        Headcrumbs.ftb = this.configFile.get("heads", "ftb", Headcrumbs.ftb).setRequiresMcRestart(true).getStringList();
        Headcrumbs.technic = this.configFile.get("heads", "technic", Headcrumbs.technic).setRequiresMcRestart(true).getStringList();
        Headcrumbs.enableModSent = this.configFile.get("heads", "Enable usernames sent by other mods", Headcrumbs.enableModSent, "Other mods can add usernames using inter-mod communications, turns this config to false will prevent that from happening").setRequiresMcRestart(true).getBoolean();
        Headcrumbs.enableHumanMobs = this.configFile.get("mob", "Enable celebrity mobs", Headcrumbs.enableHumanMobs).setRequiresMcRestart(true).getBoolean();
        Headcrumbs.enableVIPs = this.configFile.get("mob", "Enable VIP drops", Headcrumbs.enableVIPs, "Setting this to false will disable special drops/weapons for certain celebrities. Existing mobs will still hold the weapons they spawned with.").setRequiresMcRestart(true).getBoolean();
        Headcrumbs.enableBaarbra = this.configFile.get("mob", "Disable Baarbra", Headcrumbs.enableBaarbra, "Setting this to false will cause Baarbra (or other mobs that VIPs mount) to no longer show up )=").setRequiresMcRestart(false).getBoolean();
        Headcrumbs.celebrityProb = this.configFile.get("mob", "Spawn probability", Headcrumbs.celebrityProb, "The change the mob will spawn. Base values: zombies, skeletons, spider, creepers = 100, endermen = 10, witches = 5").setRequiresMcRestart(true).getInt();
        Headcrumbs.celebrityMin = this.configFile.get("mob", "Minimum group size", Headcrumbs.celebrityMin, "The minimum size of the group of mobs that will spawn at once").setRequiresMcRestart(true).getInt();
        Headcrumbs.celebrityMax = this.configFile.get("mob", "Maximum group size", Headcrumbs.celebrityMax, "The maximum size of the group of mobs that will spawn at once").setRequiresMcRestart(true).getInt();
        Headcrumbs.blacklistedDimensions = this.configFile.get("mob", "Dimension Blacklist", Headcrumbs.blacklistedDimensions).getIntList();
        Headcrumbs.humanNamePrefix = this.configFile.get("mob", "prefix", Headcrumbs.humanNamePrefix, "This prefix will be shown in front of celebrities names in-world. Meant to be used to differentiate celebrities from real players.").getString();
        Headcrumbs.humansOpenDoors = this.configFile.get("mob", "Allow celebrity mobs to open doors", Headcrumbs.humansOpenDoors).setRequiresMcRestart(true).getBoolean();
        Headcrumbs.babyHumanChance = this.configFile.get("mob", "Baby human chance", Headcrumbs.babyHumanChance, "Chance that a human mob will spawn as a baby. Set to -1 to disable.").setRequiresMcRestart(false).getDouble(Headcrumbs.babyHumanChance);
        Headcrumbs.humansAttackTwins = this.configFile.get("mob", "Humans attack twins", Headcrumbs.humansAttackTwins, "Setting this to false will force humans to not attack players with the same name as themselves").setRequiresMcRestart(true).getBoolean();
        String block = this.configFile.get("general", "Statue block material", Block.field_149771_c.func_148750_c((Object)Blocks.field_150435_aG), "modId:name. Whatever block is set here will be the block used to make player statues (2 tall and right-click the top one with a player head)").getString();
        Headcrumbs.clay = (Block)Block.field_149771_c.func_82594_a(block);
        if (Headcrumbs.clay == null || Headcrumbs.clay == Blocks.field_150350_a) {
            Headcrumbs.clay = Blocks.field_150435_aG;
        }
        if (this.configFile.hasChanged()) {
            this.configFile.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("headcrumbs".equals(eventArgs.modID)) {
            this.syncConfigs();
        }
    }
}

