/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.blocks;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockSkull;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.Utils;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import thaumcraft.api.crafting.IInfusionStabiliser;

@Optional.Interface(iface="thaumcraft.api.crafting.IInfusionStabiliser", modid="Thaumcraft")
public class BlockSkull
extends BlockContainer
implements IInfusionStabiliser {
    public BlockSkull() {
        this(Material.field_151594_q);
        this.func_149663_c(Utils.getUnlocalisedName("betterSkull"));
    }

    protected BlockSkull(Material material) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(field_149780_i);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canStabaliseInfusion(World world, int x, int y, int z) {
        return true;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z) & 7;
        switch (meta) {
            default: {
                this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                break;
            }
            case 2: {
                this.func_149676_a(0.25f, 0.25f, 0.5f, 0.75f, 0.75f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.5f);
                break;
            }
            case 4: {
                this.func_149676_a(0.5f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.25f, 0.25f, 0.5f, 0.75f, 0.75f);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        world.func_72921_c(x, y, z, MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3, 2);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBlockSkull();
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return ModItems.skull;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        ItemStack stack = new ItemStack(item, 1, this.func_149643_k(world, x, y, z));
        TileEntityBlockSkull tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBlockSkull.class);
        if (tile != null && (tile.func_145904_a() == SkullTypes.player.ordinal() || tile.func_145904_a() == SkullTypes.lycanites.ordinal()) && tile.func_152108_a() != null) {
            stack = HeadUtils.createHeadFor(tile.func_152108_a());
            stack.func_77964_b(tile.func_145904_a());
        }
        return stack;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile != null && tile instanceof TileEntityBlockSkull ? ((TileEntityBlockSkull)tile).func_145904_a() : super.func_149643_k(world, x, y, z);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        ArrayList<ItemStack> drops;
        if (!player.field_71075_bZ.field_75098_d && ForgeEventFactory.fireBlockHarvesting(drops = this.getDrops(world, x, y, z, meta, 0), (World)world, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player) > 0.0f) {
            for (ItemStack stack : drops) {
                Utils.dropStack(world, x, y, z, stack);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        TileEntityBlockSkull tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBlockSkull.class);
        if (tile == null) {
            return drops;
        }
        ItemStack stack = new ItemStack(ModItems.skull, 1, tile.func_145904_a());
        if ((tile.func_145904_a() == SkullTypes.player.ordinal() || tile.func_145904_a() == SkullTypes.lycanites.ordinal()) && tile.func_152108_a() != null) {
            stack = HeadUtils.createHeadFor(tile.func_152108_a());
            stack.func_77964_b(tile.func_145904_a());
        }
        drops.add(stack);
        return drops;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150425_aM.func_149733_h(side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149702_O() {
        return Blocks.field_150465_bP.func_149702_O();
    }
}

