/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.init;

import growthcraft.api.cellar.booze.Booze;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.cellar.util.ICellarBoozeBuilder;
import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.GrcFluid;
import growthcraft.api.core.effect.EffectExtinguish;
import growthcraft.api.core.effect.EffectList;
import growthcraft.api.core.effect.EffectUtils;
import growthcraft.api.core.fluids.TaggedFluidStacks;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.util.StringUtils;
import growthcraft.api.core.util.TickUtils;
import growthcraft.api.milk.MilkFluidTags;
import growthcraft.api.milk.MilkRegistry;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.block.BlockFluidBooze;
import growthcraft.cellar.common.definition.BlockBoozeDefinition;
import growthcraft.cellar.common.definition.ItemBucketBoozeDefinition;
import growthcraft.cellar.common.item.EnumYeast;
import growthcraft.cellar.common.item.ItemBoozeBottle;
import growthcraft.cellar.util.BoozeRegistryHelper;
import growthcraft.cellar.util.BoozeUtils;
import growthcraft.core.common.GrcModuleBase;
import growthcraft.core.common.block.GrcBlockFluid;
import growthcraft.core.common.definition.ItemDefinition;
import growthcraft.core.common.definition.ItemTypeDefinition;
import growthcraft.core.common.item.ItemFoodBottleFluid;
import growthcraft.core.eventhandler.EventHandlerBucketFill;
import growthcraft.core.integration.forestry.ForestryFluids;
import growthcraft.core.util.FluidFactory;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.effect.EffectEvilBoozeMilk;
import growthcraft.milk.common.effect.EffectMilk;
import growthcraft.milk.common.item.EnumCheeseType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GrcMilkFluids
extends GrcModuleBase {
    private static final String kumisBasename = "grcmilk.Kumis";
    public FluidFactory.FluidDetails butterMilk;
    public FluidFactory.FluidDetails cream;
    public FluidFactory.FluidDetails milk;
    public FluidFactory.FluidDetails curds;
    public FluidFactory.FluidDetails rennet;
    public FluidFactory.FluidDetails skimMilk;
    public FluidFactory.FluidDetails whey;
    public FluidFactory.FluidDetails pasteurizedMilk;
    public Map<EnumCheeseType, FluidFactory.FluidDetails> cheeses = new HashMap<EnumCheeseType, FluidFactory.FluidDetails>();
    public Map<Fluid, EnumCheeseType> fluidToCheeseType = new HashMap<Fluid, EnumCheeseType>();
    public Booze[] kumisFluids = new Booze[6];
    public BlockBoozeDefinition[] kumisFluidBlocks = new BlockBoozeDefinition[this.kumisFluids.length];
    public ItemBucketBoozeDefinition[] kumisFluidBuckets = new ItemBucketBoozeDefinition[this.kumisFluids.length];
    public ItemDefinition kumisBottle;

    private void preInitCheeseFluids() {
        for (EnumCheeseType cheese : EnumCheeseType.VALUES) {
            String fluidName = "grcmilk.Cheese" + StringUtils.capitalize(cheese.name);
            GrcFluid fluid = new GrcFluid(fluidName).setColor(cheese.getColor());
            FluidFactory.FluidDetails details = FluidFactory.instance().create(fluid, 0);
            this.cheeses.put(cheese, details);
            if (details.block != null) {
                ((GrcBlockFluid)((Object)details.block.getBlock())).setColor(cheese.getColor()).func_149658_d("grcmilk:fluids/milk");
            }
            details.setItemColor(cheese.getColor());
            this.fluidToCheeseType.put(fluid, cheese);
        }
    }

    private void preInitKumisFluids() {
        this.kumisBottle = new ItemDefinition((Item)new ItemBoozeBottle(this.kumisFluids));
        BoozeRegistryHelper.initializeBoozeFluids(kumisBasename, this.kumisFluids);
        for (Booze booze : this.kumisFluids) {
            booze.setColor(GrowthCraftMilk.getConfig().kumisColor).setDensity(1030).setViscosity(3000);
        }
        BoozeRegistryHelper.initializeBooze(this.kumisFluids, this.kumisFluidBlocks, this.kumisFluidBuckets);
        BoozeRegistryHelper.setBoozeFoodStats(this.kumisFluids, 1, -0.2f);
        BoozeRegistryHelper.setBoozeFoodStats(this.kumisFluids[0], 1, 0.2f);
        this.kumisFluids[5].setColor(GrowthCraftMilk.getConfig().poisonedKumisColor);
        ((BlockFluidBooze)((Object)this.kumisFluidBlocks[5].getBlock())).refreshColor();
        for (BlockBoozeDefinition def : this.kumisFluidBlocks) {
            ((BlockFluidBooze)((Object)def.getBlock())).func_149658_d("grcmilk:fluids/milk");
        }
    }

    private void preInitFluids() {
        EffectMilk milkEffect = EffectMilk.create(GrowthCraftCellar.potionTipsy);
        if (GrowthCraftMilk.getConfig().milkEnabled) {
            this.milk = FluidFactory.instance().create(new GrcFluid("grcmilk.Milk").setDensity(1030).setViscosity(3000), 5);
            this.milk.foodBottle = new ItemTypeDefinition<ItemFoodBottleFluid>(new ItemFoodBottleFluid(this.milk.getFluid(), 4, 0.3f, false));
            this.milk.foodBottle.getItem().setEffect(milkEffect).func_77848_i();
            this.milk.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(0xFFFFFF);
            ((GrcBlockFluid)((Object)this.milk.block.getBlock())).func_149658_d("grcmilk:fluids/milk");
        }
        this.butterMilk = FluidFactory.instance().create(new GrcFluid("grcmilk.ButterMilk"), 13);
        this.butterMilk.foodBottle = new ItemTypeDefinition<ItemFoodBottleFluid>(new ItemFoodBottleFluid(this.butterMilk.getFluid(), 6, 0.4f, false));
        EffectList list = new EffectList();
        list.add(milkEffect);
        if (GrowthCraftMilk.getConfig().fantasyMilkEffects) {
            list.add(new EffectExtinguish());
            list.add(EffectUtils.createAddPotionEffect(Potion.field_76426_n, TickUtils.seconds(15), 0));
        }
        this.butterMilk.foodBottle.getItem().setEffect(list).func_77848_i();
        this.butterMilk.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(0xFFFEE7);
        ((GrcBlockFluid)((Object)this.butterMilk.block.getBlock())).func_149658_d("grcmilk:fluids/buttermilk");
        this.cream = FluidFactory.instance().create(new GrcFluid("grcmilk.Cream"));
        this.cream.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(0xFFFDD0);
        ((GrcBlockFluid)((Object)this.cream.block.getBlock())).func_149658_d("grcmilk:fluids/cream");
        this.curds = FluidFactory.instance().create(new GrcFluid("grcmilk.Curds"));
        this.curds.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(0xFFFFF6);
        ((GrcBlockFluid)((Object)this.curds.block.getBlock())).func_149658_d("grcmilk:fluids/milk");
        this.rennet = FluidFactory.instance().create(new GrcFluid("grcmilk.Rennet"));
        this.rennet.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(8876611);
        ((GrcBlockFluid)((Object)this.rennet.block.getBlock())).func_149658_d("grcmilk:fluids/rennet");
        this.skimMilk = FluidFactory.instance().create(new GrcFluid("grcmilk.SkimMilk"), 13);
        this.skimMilk.foodBottle = new ItemTypeDefinition<ItemFoodBottleFluid>(new ItemFoodBottleFluid(this.skimMilk.getFluid(), 2, 0.2f, false));
        list = new EffectList();
        list.add(milkEffect);
        if (GrowthCraftMilk.getConfig().fantasyMilkEffects) {
            list.add(EffectUtils.createAddPotionEffect(Potion.field_76424_c, TickUtils.seconds(15), 0));
        }
        this.skimMilk.foodBottle.getItem().setEffect(list).func_77848_i();
        this.skimMilk.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(0xFFFFFA);
        ((GrcBlockFluid)((Object)this.skimMilk.block.getBlock())).func_149658_d("grcmilk:fluids/skimmilk");
        this.whey = FluidFactory.instance().create(new GrcFluid("grcmilk.Whey"), 13);
        this.whey.foodBottle = new ItemTypeDefinition<ItemFoodBottleFluid>(new ItemFoodBottleFluid(this.whey.getFluid(), 1, 0.1f, false));
        list = new EffectList();
        if (GrowthCraftMilk.getConfig().fantasyMilkEffects) {
            list.add(EffectUtils.createAddPotionEffect(Potion.field_76420_g, TickUtils.seconds(10), 0));
            list.add(EffectUtils.createAddPotionEffect(Potion.field_76429_m, TickUtils.seconds(10), 0));
        }
        this.whey.foodBottle.getItem().setEffect(list).func_77848_i();
        this.whey.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(9742432);
        ((GrcBlockFluid)((Object)this.whey.block.getBlock())).func_149658_d("grcmilk:fluids/whey");
        this.pasteurizedMilk = FluidFactory.instance().create(new GrcFluid("grcmilk.PasteurizedMilk"));
        this.pasteurizedMilk.setCreativeTab(GrowthCraftMilk.creativeTab).setItemColor(0xFFFFFA);
        ((GrcBlockFluid)((Object)this.pasteurizedMilk.block.getBlock())).func_149658_d("grcmilk:fluids/milk");
        this.preInitCheeseFluids();
        this.preInitKumisFluids();
    }

    @Override
    public void preInit() {
        this.preInitFluids();
    }

    public List<Fluid> getMilkFluids() {
        Fluid fluidmilk;
        ArrayList<Fluid> milks = new ArrayList<Fluid>();
        if (this.milk != null) {
            milks.add(this.milk.getFluid());
        }
        if (ForestryFluids.MILK.exists()) {
            milks.add(ForestryFluids.MILK.getFluid());
        }
        if ((fluidmilk = FluidRegistry.getFluid((String)"fluidmilk")) != null) {
            milks.add(fluidmilk);
        }
        return milks;
    }

    private void registerOres() {
        if (this.milk != null) {
            OreDictionary.registerOre((String)"bottleMilk", (ItemStack)this.milk.foodBottle.asStack());
        }
        OreDictionary.registerOre((String)"bucketMilk", (Item)Items.field_151117_aB);
        if (this.skimMilk != null) {
            OreDictionary.registerOre((String)"bottleSkimmilk", (ItemStack)this.skimMilk.foodBottle.asStack());
            OreDictionary.registerOre((String)"bucketSkimmilk", (ItemStack)this.skimMilk.bucket.asStack());
        }
        if (this.butterMilk != null) {
            OreDictionary.registerOre((String)"bottleButtermilk", (ItemStack)this.butterMilk.foodBottle.asStack());
            OreDictionary.registerOre((String)"bucketButtermilk", (ItemStack)this.butterMilk.bucket.asStack());
        }
        if (this.whey != null) {
            OreDictionary.registerOre((String)"bottleWhey", (ItemStack)this.whey.foodBottle.asStack());
            OreDictionary.registerOre((String)"bucketWhey", (ItemStack)this.whey.bucket.asStack());
            OreDictionary.registerOre((String)"foodStock", (ItemStack)this.whey.foodBottle.asStack());
        }
        if (this.cream != null) {
            OreDictionary.registerOre((String)"bottleCream", (ItemStack)this.cream.bottle.asStack());
            OreDictionary.registerOre((String)"bucketCream", (ItemStack)this.cream.bucket.asStack());
        }
    }

    private void registerFermentations() {
        EffectMilk milkEffect = EffectMilk.create(GrowthCraftCellar.potionTipsy);
        EffectEvilBoozeMilk evilMilkEffect = new EffectEvilBoozeMilk();
        FluidStack[] fs = new FluidStack[this.kumisFluids.length];
        for (int i = 0; i < this.kumisFluids.length; ++i) {
            fs[i] = new FluidStack((Fluid)this.kumisFluids[i], 1);
        }
        int fermentTime = GrowthCraftCellar.getConfig().fermentTime;
        ICellarBoozeBuilder builder = GrowthCraftCellar.boozeBuilderFactory.create(this.kumisFluids[0]);
        builder.tags(BoozeTag.FERMENTED).getEffect().setTipsy(0.1f, 900).addEffect(milkEffect);
        TaggedFluidStacks milkStacks = new TaggedFluidStacks(1, "milk");
        builder.fermentsFrom(milkStacks, EnumYeast.BREWERS.asStack(), fermentTime);
        builder.fermentsFrom(milkStacks, new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66));
        GrowthCraftCellar.boozeBuilderFactory.create(this.kumisFluids[1]).tags(BoozeTag.FERMENTED, BoozeTag.POTENT).fermentsFrom(fs[0], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.05f), 900).addEffect(milkEffect);
        GrowthCraftCellar.boozeBuilderFactory.create(this.kumisFluids[2]).tags(BoozeTag.FERMENTED, BoozeTag.EXTENDED).fermentsFrom(fs[0], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[1], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.02f), 900).addEffect(milkEffect);
        GrowthCraftCellar.boozeBuilderFactory.create(this.kumisFluids[3]).tags(BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[1], EnumYeast.ETHEREAL.asStack(), fermentTime).fermentsFrom(fs[2], EnumYeast.ETHEREAL.asStack(), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.02f), 900).addEffect(milkEffect);
        GrowthCraftCellar.boozeBuilderFactory.create(this.kumisFluids[4]).tags(BoozeTag.FERMENTED, BoozeTag.INTOXICATED).fermentsFrom(fs[1], EnumYeast.ORIGIN.asStack(), fermentTime).fermentsFrom(fs[2], EnumYeast.ORIGIN.asStack(), fermentTime).getEffect().setTipsy(0.5f, 900).addEffect(milkEffect);
        GrowthCraftCellar.boozeBuilderFactory.create(this.kumisFluids[5]).tags(BoozeTag.FERMENTED, BoozeTag.POISONED).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.02f), 900).addEffect(evilMilkEffect);
    }

    @Override
    public void register() {
        this.kumisBottle.register("grcmilk.KumisBottle");
        if (this.milk != null) {
            this.milk.registerObjects("grcmilk", "Milk");
            if (FluidRegistry.getFluid((String)"milk") == null) {
                FluidContainerRegistry.registerFluidContainer((Fluid)this.milk.getFluid(), (ItemStack)new ItemStack(Items.field_151117_aB, 1), (ItemStack)new ItemStack(Items.field_151133_ar, 1));
                EventHandlerBucketFill.instance().register(this.milk.getFluidBlock(), new ItemStack(Items.field_151117_aB, 1));
            }
        }
        this.butterMilk.registerObjects("grcmilk", "ButterMilk");
        this.cream.registerObjects("grcmilk", "Cream");
        this.curds.registerObjects("grcmilk", "Curds");
        this.rennet.registerObjects("grcmilk", "Rennet");
        this.skimMilk.registerObjects("grcmilk", "SkimMilk");
        this.whey.registerObjects("grcmilk", "Whey");
        this.pasteurizedMilk.registerObjects("grcmilk", "PasteurizedMilk");
        for (Map.Entry<EnumCheeseType, FluidFactory.FluidDetails> pair : this.cheeses.entrySet()) {
            pair.getValue().registerObjects("grcmilk", "Cheese" + StringUtils.capitalize(pair.getKey().name));
        }
        BoozeRegistryHelper.registerBooze(this.kumisFluids, this.kumisFluidBlocks, this.kumisFluidBuckets, this.kumisBottle, kumisBasename, null);
        CoreRegistry.instance().fluidDictionary().addFluidTags(this.cream.getFluid(), MilkFluidTags.CREAM);
        CoreRegistry.instance().fluidDictionary().addFluidTags(this.curds.getFluid(), MilkFluidTags.MILK_CURDS);
        CoreRegistry.instance().fluidDictionary().addFluidTags(this.rennet.getFluid(), MilkFluidTags.RENNET);
        CoreRegistry.instance().fluidDictionary().addFluidTags(this.whey.getFluid(), MilkFluidTags.WHEY);
        GrowthCraftCellar.boozeBuilderFactory.create((Fluid)this.rennet.fluid.getFluid()).brewsFrom(new FluidStack(FluidRegistry.WATER, 1000), new OreItemStacks("rennetSource"), TickUtils.minutes(1), null);
        GrowthCraftCellar.boozeBuilderFactory.create((Fluid)this.pasteurizedMilk.fluid.getFluid()).brewsFrom(this.skimMilk.fluid.asFluidStack(250), new ItemStack(Items.field_151102_aT), TickUtils.minutes(1), new Residue(GrowthCraftMilk.items.starterCulture.asStack(1), 1.0f));
        GrowthCraftCellar.boozeBuilderFactory.create(this.skimMilk.getFluid()).culturesTo(250, GrowthCraftMilk.items.starterCulture.asStack(), 0.7f, TickUtils.seconds(10));
        GrowthCraftMilk.userApis.churnRecipes.addDefault(this.cream.fluid.asFluidStack(1000), this.butterMilk.fluid.asFluidStack(500), GrowthCraftMilk.items.butter.asStack(2), 16);
        for (Map.Entry<EnumCheeseType, FluidFactory.FluidDetails> pair : this.cheeses.entrySet()) {
            CoreRegistry.instance().fluidDictionary().addFluidTags(pair.getValue().getFluid(), MilkFluidTags.CHEESE);
        }
        this.registerOres();
        this.registerFermentations();
    }

    @Override
    public void init() {
        List<Fluid> milks = this.getMilkFluids();
        for (Fluid f : milks) {
            CoreRegistry.instance().fluidDictionary().addFluidTags(f, MilkFluidTags.MILK);
            MilkRegistry.instance().pancheon().addRecipe(new FluidStack(f, 1000), this.cream.fluid.asFluidStack(333), this.skimMilk.fluid.asFluidStack(666), TickUtils.minutes(1));
        }
    }
}

