/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.api.core.fluids.FluidTest;
import growthcraft.core.common.tileentity.GrcTileDeviceBase;
import growthcraft.core.common.tileentity.feature.ITileProgressiveDevice;
import growthcraft.milk.common.tileentity.IPancheonTile;
import growthcraft.milk.common.tileentity.device.Pancheon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityPancheon
extends GrcTileDeviceBase
implements ITileProgressiveDevice,
IPancheonTile {
    private Pancheon pancheon = new Pancheon(this, 0, 2, 1);

    @Override
    public float getDeviceProgress() {
        return this.pancheon.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.pancheon.getProgressScaled(scale);
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(1000), new FluidTank(1000), new FluidTank(1000)};
    }

    protected int getPresentTankIndex() {
        for (int i = this.getTankCount() - 1; i > 0; --i) {
            if (!this.isFluidTankFilled(i)) continue;
            return i;
        }
        return 0;
    }

    public FluidTank getPresentTank() {
        return this.getFluidTank(this.getPresentTankIndex());
    }

    public boolean outputTanksHaveFluid() {
        return this.isFluidTankFilled(1) || this.isFluidTankFilled(2);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.pancheon.update();
        }
    }

    @Override
    protected FluidStack doDrain(ForgeDirection dir, int amount, boolean doDrain) {
        return this.getPresentTank().drain(amount, doDrain);
    }

    @Override
    protected FluidStack doDrain(ForgeDirection dir, FluidStack stack, boolean doDrain) {
        if (!FluidTest.isValid(stack)) {
            return null;
        }
        FluidTank tank = this.getPresentTank();
        FluidStack expected = tank.getFluid();
        if (expected != null && expected.isFluidEqual(stack)) {
            return tank.drain(stack.amount, doDrain);
        }
        return null;
    }

    @Override
    protected int doFill(ForgeDirection dir, FluidStack stack, boolean doFill) {
        if (this.outputTanksHaveFluid()) {
            return 0;
        }
        return this.fillFluidTank(0, stack, doFill);
    }

    @Override
    protected void markFluidDirty() {
        super.markFluidDirty();
        this.markDirtyAndUpdate();
    }
}

