/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.item;

import growthcraft.api.core.definition.IFluidStackFactory;
import growthcraft.api.core.definition.IItemStackFactory;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.item.ItemTest;
import growthcraft.milk.GrowthCraftMilk;
import growthcraft.milk.common.item.EnumCheeseFeature;
import growthcraft.milk.common.item.EnumCheeseStage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public enum EnumCheeseType implements IItemStackFactory,
IFluidStackFactory
{
    CHEDDAR("cheddar", 15569408, new EnumCheeseFeature[]{EnumCheeseFeature.HAS_BLOCK}, new EnumCheeseStage[]{EnumCheeseStage.UNWAXED, EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT}),
    GORGONZOLA("gorgonzola", 15394782, new EnumCheeseFeature[]{EnumCheeseFeature.HAS_BLOCK}, new EnumCheeseStage[]{EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT}),
    EMMENTALER("emmentaler", 0xDDDDBC, new EnumCheeseFeature[]{EnumCheeseFeature.HAS_BLOCK}, new EnumCheeseStage[]{EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT}),
    APPENZELLER("appenzeller", 15983271, new EnumCheeseFeature[]{EnumCheeseFeature.HAS_BLOCK}, new EnumCheeseStage[]{EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT}),
    ASIAGO("asiago", 12564109, new EnumCheeseFeature[]{EnumCheeseFeature.HAS_BLOCK}, new EnumCheeseStage[]{EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT}),
    PARMESAN("parmesan", 14210502, new EnumCheeseFeature[]{EnumCheeseFeature.HAS_BLOCK}, new EnumCheeseStage[]{EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT}),
    MONTEREY("monterey", 16119258, new EnumCheeseFeature[]{EnumCheeseFeature.HAS_BLOCK}, new EnumCheeseStage[]{EnumCheeseStage.UNWAXED, EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT}),
    RICOTTA("ricotta", 0xC8C8C5, new EnumCheeseFeature[0], new EnumCheeseStage[]{EnumCheeseStage.UNAGED, EnumCheeseStage.AGED, EnumCheeseStage.CUT});

    public static final EnumCheeseType[] VALUES;
    public final String name;
    public final int color;
    public final int meta;
    public final List<EnumCheeseFeature> features;
    public final List<EnumCheeseStage> stages;
    public final List<IMultiItemStacks> waxes = new ArrayList<IMultiItemStacks>();

    private EnumCheeseType(String n2, int c, EnumCheeseFeature[] fets, EnumCheeseStage[] stgs) {
        this.name = n2;
        this.color = c;
        this.meta = this.ordinal();
        this.features = Arrays.asList(fets);
        this.stages = Arrays.asList(stgs);
    }

    public boolean canWax(ItemStack stack) {
        if (ItemTest.isValid(stack)) {
            for (IMultiItemStacks wax : this.waxes) {
                if (!wax.containsItemStack(stack)) continue;
                return stack.field_77994_a >= wax.getStackSize();
            }
        }
        return false;
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasBlock() {
        return this.features.contains((Object)EnumCheeseFeature.HAS_BLOCK);
    }

    public boolean hasCurdBlock() {
        return true;
    }

    @Override
    public ItemStack asStack(int size) {
        return GrowthCraftMilk.items.cheese.asStack(size, this.meta);
    }

    @Override
    public ItemStack asStack() {
        return this.asStack(1);
    }

    public ItemStack asBlockItemStack(int size) {
        return GrowthCraftMilk.blocks.cheeseBlock.asStack(size, this.meta);
    }

    public ItemStack asBlockItemStack() {
        return this.asBlockItemStack(1);
    }

    public ItemStack asCurdItemStack(int size) {
        return GrowthCraftMilk.blocks.hangingCurds.asStack(size, this.meta);
    }

    public ItemStack asCurdItemStack() {
        return this.asCurdItemStack(1);
    }

    @Override
    public FluidStack asFluidStack(int amount) {
        return GrowthCraftMilk.fluids.cheeses.get((Object)this).fluid.asFluidStack(amount);
    }

    @Override
    public FluidStack asFluidStack() {
        return this.asFluidStack(1);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("cheese_id", this.meta);
        return tag;
    }

    public boolean writeToStream(ByteBuf stream) {
        stream.writeInt(this.meta);
        return false;
    }

    public static EnumCheeseType getSafeById(int id) {
        if (id >= 0 && id < VALUES.length) {
            return VALUES[id];
        }
        return CHEDDAR;
    }

    public static EnumCheeseType loadFromStream(ByteBuf stream) {
        int id = stream.readInt();
        return EnumCheeseType.getSafeById(id);
    }

    public static EnumCheeseType loadFromNBT(NBTTagCompound nbt) {
        int id = nbt.func_74762_e("cheese_id");
        return EnumCheeseType.getSafeById(id);
    }

    static {
        VALUES = EnumCheeseType.values();
    }
}

