/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.effect;

import growthcraft.api.core.effect.IEffect;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.api.core.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EffectMilk
implements IEffect {
    private Set<Integer> blacklist = new HashSet<Integer>();

    public EffectMilk clearBlacklist() {
        this.blacklist.clear();
        return this;
    }

    public EffectMilk blacklistPotions(Potion ... potions) {
        for (Potion potion : potions) {
            this.blacklist.add(potion.field_76415_H);
        }
        return this;
    }

    @Override
    public void apply(World _w, Entity entity, Random _r, Object _d) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)entity;
            ArrayList<Integer> effectsToRemove = new ArrayList<Integer>();
            for (Object e : elb.func_70651_bq()) {
                if (!(e instanceof PotionEffect)) continue;
                PotionEffect eff = (PotionEffect)e;
                int id = eff.func_76456_a();
                boolean isCurable = eff.getCurativeItems().size() > 0 && !this.blacklist.contains(id);
                if (!isCurable) continue;
                effectsToRemove.add(id);
            }
            Iterator i$ = effectsToRemove.iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                elb.func_82170_o(id);
            }
        }
    }

    @Override
    public void getDescription(List<String> list) {
        list.add(GrcI18n.translate("grc.effect.milk"));
    }

    public static EffectMilk create(Potion ... potions) {
        EffectMilk eff = new EffectMilk();
        return eff.blacklistPotions(potions);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        this.blacklist.clear();
        if (nbt.func_74764_b(name)) {
            NBTTagCompound tag = nbt.func_74775_l(name);
            NBTTagCompound blacklistTag = tag.func_74775_l("blacklist");
            NBTHelper.readIntegerCollection(this.blacklist, blacklistTag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound blacklistTag = new NBTTagCompound();
        NBTHelper.writeIntegerCollection(blacklistTag, this.blacklist);
        tag.func_74782_a("blacklist", (NBTBase)blacklistTag);
        nbt.func_74782_a(name, (NBTBase)tag);
    }
}

