/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.hops.init;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.cellar.booze.Booze;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.core.effect.EffectAddPotionEffect;
import growthcraft.api.core.effect.EffectWeightedRandomList;
import growthcraft.api.core.effect.SimplePotionEffectFactory;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.util.TickUtils;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.definition.BlockBoozeDefinition;
import growthcraft.cellar.common.definition.ItemBucketBoozeDefinition;
import growthcraft.cellar.common.item.ItemBoozeBottle;
import growthcraft.cellar.util.BoozeRegistryHelper;
import growthcraft.cellar.util.BoozeUtils;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.GrcModuleBase;
import growthcraft.core.common.definition.ItemDefinition;
import growthcraft.hops.GrowthCraftHops;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GrcHopsFluids
extends GrcModuleBase {
    public Booze[] hopAleBooze;
    public Booze[] lagerBooze;
    public BlockBoozeDefinition[] hopAleFluids;
    public BlockBoozeDefinition[] lagerFluids;
    public ItemDefinition hopAle;
    public ItemDefinition lager;
    public ItemBucketBoozeDefinition[] hopAleBuckets;
    public ItemBucketBoozeDefinition[] lagerBuckets;

    @Override
    public void preInit() {
        this.lagerBooze = new Booze[7];
        this.lagerFluids = new BlockBoozeDefinition[this.lagerBooze.length];
        this.lagerBuckets = new ItemBucketBoozeDefinition[this.lagerBooze.length];
        BoozeRegistryHelper.initializeBoozeFluids("grc.lager", this.lagerBooze);
        for (Booze booze : this.lagerBooze) {
            booze.setColor(GrowthCraftHops.getConfig().lagerColor).setDensity(1080);
        }
        BoozeRegistryHelper.initializeBooze(this.lagerBooze, this.lagerFluids, this.lagerBuckets);
        BoozeRegistryHelper.setBoozeFoodStats(this.lagerBooze, 1, -0.6f);
        BoozeRegistryHelper.setBoozeFoodStats(this.lagerBooze[0], 1, 0.3f);
        this.lager = new ItemDefinition((Item)new ItemBoozeBottle(this.lagerBooze));
        this.hopAleBooze = new Booze[9];
        this.hopAleFluids = new BlockBoozeDefinition[this.hopAleBooze.length];
        this.hopAleBuckets = new ItemBucketBoozeDefinition[this.hopAleBooze.length];
        BoozeRegistryHelper.initializeBoozeFluids("grc.hopAle", this.hopAleBooze);
        for (Booze booze : this.hopAleBooze) {
            booze.setColor(GrowthCraftHops.getConfig().hopAleColor).setDensity(1080);
        }
        BoozeRegistryHelper.initializeBooze(this.hopAleBooze, this.hopAleFluids, this.hopAleBuckets);
        BoozeRegistryHelper.setBoozeFoodStats(this.hopAleBooze, 1, -0.6f);
        BoozeRegistryHelper.setBoozeFoodStats(this.hopAleBooze[0], 1, 0.3f);
        BoozeRegistryHelper.setBoozeFoodStats(this.hopAleBooze[4], 1, 0.3f);
        this.hopAle = new ItemDefinition((Item)new ItemBoozeBottle(this.hopAleBooze));
    }

    private void registerLager() {
        int fermentTime = GrowthCraftCellar.getConfig().fermentTime;
        FluidStack[] fs = new FluidStack[this.lagerBooze.length];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = new FluidStack((Fluid)this.lagerBooze[i], 1);
        }
        GrowthCraftCellar.boozeBuilderFactory.create(this.lagerBooze[0]).tags(BoozeTag.YOUNG, BoozeTag.CHILLED).brewsFrom(new FluidStack((Fluid)this.hopAleBooze[4], 40), new OreItemStacks("yeastLager"), TickUtils.minutes(1), Residue.newDefault(0.0f));
        GrowthCraftCellar.boozeBuilderFactory.create(this.lagerBooze[1]).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED).fermentsFrom(fs[0], new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(fs[0], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(Potion.field_76422_e, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.lagerBooze[2]).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.POTENT).fermentsFrom(fs[1], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(Potion.field_76422_e, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.lagerBooze[3]).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.EXTENDED).fermentsFrom(fs[1], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(Potion.field_76422_e, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.lagerBooze[4]).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[2], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(Potion.field_76422_e, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.lagerBooze[5]).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.INTOXICATED).fermentsFrom(fs[2], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.091f), TickUtils.seconds(45)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76422_e.field_76415_H, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76419_f.field_76415_H, TickUtils.minutes(3), 2)))).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76424_c.field_76415_H, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76421_d.field_76415_H, TickUtils.minutes(3), 2))));
        GrowthCraftCellar.boozeBuilderFactory.create(this.lagerBooze[6]).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.POISONED).fermentsFrom(fs[0], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[1], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[4], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[5], new OreItemStacks("yeastPoison"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).createPotionEntry(Potion.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthCraftCore.getConfig().hidePoisonedBooze);
    }

    private void registerHopAle() {
        int fermentTime = GrowthCraftCellar.getConfig().fermentTime;
        FluidStack[] fs = new FluidStack[this.hopAleBooze.length];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = new FluidStack((Fluid)this.hopAleBooze[i], 1);
        }
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[4]).tags(BoozeTag.YOUNG).brewsFrom(new FluidStack(FluidRegistry.WATER, 40), new OreItemStacks("cropWheat"), TickUtils.minutes(1), Residue.newDefault(0.3f));
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[0]).tags(BoozeTag.YOUNG, BoozeTag.HOPPED).brewsFrom(new FluidStack((Fluid)this.hopAleBooze[4], 40), new OreItemStacks("cropHops"), TickUtils.minutes(1), Residue.newDefault(0.0f));
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[1]).tags(BoozeTag.FERMENTED).fermentsFrom(fs[0], new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(fs[0], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76422_e, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[2]).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.POTENT).fermentsFrom(fs[1], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.12f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76422_e, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[3]).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.EXTENDED).fermentsFrom(fs[1], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76422_e, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[5]).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[2], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76422_e, TickUtils.minutes(3), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[6]).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.CHILLED).fermentsFrom(fs[5], new OreItemStacks("yeastLager"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.071f), TickUtils.seconds(45)).addPotionEntry(Potion.field_76422_e, TickUtils.minutes(10), 2);
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[7]).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.INTOXICATED).fermentsFrom(fs[2], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.2f), TickUtils.seconds(45)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76422_e.field_76415_H, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76419_f.field_76415_H, TickUtils.minutes(3), 2))));
        GrowthCraftCellar.boozeBuilderFactory.create(this.hopAleBooze[8]).tags(BoozeTag.FERMENTED, BoozeTag.POISONED).fermentsFrom(fs[1], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[5], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[6], new OreItemStacks("yeastPoison"), fermentTime).fermentsFrom(fs[7], new OreItemStacks("yeastPoison"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).createPotionEntry(Potion.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthCraftCore.getConfig().hidePoisonedBooze);
    }

    private void registerFermentations() {
        this.registerHopAle();
        this.registerLager();
    }

    @Override
    public void register() {
        GameRegistry.registerItem(this.hopAle.getItem(), (String)"grc.hopAle");
        GameRegistry.registerItem(this.lager.getItem(), (String)"grc.lager");
        BoozeRegistryHelper.registerBooze(this.hopAleBooze, this.hopAleFluids, this.hopAleBuckets, this.hopAle, "grc.hopAle", null);
        BoozeRegistryHelper.registerBooze(this.lagerBooze, this.lagerFluids, this.lagerBuckets, this.lager, "grc.lager", null);
        this.registerFermentations();
    }
}

