/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes.common.block;

import cpw.mods.fml.common.eventhandler.Event;
import growthcraft.core.common.block.GrcBlockBase;
import growthcraft.core.common.block.ICropDataProvider;
import growthcraft.core.integration.AppleCore;
import growthcraft.core.util.BlockCheck;
import growthcraft.grapes.util.GrapeBlockCheck;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockGrapeVineBase
extends GrcBlockBase
implements IPlantable,
ICropDataProvider,
IGrowable {
    private ItemStack itemDrop = new ItemStack((Item)null, 0);
    private float growthRateMultiplier = 1.0f;

    public BlockGrapeVineBase() {
        super(Material.field_151585_k);
    }

    public void setItemDrop(ItemStack itemstack) {
        this.itemDrop = itemstack;
    }

    public ItemStack getItemDrop() {
        return this.itemDrop;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        return this.itemDrop.func_77973_b();
    }

    public int func_149745_a(Random random) {
        return this.itemDrop.field_77994_a;
    }

    public void setGrowthRateMultiplier(float rate) {
        this.growthRateMultiplier = rate;
    }

    public float getGrowthRateMultiplier() {
        return this.growthRateMultiplier;
    }

    public int getGrowthMax() {
        return 1;
    }

    @Override
    public float getGrowthProgress(IBlockAccess world, int x, int y, int z, int meta) {
        return (float)meta / (float)this.getGrowthMax();
    }

    protected boolean isGrapeVine(Block block) {
        return GrapeBlockCheck.isGrapeVine(block);
    }

    public void incrementGrowth(World world, int x, int y, int z, int meta) {
        world.func_72921_c(x, y, z, meta + 1, 2);
        AppleCore.announceGrowthTick(this, world, x, y, z, meta);
    }

    protected float getGrowthRate(World world, int x, int y, int z) {
        Block l = world.func_147439_a(x, y, z - 1);
        Block i1 = world.func_147439_a(x, y, z + 1);
        Block j1 = world.func_147439_a(x - 1, y, z);
        Block k1 = world.func_147439_a(x + 1, y, z);
        Block l1 = world.func_147439_a(x - 1, y, z - 1);
        Block i2 = world.func_147439_a(x + 1, y, z - 1);
        Block j2 = world.func_147439_a(x + 1, y, z + 1);
        Block k2 = world.func_147439_a(x - 1, y, z + 1);
        boolean flag = this.isGrapeVine(j1) || this.isGrapeVine(k1);
        boolean flag1 = this.isGrapeVine(l) || this.isGrapeVine(i1);
        boolean flag2 = this.isGrapeVine(l1) || this.isGrapeVine(i2) || this.isGrapeVine(j2) || this.isGrapeVine(k2);
        float f = 1.0f;
        for (int l2 = x - 1; l2 <= x + 1; ++l2) {
            for (int i3 = z - 1; i3 <= z + 1; ++i3) {
                Block block = world.func_147439_a(l2, y - 1, i3);
                float f1 = 0.0f;
                if (block != null && block == Blocks.field_150458_ak) {
                    f1 = 1.0f;
                    if (block.isFertile(world, l2, y - 1, i3)) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != x || i3 != z) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return BlockCheck.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, this);
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Crop;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    protected abstract void doGrowth(World var1, int var2, int var3, int var4, int var5);

    protected abstract boolean canUpdateGrowth(World var1, int var2, int var3, int var4);

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        if (this.canUpdateGrowth(world, x, y, z)) {
            boolean continueGrowth;
            Event.Result allowGrowthResult = AppleCore.validateGrowthTick(this, world, x, y, z, random);
            if (Event.Result.DENY == allowGrowthResult) {
                return;
            }
            int meta = world.func_72805_g(x, y, z);
            float f = this.getGrowthRate(world, x, y, z);
            boolean bl = continueGrowth = random.nextInt((int)(this.getGrowthRateMultiplier() / f) + 1) == 0;
            if (Event.Result.ALLOW == allowGrowthResult || continueGrowth) {
                this.doGrowth(world, x, y, z, meta);
            }
        }
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isClient) {
        return this.canUpdateGrowth(world, x, y, z);
    }

    public boolean func_149852_a(World world, Random random, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random random, int x, int y, int z) {
        if ((double)random.nextFloat() < 0.5) {
            this.doGrowth(world, x, y, z, world.func_72805_g(x, y, z));
        }
    }
}

