/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.block.IBlockRope;
import growthcraft.core.util.BlockCheck;
import growthcraft.grapes.GrowthCraftGrapes;
import growthcraft.grapes.client.renderer.RenderGrapeLeaves;
import growthcraft.grapes.util.GrapeBlockCheck;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGrapeLeaves
extends BlockLeavesBase
implements IBlockRope {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private final int grapeLeavesGrowthRate;
    private final int grapeSpawnRate;
    private final int grapeVineSupportedLength;

    public BlockGrapeLeaves() {
        super(Material.field_151584_j, false);
        this.grapeLeavesGrowthRate = GrowthCraftGrapes.getConfig().grapeLeavesGrowthRate;
        this.grapeSpawnRate = GrowthCraftGrapes.getConfig().grapeSpawnRate;
        this.grapeVineSupportedLength = GrowthCraftGrapes.getConfig().grapeVineSupportedLength;
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(field_149779_h);
        this.func_149663_c("grc.grapeLeaves");
        this.func_149647_a(null);
    }

    private boolean isTrunk(World world, int x, int y, int z) {
        return GrapeBlockCheck.isGrapeVineTrunk(world.func_147439_a(x, y, z));
    }

    public boolean isSupportedByTrunk(World world, int x, int y, int z) {
        return this.isTrunk(world, x, y - 1, z);
    }

    public boolean canGrowOutwardsOnRope(World world, int x, int y, int z) {
        if (BlockCheck.isRope(world.func_147439_a(x + 1, y, z))) {
            return true;
        }
        if (BlockCheck.isRope(world.func_147439_a(x - 1, y, z))) {
            return true;
        }
        if (BlockCheck.isRope(world.func_147439_a(x, y, z + 1))) {
            return true;
        }
        return BlockCheck.isRope(world.func_147439_a(x, y, z - 1));
    }

    public boolean canGrowOutwards(World world, int x, int y, int z) {
        boolean leavesToTheWest;
        boolean leavesTotheSouth = world.func_147439_a(x, y, z + 1) == this;
        boolean leavesToTheNorth = world.func_147439_a(x, y, z - 1) == this;
        boolean leavesToTheEast = world.func_147439_a(x + 1, y, z) == this;
        boolean bl = leavesToTheWest = world.func_147439_a(x - 1, y, z) == this;
        if (!(leavesTotheSouth || leavesToTheNorth || leavesToTheEast || leavesToTheWest)) {
            return false;
        }
        for (int i = 1; i <= this.grapeVineSupportedLength; ++i) {
            if (leavesTotheSouth && this.isTrunk(world, x, y - 1, z + i)) {
                return true;
            }
            if (leavesToTheNorth && this.isTrunk(world, x, y - 1, z - i)) {
                return true;
            }
            if (leavesToTheEast && this.isTrunk(world, x + i, y - 1, z)) {
                return true;
            }
            if (!leavesToTheWest || !this.isTrunk(world, x - i, y - 1, z)) continue;
            return true;
        }
        return false;
    }

    public boolean canGrowHere(World world, int x, int y, int z) {
        if (BlockCheck.isRope(world.func_147439_a(x, y, z))) {
            return this.canGrowOutwards(world, x, y, z);
        }
        return false;
    }

    private void setGrapeBlock(World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, GrowthCraftGrapes.blocks.grapeBlock.getBlock(), 0, 3);
    }

    public boolean growGrapeBlock(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y - 1, z)) {
            if (!world.field_72995_K) {
                this.setGrapeBlock(world, x, y - 1, z);
            }
            return true;
        }
        return false;
    }

    private void grow(World world, int x, int y, int z, Random random) {
        if (world.func_147437_c(x, y - 1, z) && random.nextInt(this.grapeSpawnRate) == 0) {
            this.setGrapeBlock(world, x, y - 1, z);
        }
        if (world.field_73012_v.nextInt(this.grapeLeavesGrowthRate) == 0 && this.canGrowOutwards(world, x, y, z)) {
            ForgeDirection dir = BlockCheck.DIR4[random.nextInt(4)];
            if (this.canGrowHere(world, x + dir.offsetX, y, z + dir.offsetZ)) {
                world.func_147465_d(x + dir.offsetX, y, z + dir.offsetZ, (Block)this, 0, 3);
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147449_b(x, y, z, GrowthCraftCore.blocks.ropeBlock.getBlock());
        } else {
            this.grow(world, x, y, z, random);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (world.func_72951_B(x, y + 1, z) && !World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && random.nextInt(15) == 1) {
            double d0 = (float)x + random.nextFloat();
            double d1 = (double)y - 0.05;
            double d2 = (float)z + random.nextFloat();
            world.func_72869_a("dripWater", d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (this.isSupportedByTrunk(world, x, y, z)) {
            return true;
        }
        for (ForgeDirection dir : BlockCheck.DIR4) {
            int bz;
            int bx;
            for (int i = 1; i <= this.grapeVineSupportedLength && world.func_147439_a(bx = x + dir.offsetX * i, y, bz = z + dir.offsetZ * i) == this; ++i) {
                if (!this.isSupportedByTrunk(world, bx, y, bz)) continue;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return GrowthCraftGrapes.items.grapeSeeds.getItem();
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    @Override
    public boolean canConnectRopeTo(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) instanceof IBlockRope;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return GrowthCraftCore.items.rope.getItem();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[4];
        this.icons[0] = reg.func_94245_a("grcgrapes:leaves");
        this.icons[1] = reg.func_94245_a("grcgrapes:leaves_opaque");
        this.icons[2] = reg.func_94245_a("grccore:rope_1");
        this.icons[3] = reg.func_94245_a("grcgrapes:leaves_half");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconByIndex(int index) {
        return this.icons[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[this.func_149662_c() ? 1 : 0];
    }

    public int func_149645_b() {
        return RenderGrapeLeaves.id;
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        int r = 0;
        int g = 0;
        int b = 0;
        for (int l1 = -1; l1 <= 1; ++l1) {
            for (int i2 = -1; i2 <= 1; ++i2) {
                int j2 = world.func_72807_a(x + i2, z + l1).func_150571_c(x + i2, y, z + l1);
                r += (j2 & 0xFF0000) >> 16;
                g += (j2 & 0xFF00) >> 8;
                b += j2 & 0xFF;
            }
        }
        return (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
    }
}

