/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration.nei;

import codechicken.lib.gui.GuiDraw;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import growthcraft.core.client.gui.GrcGuiRenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TemplateRenderHelper {
    public static final int PROGRESS_RIGHT = 0;
    public static final int PROGRESS_DOWN = 1;
    public static final int PROGRESS_LEFT = 2;
    public static final int PROGRESS_UP = 3;

    private TemplateRenderHelper() {
    }

    public static void drawFluid(int x, int y, int w, int h, Fluid fluid, int amount) {
        IIcon icon;
        if (fluid != null && (icon = fluid.getStillIcon()) != null) {
            GuiDraw.changeTexture((ResourceLocation)TextureMap.field_110575_b);
            int color = fluid.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            GrcGuiRenderHelper.drawTexturedModelRectFromIcon(x, y + h - amount, GuiDraw.gui.getZLevel(), icon, w, amount);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void drawFluidStack(int x, int y, int w, int h, FluidStack fluidstack, int amountMax) {
        if (fluidstack == null) {
            return;
        }
        TemplateRenderHelper.drawFluid(x, y, w, h, fluidstack.getFluid(), h * fluidstack.amount / amountMax);
    }
}

