/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.integration;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.core.integration.ModIntegrationBase;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFruit;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;

public class MFRModuleBase
extends ModIntegrationBase {
    public static final String MOD_ID = "MineFactoryReloaded";

    public MFRModuleBase(String modid) {
        super(modid, MOD_ID);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void sendMessage(String target, Object value) {
        this.logger.debug("Sending Message to '%s': '%s' %s", this.modID, target, value);
        FactoryRegistry.sendMessage((String)target, (Object)value);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerPlantableSapling(Item seed, Block sapling) {
        GameRegistry.UniqueIdentifier itemUUID = GameRegistry.findUniqueIdentifierFor((Item)seed);
        GameRegistry.UniqueIdentifier blockUUID = GameRegistry.findUniqueIdentifierFor((Block)sapling);
        if (blockUUID != null && itemUUID != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("sapling", blockUUID.toString());
            tag.func_74778_a("seed", itemUUID.toString());
            this.sendMessage("registerPlantable_Sapling", tag);
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerPlantableSapling(Block sapling) {
        GameRegistry.UniqueIdentifier uuid = GameRegistry.findUniqueIdentifierFor((Block)sapling);
        if (uuid != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("sapling", uuid.toString());
            this.sendMessage("registerPlantable_Sapling", tag);
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerPickableFruit(IFactoryFruit fruit) {
        this.sendMessage("registerPickableFruit", fruit);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerHarvestable(IFactoryHarvestable harvester) {
        this.sendMessage("registerHarvestable", harvester);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerFertilizableByType(String type, Object obj) {
        this.sendMessage("registerFertilizable_" + type, obj);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerFertilizableCrop(NBTTagCompound tag) {
        this.registerFertilizableByType("Crop", tag);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerFertilizableCrop(Block block, int maxGrowth, FertilizerType fertilizerType) {
        GameRegistry.UniqueIdentifier uuid = GameRegistry.findUniqueIdentifierFor((Block)block);
        if (uuid != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("plant", uuid.toString());
            tag.func_74768_a("meta", maxGrowth);
            tag.func_74768_a("type", fertilizerType.ordinal());
            this.registerFertilizableCrop(tag);
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerFertilizableCrop(Block block, int maxGrowth) {
        this.registerFertilizableCrop(block, maxGrowth, FertilizerType.GrowPlant);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerPlantable(IFactoryPlantable planter) {
        this.sendMessage("registerPlantable", planter);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerHarvestableByType(String type, String str) {
        this.sendMessage("registerHarvestable_" + type, str);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    protected void registerHarvestableLeaves(Block block) {
        GameRegistry.UniqueIdentifier uuid = GameRegistry.findUniqueIdentifierFor((Block)block);
        if (uuid != null) {
            this.registerHarvestableByType("Leaves", uuid.toString());
        }
    }
}

