/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.integration.waila;

import cpw.mods.fml.common.Optional;
import growthcraft.api.core.i18n.GrcI18n;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.cellar.common.block.BlockFruitPresser;
import growthcraft.cellar.common.tileentity.TileEntityBrewKettle;
import growthcraft.cellar.common.tileentity.TileEntityCultureJar;
import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.common.tileentity.TileEntityFruitPress;
import growthcraft.cellar.util.TagFormatterBrewKettle;
import growthcraft.cellar.util.TagFormatterCultureJar;
import growthcraft.cellar.util.TagFormatterFermentBarrel;
import growthcraft.cellar.util.TagFormatterFruitPress;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class CellarDataProvider
implements IWailaDataProvider {
    @Optional.Method(modid="Waila")
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        TileEntity te = accessor.getTileEntity();
        if (block instanceof BlockFruitPresser) {
            tooltip.add(EnumChatFormatting.GRAY + GrcI18n.translate("grc.cellar.fruit_presser.state_prefix") + " " + EnumChatFormatting.WHITE + GrcI18n.translate("grc.cellar.fruit_presser.state." + ((BlockFruitPresser)block).getPressStateName(accessor.getMetadata())));
        }
        NBTTagCompound tag = accessor.getNBTData();
        if (config.getConfig("FermentBarrelExtras") && te instanceof TileEntityFermentBarrel) {
            tooltip = TagFormatterFermentBarrel.INSTANCE.format(tooltip, tag);
        }
        if (config.getConfig("CultureJarExtras") && te instanceof TileEntityCultureJar) {
            tooltip = TagFormatterCultureJar.INSTANCE.format(tooltip, tag);
        }
        if (config.getConfig("BrewKettleExtras") && te instanceof TileEntityBrewKettle) {
            tooltip = TagFormatterBrewKettle.INSTANCE.format(tooltip, tag);
        }
        if (config.getConfig("FruitPressExtras") && te instanceof TileEntityFruitPress) {
            tooltip = TagFormatterFruitPress.INSTANCE.format(tooltip, tag);
        }
        return tooltip;
    }

    @Optional.Method(modid="Waila")
    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    private void getBrewKettleData(TileEntityBrewKettle brewKettle, NBTTagCompound tag) {
        tag.func_74757_a("can_brew", brewKettle.canBrew());
        tag.func_74782_a("item_brew", (NBTBase)NBTHelper.writeItemStackToNBT(brewKettle.func_70301_a(0), new NBTTagCompound()));
        tag.func_74782_a("item_residue", (NBTBase)NBTHelper.writeItemStackToNBT(brewKettle.func_70301_a(1), new NBTTagCompound()));
    }

    private void getFruitPressData(TileEntityFruitPress fruitPress, NBTTagCompound tag) {
        tag.func_74782_a("item_press", (NBTBase)NBTHelper.writeItemStackToNBT(fruitPress.func_70301_a(0), new NBTTagCompound()));
        tag.func_74782_a("item_residue", (NBTBase)NBTHelper.writeItemStackToNBT(fruitPress.func_70301_a(1), new NBTTagCompound()));
    }

    private void getCultureJarData(TileEntityCultureJar fermentJar, NBTTagCompound tag) {
        tag.func_74782_a("item_yeast", (NBTBase)NBTHelper.writeItemStackToNBT(fermentJar.func_70301_a(0), new NBTTagCompound()));
    }

    private void getFermentBarrelData(TileEntityFermentBarrel fermentBarrel, NBTTagCompound tag) {
        tag.func_74782_a("item_modifier", (NBTBase)NBTHelper.writeItemStackToNBT(fermentBarrel.func_70301_a(0), new NBTTagCompound()));
    }

    @Optional.Method(modid="Waila")
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileEntityBrewKettle) {
            this.getBrewKettleData((TileEntityBrewKettle)te, tag);
        }
        if (te instanceof TileEntityFruitPress) {
            this.getFruitPressData((TileEntityFruitPress)te, tag);
        }
        if (te instanceof TileEntityFermentBarrel) {
            this.getFermentBarrelData((TileEntityFermentBarrel)te, tag);
        }
        if (te instanceof TileEntityCultureJar) {
            this.getCultureJarData((TileEntityCultureJar)te, tag);
        }
        return tag;
    }
}

