/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import cpw.mods.fml.common.eventhandler.Event;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.brewing.BrewingRecipe;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.component.TileHeatingComponent;
import growthcraft.cellar.event.EventBrewed;
import growthcraft.core.common.tileentity.device.DeviceBase;
import growthcraft.core.common.tileentity.device.DeviceFluidSlot;
import growthcraft.core.common.tileentity.device.DeviceInventorySlot;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BrewKettle
extends DeviceBase {
    private float grain;
    private double time;
    private double timeMax;
    private DeviceInventorySlot brewingSlot;
    private DeviceInventorySlot residueSlot;
    private DeviceFluidSlot inputFluidSlot;
    private DeviceFluidSlot outputFluidSlot;
    private TileHeatingComponent heatComponent;

    public BrewKettle(TileEntityCellarDevice te, int brewSlotId, int residueSlotId, int inputFluidSlotId, int outputFluidSlotId) {
        super(te);
        this.brewingSlot = new DeviceInventorySlot((IInventory)te, brewSlotId);
        this.residueSlot = new DeviceInventorySlot((IInventory)te, residueSlotId);
        this.inputFluidSlot = new DeviceFluidSlot(te, inputFluidSlotId);
        this.outputFluidSlot = new DeviceFluidSlot(te, outputFluidSlotId);
        this.heatComponent = new TileHeatingComponent(te, 0.5f);
    }

    public void setGrain(float g) {
        this.grain = g;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double t) {
        this.time = t;
    }

    public double getTimeMax() {
        return this.timeMax;
    }

    public void setTimeMax(double t) {
        this.timeMax = t;
    }

    public boolean resetTime() {
        if (this.time != 0.0) {
            this.setTime(0.0);
            return true;
        }
        return false;
    }

    public float getProgress() {
        if (this.timeMax == 0.0) {
            return 0.0f;
        }
        return (float)(this.time / this.timeMax);
    }

    public int getProgressScaled(int scale) {
        return (int)(this.getProgress() * (float)scale);
    }

    public BrewKettle setHeatMultiplier(float h) {
        this.heatComponent.setHeatMultiplier(h);
        return this;
    }

    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    public boolean isHeated() {
        return this.getHeatMultiplier() > 0.0f;
    }

    private BrewingRecipe findRecipe() {
        return CellarRegistry.instance().brewing().findRecipe(this.inputFluidSlot.get(), this.brewingSlot.get());
    }

    public BrewingRecipe getWorkingRecipe() {
        if (!this.isHeated()) {
            return null;
        }
        BrewingRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return null;
        }
        IMultiItemStacks expected = recipe.getInputItemStack();
        this.brewingSlot.hasEnough(expected);
        FluidStack inputFluid = recipe.getInputFluidStack();
        this.inputFluidSlot.hasEnough(inputFluid);
        if (this.outputFluidSlot.isEmpty()) {
            return recipe;
        }
        FluidStack outputFluid = recipe.asFluidStack();
        if (!this.outputFluidSlot.hasCapacityFor(outputFluid)) {
            return null;
        }
        return recipe;
    }

    public boolean canBrew() {
        return this.getWorkingRecipe() != null;
    }

    private void produceGrain(BrewingRecipe recipe) {
        Residue res = recipe.getResidue();
        if (res != null) {
            this.grain += res.pomaceRate;
            while (this.grain >= 1.0f) {
                this.grain -= 1.0f;
                this.residueSlot.increaseStack(res.residueItem);
            }
        }
    }

    private void brewItem(BrewingRecipe recipe) {
        this.produceGrain(recipe);
        this.inputFluidSlot.consume(recipe.getInputFluidStack(), true);
        this.outputFluidSlot.fill(recipe.asFluidStack(), true);
        this.brewingSlot.consume(recipe.getInputItemStack());
        this.markForUpdate();
        GrowthCraftCellar.CELLAR_BUS.post((Event)new EventBrewed(this.parent, recipe));
    }

    public void update() {
        this.heatComponent.update();
        BrewingRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            this.timeMax = recipe.getTime();
            float multiplier = this.getHeatMultiplier();
            this.time += (double)(multiplier * 1.0f);
            if (this.time >= this.timeMax) {
                this.resetTime();
                this.brewItem(recipe);
            }
        } else if (this.resetTime()) {
            this.markForUpdate();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.time = data.func_74769_h("time");
        this.grain = data.func_74760_g("grain");
        this.heatComponent.readFromNBT(data, "heat_component");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74780_a("time", this.time);
        data.func_74776_a("grain", this.grain);
        this.heatComponent.writeToNBT(data, "heat_component");
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.time = buf.readDouble();
        this.timeMax = buf.readDouble();
        this.grain = buf.readFloat();
        this.heatComponent.readFromStream(buf);
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        buf.writeDouble(this.time);
        buf.writeDouble(this.timeMax);
        buf.writeFloat(this.grain);
        this.heatComponent.writeToStream(buf);
        return false;
    }
}

