/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.booze.BoozeEntry;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.cellar.booze.effect.EffectTipsy;
import growthcraft.api.cellar.heatsource.user.UserHeatSourceEntry;
import growthcraft.api.cellar.heatsource.user.UserHeatSourcesConfig;
import growthcraft.api.core.log.GrcLogger;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.module.ModuleContainer;
import growthcraft.cellar.GrcCellarConfig;
import growthcraft.cellar.common.CommonProxy;
import growthcraft.cellar.common.booze.ModifierFunctionExtended;
import growthcraft.cellar.common.booze.ModifierFunctionHyperExtended;
import growthcraft.cellar.common.booze.ModifierFunctionPotent;
import growthcraft.cellar.common.item.EnumYeast;
import growthcraft.cellar.common.potion.PotionCellar;
import growthcraft.cellar.common.tileentity.TileEntityBrewKettle;
import growthcraft.cellar.common.tileentity.TileEntityCultureJar;
import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.common.tileentity.TileEntityFruitPress;
import growthcraft.cellar.common.tileentity.TileEntityFruitPresser;
import growthcraft.cellar.common.village.ComponentVillageTavern;
import growthcraft.cellar.common.village.VillageHandlerCellar;
import growthcraft.cellar.creativetab.CreativeTabsCellar;
import growthcraft.cellar.eventhandler.EventHandlerCauldronUseItem;
import growthcraft.cellar.eventhandler.EventHandlerItemCraftedEventCellar;
import growthcraft.cellar.eventhandler.EventHandlerLivingUpdateEventCellar;
import growthcraft.cellar.init.GrcCellarBlocks;
import growthcraft.cellar.init.GrcCellarItems;
import growthcraft.cellar.integration.ThaumcraftModule;
import growthcraft.cellar.integration.Waila;
import growthcraft.cellar.network.PacketPipeline;
import growthcraft.cellar.stats.CellarAchievement;
import growthcraft.cellar.stats.GrcCellarAchievements;
import growthcraft.cellar.util.CellarBoozeBuilderFactory;
import growthcraft.cellar.util.GrcCellarUserApis;
import growthcraft.core.GrcGuiProvider;
import growthcraft.core.integration.NEI;
import growthcraft.core.util.MapGenHelper;
import java.lang.reflect.Field;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="Growthcraft|Cellar", name="Growthcraft Cellar", version="1.7.10-2.7.2", dependencies="required-after:Growthcraft@1.7.10-2.7.2")
public class GrowthCraftCellar {
    public static final String MOD_ID = "Growthcraft|Cellar";
    public static final String MOD_NAME = "Growthcraft Cellar";
    public static final String MOD_VERSION = "1.7.10-2.7.2";
    @Mod.Instance(value="Growthcraft|Cellar")
    public static GrowthCraftCellar instance;
    public static CreativeTabs tab;
    public static final GrcCellarBlocks blocks;
    public static final GrcCellarItems items;
    public static Potion potionTipsy;
    public static GrcCellarAchievements achievements;
    public static final PacketPipeline packetPipeline;
    public static CellarBoozeBuilderFactory boozeBuilderFactory;
    public static final EventBus CELLAR_BUS;
    public static final GrcGuiProvider guiProvider;
    private final ILogger logger = new GrcLogger("Growthcraft|Cellar");
    private final GrcCellarConfig config = new GrcCellarConfig();
    private final GrcCellarUserApis userApis = new GrcCellarUserApis();
    private final ModuleContainer modules = new ModuleContainer();

    public static UserHeatSourcesConfig getUserHeatSources() {
        return GrowthCraftCellar.instance.userApis.getUserHeatSources();
    }

    public static GrcCellarConfig getConfig() {
        return GrowthCraftCellar.instance.config;
    }

    public static ILogger getLogger() {
        return GrowthCraftCellar.instance.logger;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config.setLogger(this.logger);
        this.config.load(event.getModConfigurationDirectory(), "growthcraft/cellar.conf");
        this.modules.add(blocks);
        this.modules.add(items);
        if (this.config.enableWailaIntegration) {
            this.modules.add(new Waila());
        }
        if (this.config.enableThaumcraftIntegration) {
            this.modules.add(new ThaumcraftModule());
        }
        this.modules.add(this.userApis);
        this.modules.add(CommonProxy.instance);
        if (this.config.debugEnabled) {
            this.logger.debug("Pre-Initializing %s", MOD_ID);
            CellarRegistry.instance().setLogger(this.logger);
            this.modules.setLogger(this.logger);
        }
        this.modules.freeze();
        this.userApis.getUserBrewingRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/brewing.json");
        this.userApis.getUserCultureRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/culturing.json");
        this.userApis.getUserFermentingRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/fermenting.json");
        this.userApis.getUserHeatSources().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/heatsources.json");
        this.userApis.getUserPressingRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/pressing.json");
        this.userApis.getUserYeastEntries().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/yeast.json");
        this.registerBoozeModifierFunctions();
        boozeBuilderFactory = new CellarBoozeBuilderFactory(this.userApis);
        tab = new CreativeTabsCellar("creative_tab_grccellar");
        this.modules.preInit();
        this.register();
    }

    private void addDefaultHeatSources() {
        this.userApis.getUserHeatSources().addDefault("minecraft", "fire", UserHeatSourceEntry.newWildcardHeat(1.0f)).setComment("Fire!");
        this.userApis.getUserHeatSources().addDefault("minecraft", "flowing_lava", UserHeatSourceEntry.newWildcardHeat(0.7f)).setComment("We need to register both states of lava, this when its flowing");
        this.userApis.getUserHeatSources().addDefault("minecraft", "lava", UserHeatSourceEntry.newWildcardHeat(0.7f)).setComment("And when its a still pool.");
    }

    private void registerBoozeModifierFunctions() {
        CellarRegistry.instance().booze().setModifierFunction(BoozeTag.POTENT, new ModifierFunctionPotent());
        CellarRegistry.instance().booze().setModifierFunction(BoozeTag.EXTENDED, new ModifierFunctionExtended());
        CellarRegistry.instance().booze().setModifierFunction(BoozeTag.HYPER_EXTENDED, new ModifierFunctionHyperExtended());
    }

    private void register() {
        this.modules.register();
        this.addDefaultHeatSources();
        GameRegistry.registerTileEntity(TileEntityFruitPress.class, (String)"grc.tileentity.fruitPress");
        GameRegistry.registerTileEntity(TileEntityFruitPresser.class, (String)"grc.tileentity.fruitPresser");
        GameRegistry.registerTileEntity(TileEntityBrewKettle.class, (String)"grc.tileentity.brewKettle");
        GameRegistry.registerTileEntity(TileEntityFermentBarrel.class, (String)"grc.tileentity.fermentBarrel");
        GameRegistry.registerTileEntity(TileEntityCultureJar.class, (String)"grc.tileentity.fermentJar");
        MapGenHelper.registerVillageStructure(ComponentVillageTavern.class, "grc.tavern");
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftCellar.blocks.fruitPress.asStack(), new Object[]{"ABA", "CCC", "AAA", Character.valueOf('A'), "plankWood", Character.valueOf('B'), Blocks.field_150331_J, Character.valueOf('C'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftCellar.blocks.brewKettle.asStack(), new Object[]{"A", Character.valueOf('A'), Items.field_151066_bu}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftCellar.blocks.fermentBarrel.asStack(), new Object[]{"AAA", "BBB", "AAA", Character.valueOf('B'), "plankWood", Character.valueOf('A'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftCellar.blocks.cultureJar.asStack(), new Object[]{"GAG", "G G", "GGG", Character.valueOf('A'), "plankWood", Character.valueOf('G'), "paneGlass"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 16), new Object[]{"AAA", "ABA", "AAA", Character.valueOf('A'), Items.field_151116_aA, Character.valueOf('B'), "materialRope"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 0), new Object[]{"dyeWhite", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 1), new Object[]{"dyeOrange", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 2), new Object[]{"dyeMagenta", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 3), new Object[]{"dyeLightBlue", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 4), new Object[]{"dyeYellow", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 5), new Object[]{"dyeLime", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 6), new Object[]{"dyePink", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 7), new Object[]{"dyeGray", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 8), new Object[]{"dyeLightGray", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 9), new Object[]{"dyeCyan", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 10), new Object[]{"dyePurple", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 11), new Object[]{"dyeBlue", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 12), new Object[]{"dyeBrown", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 13), new Object[]{"dyeGreen", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 14), new Object[]{"dyeRed", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftCellar.items.waterBag.asStack(1, 15), new Object[]{"dyeBlack", GrowthCraftCellar.items.waterBag.asStack(1, Short.MAX_VALUE)}));
        this.extendPotionsArray();
        EffectTipsy.potionTipsy = potionTipsy = new PotionCellar(this.config.potionTipsyID, false, 0).func_76399_b(0, 0).func_76390_b("grc.potion.tipsy");
        EffectTipsy.achievement = CellarAchievement.GET_DRUNK;
        achievements = new GrcCellarAchievements();
        NEI.hideItem(GrowthCraftCellar.items.chievItemDummy.asStack());
    }

    private void extendPotionsArray() {
        int newSize = 1024;
        for (Field f : Potion.class.getDeclaredFields()) {
            f.setAccessible(true);
            try {
                if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
                Field modfield = Field.class.getDeclaredField("modifiers");
                modfield.setAccessible(true);
                modfield.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                Potion[] potionTypes = (Potion[])f.get(null);
                if (potionTypes.length >= 1024) continue;
                this.logger.warn("Resizing PotionTypes array from %d to %d", potionTypes.length, 1024);
                Potion[] newPotionTypes = new Potion[1024];
                System.arraycopy(potionTypes, 0, newPotionTypes, 0, potionTypes.length);
                f.set(null, newPotionTypes);
            }
            catch (Exception e) {
                System.err.println("GrowthCraft|Cellar has encountered a problem with the built-in potionTypes Array, please report this problem to the mod authors.");
                e.printStackTrace();
            }
        }
    }

    private void registerOres() {
        OreDictionary.registerOre((String)"materialYeast", GrowthCraftCellar.items.yeast.getItem());
        OreDictionary.registerOre((String)"yeastBrewers", (ItemStack)EnumYeast.BREWERS.asStack());
        OreDictionary.registerOre((String)"yeastLager", (ItemStack)EnumYeast.LAGER.asStack());
        OreDictionary.registerOre((String)"yeastBayanus", (ItemStack)EnumYeast.BAYANUS.asStack());
        OreDictionary.registerOre((String)"yeastEthereal", (ItemStack)EnumYeast.ETHEREAL.asStack());
        OreDictionary.registerOre((String)"yeastOrigin", (ItemStack)EnumYeast.ORIGIN.asStack());
    }

    private void registerYeast() {
        CellarRegistry.instance().yeast().addYeast(EnumYeast.BREWERS.asStack());
        CellarRegistry.instance().yeast().addYeast(EnumYeast.LAGER.asStack());
        CellarRegistry.instance().yeast().addYeast(EnumYeast.BAYANUS.asStack());
        CellarRegistry.instance().yeast().addYeast(EnumYeast.ETHEREAL.asStack());
        CellarRegistry.instance().yeast().addYeast(EnumYeast.ORIGIN.asStack());
    }

    private void initVillageHandlers() {
        if (this.config.villagerBrewerID > 0) {
            VillagerRegistry.instance().registerVillagerId(this.config.villagerBrewerID);
        }
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandlerCellar());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.registerOres();
        this.registerYeast();
        packetPipeline.initialise();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiProvider);
        if (this.config.enableVillageGen) {
            this.initVillageHandlers();
        }
        this.modules.init();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
        this.userApis.loadConfigs();
        packetPipeline.postInitialise();
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerItemCraftedEventCellar());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerLivingUpdateEventCellar());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCauldronUseItem());
        this.modules.postInit();
        if (!this.config.boozeEffectsEnabled) {
            this.logger.debug("Stripping ALL booze effects except tipsy", new Object[0]);
            for (BoozeEntry entry : CellarRegistry.instance().booze().getBoozeEntries()) {
                entry.getEffect().clearEffects();
            }
        }
    }

    static {
        blocks = new GrcCellarBlocks();
        items = new GrcCellarItems();
        packetPipeline = new PacketPipeline();
        CELLAR_BUS = new EventBus();
        guiProvider = new GrcGuiProvider(new GrcLogger("Growthcraft|Cellar:GuiProvider"));
    }
}

