/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.init;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.bees.BeesFluidTag;
import growthcraft.api.cellar.booze.BoozeTag;
import growthcraft.api.core.effect.EffectAddPotionEffect;
import growthcraft.api.core.effect.EffectWeightedRandomList;
import growthcraft.api.core.effect.SimplePotionEffectFactory;
import growthcraft.api.core.fluids.TaggedFluidStacks;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.item.recipes.ShapelessMultiRecipe;
import growthcraft.api.core.util.TickUtils;
import growthcraft.bees.GrowthCraftBees;
import growthcraft.bees.common.item.EnumBeesWax;
import growthcraft.cellar.GrowthCraftCellar;
import growthcraft.cellar.util.BoozeUtils;
import growthcraft.core.GrowthCraftCore;
import growthcraft.core.common.GrcModuleBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GrcBeesRecipes
extends GrcModuleBase {
    private void registerCellarRecipes() {
        int fermentTime = GrowthCraftCellar.getConfig().fermentTime;
        FluidStack[] fs = new FluidStack[GrowthCraftBees.fluids.honeyMeadBooze.length];
        for (int i = 0; i < GrowthCraftBees.fluids.honeyMeadBooze.length; ++i) {
            fs[i] = new FluidStack((Fluid)GrowthCraftBees.fluids.honeyMeadBooze[i], 1);
        }
        GrowthCraftCellar.boozeBuilderFactory.create(GrowthCraftBees.fluids.honeyMeadBooze[0]).tags(BoozeTag.YOUNG, BeesFluidTag.MEAD);
        TaggedFluidStacks youngMead = new TaggedFluidStacks(1, "young", "mead");
        GrowthCraftCellar.boozeBuilderFactory.create(GrowthCraftBees.fluids.honeyMeadBooze[1]).tags(BoozeTag.FERMENTED, BeesFluidTag.MEAD).fermentsFrom(youngMead, new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(youngMead, new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76428_l, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(GrowthCraftBees.fluids.honeyMeadBooze[2]).tags(BoozeTag.FERMENTED, BoozeTag.POTENT, BeesFluidTag.MEAD).fermentsFrom(fs[1], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.17f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76428_l, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(GrowthCraftBees.fluids.honeyMeadBooze[3]).tags(BoozeTag.FERMENTED, BoozeTag.EXTENDED, BeesFluidTag.MEAD).fermentsFrom(fs[1], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[2], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76428_l, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(GrowthCraftBees.fluids.honeyMeadBooze[4]).tags(BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED, BeesFluidTag.MEAD).fermentsFrom(fs[2], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addPotionEntry(Potion.field_76428_l, TickUtils.seconds(90), 0);
        GrowthCraftCellar.boozeBuilderFactory.create(GrowthCraftBees.fluids.honeyMeadBooze[5]).tags(BoozeTag.FERMENTED, BoozeTag.INTOXICATED, BeesFluidTag.MEAD).fermentsFrom(fs[2], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.22500001f), TickUtils.seconds(90)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76428_l.field_76415_H, TickUtils.seconds(90), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(Potion.field_76436_u.field_76415_H, TickUtils.seconds(90), 2))));
        GrowthCraftCellar.boozeBuilderFactory.create(GrowthCraftBees.fluids.honeyMeadBooze[6]).tags(BoozeTag.FERMENTED, BoozeTag.POISONED, BeesFluidTag.MEAD).fermentsFrom(fs[0], new OreItemStacks("yeastPoison", 1), fermentTime).fermentsFrom(fs[1], new OreItemStacks("yeastPoison", 1), fermentTime).fermentsFrom(fs[2], new OreItemStacks("yeastPoison", 1), fermentTime).fermentsFrom(fs[3], new OreItemStacks("yeastPoison", 1), fermentTime).fermentsFrom(fs[4], new OreItemStacks("yeastPoison", 1), fermentTime).fermentsFrom(fs[5], new OreItemStacks("yeastPoison", 1), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).createPotionEntry(Potion.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthCraftCore.getConfig().hidePoisonedBooze);
    }

    @Override
    public void register() {
        ItemStack emptyComb = GrowthCraftBees.items.honeyCombEmpty.asStack();
        GameRegistry.addShapelessRecipe((ItemStack)EnumBeesWax.NORMAL.asStack(), (Object[])new Object[]{emptyComb, emptyComb, emptyComb, emptyComb, emptyComb, emptyComb, emptyComb, emptyComb, emptyComb});
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(EnumBeesWax.BLACK.asStack(), new Object[]{EnumBeesWax.NORMAL.asStack(), "dyeBlack"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(EnumBeesWax.RED.asStack(), new Object[]{EnumBeesWax.NORMAL.asStack(), "dyeRed"}));
        this.registerCellarRecipes();
    }

    @Override
    public void postInit() {
        ItemStack meadBucket = GrowthCraftBees.fluids.honeyMeadBuckets[0].asStack();
        ItemStack meadBottle = GrowthCraftBees.fluids.honeyMeadBottle.asStack();
        int bottleCapacity = GrowthCraftCore.getConfig().bottleCapacity;
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(meadBucket, Items.field_151133_ar, new TaggedFluidStacks(1000, "honey"), new FluidStack(FluidRegistry.WATER, 1000)));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(GrowthCraftBees.fluids.honeyMeadBottle.asStack(3), Items.field_151069_bo, Items.field_151069_bo, Items.field_151069_bo, new TaggedFluidStacks(1000, "honey"), new FluidStack(FluidRegistry.WATER, 1000)));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(meadBottle, Items.field_151069_bo, new TaggedFluidStacks(bottleCapacity, "honey"), new FluidStack(FluidRegistry.WATER, bottleCapacity)));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(meadBucket, Items.field_151133_ar, new OreItemStacks("bucketHoney"), new FluidStack(FluidRegistry.WATER, 1000)));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(meadBottle, Items.field_151069_bo, new OreItemStacks("bottleHoney"), new FluidStack(FluidRegistry.WATER, bottleCapacity)));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(GrowthCraftBees.items.honeyJar.asStack(), Blocks.field_150457_bL, new TaggedFluidStacks(1000, "honey")));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftBees.items.honeyJar.asStack(), new Object[]{Blocks.field_150457_bL, "bucketHoney"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(GrowthCraftBees.fluids.honey.asBucketItemStack(), Items.field_151133_ar, new TaggedFluidStacks(1000, "honey")));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftBees.fluids.honey.asBucketItemStack(), new Object[]{"bucketHoney", Items.field_151133_ar}));
        GameRegistry.addRecipe((IRecipe)new ShapelessMultiRecipe(GrowthCraftBees.fluids.honey.asBottleItemStack(3), Items.field_151069_bo, Items.field_151069_bo, Items.field_151069_bo, new TaggedFluidStacks(1000, "honey")));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftBees.fluids.honey.asBottleItemStack(3), new Object[]{Items.field_151069_bo, Items.field_151069_bo, Items.field_151069_bo, "bucketHoney"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftBees.fluids.honey.asBottleItemStack(3), new Object[]{Items.field_151069_bo, Items.field_151069_bo, Items.field_151069_bo, "bottleHoney", "bottleHoney", "bottleHoney"}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(GrowthCraftBees.fluids.honey.asBucketItemStack(), new Object[]{Items.field_151133_ar, "bottleHoney", "bottleHoney", "bottleHoney"}));
    }
}

