/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.fishtrap.user;

import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.api.fishtrap.FishTrapEntry;
import growthcraft.api.fishtrap.FishTrapRegistry;
import growthcraft.api.fishtrap.user.UserFishTrapEntries;
import growthcraft.api.fishtrap.user.UserFishTrapEntry;
import java.io.BufferedReader;
import java.io.Reader;

public class UserFishTrapConfig
extends AbstractUserJSONConfig {
    private final UserFishTrapEntries defaultEntries = new UserFishTrapEntries();
    private UserFishTrapEntries entries;

    public void addDefault(String group, FishTrapEntry entry) {
        this.defaultEntries.data.add(new UserFishTrapEntry(group, entry));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserFishTrapEntries)this.gson.fromJson((Reader)buff, UserFishTrapEntries.class);
    }

    private void addFishTrapEntry(UserFishTrapEntry entry) {
        if (entry == null) {
            this.logger.error("Invalid Entry", new Object[0]);
            return;
        }
        if (entry.item == null || entry.item.isInvalid()) {
            this.logger.error("Invalid item for entry {%s}", entry);
            return;
        }
        for (FishTrapEntry obj : entry.getFishTrapEntries()) {
            FishTrapRegistry.instance().addCatchToGroup(obj, entry.group);
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d user fish trap entries.", this.entries.data.size());
                for (UserFishTrapEntry entry : this.entries.data) {
                    this.addFishTrapEntry(entry);
                }
            } else {
                this.logger.error("Config contains invalid data.", new Object[0]);
            }
        }
    }
}

