/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.stream;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class StreamUtils {
    private StreamUtils() {
    }

    public static String readStringASCII(ByteBuf stream) throws UnsupportedEncodingException {
        int len = stream.readInt();
        byte[] bytes = stream.readBytes(len).array();
        return new String(bytes, "US-ASCII");
    }

    public static void writeStringASCII(ByteBuf stream, String str) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes("US-ASCII");
        stream.writeInt(str.length());
        stream.writeBytes(bytes);
    }

    public static void readFluidTank(ByteBuf stream, FluidTank tank) {
        int capacity = stream.readInt();
        int fluidId = stream.readInt();
        int fluidAmount = stream.readInt();
        Fluid fluid = fluidId > -1 ? FluidRegistry.getFluid((int)fluidId) : null;
        FluidStack fluidStack = fluid != null ? new FluidStack(fluid, fluidAmount) : null;
        tank.setCapacity(capacity);
        tank.setFluid(fluidStack);
    }

    public static void writeFluidTank(ByteBuf stream, FluidTank tank) {
        int fluidId = -1;
        int fluidAmount = 0;
        int capacity = tank.getCapacity();
        FluidStack fs = tank.getFluid();
        if (fs != null) {
            fluidId = fs.getFluidID();
            fluidAmount = fs.amount;
        }
        stream.writeInt(capacity);
        stream.writeInt(fluidId);
        stream.writeInt(fluidAmount);
    }
}

