/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.registry;

import growthcraft.api.core.registry.IItemRegistryEntry;
import java.util.LinkedList;
import java.util.List;

public class GenericItemRegistry<ItemType, T extends IItemRegistryEntry<ItemType>> {
    protected List<T> entries = new LinkedList<T>();

    public void add(T entry) {
        this.entries.add(entry);
    }

    public T find(ItemType item) {
        if (item == null) {
            return null;
        }
        for (IItemRegistryEntry entry : this.entries) {
            if (!entry.matches(item)) continue;
            return (T)entry;
        }
        return null;
    }

    public boolean contains(ItemType item) {
        return this.find(item) != null;
    }
}

