/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.item;

import com.google.common.base.CaseFormat;
import growthcraft.api.core.definition.IItemStackFactory;
import java.util.Locale;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public enum EnumDye implements IItemStackFactory
{
    BLACK,
    RED,
    GREEN,
    BROWN,
    BLUE,
    PURPLE,
    CYAN,
    LIGHT_GRAY,
    GRAY,
    PINK,
    LIME,
    YELLOW,
    LIGHT_BLUE,
    MAGENTA,
    ORANGE,
    WHITE;

    public static final EnumDye INK_SAC;
    public static final EnumDye CACTUS_GREEN;
    public static final EnumDye COCOA_BEANS;
    public static final EnumDye LAPIS_LAZULI;
    public static final EnumDye BONE_MEAL;
    public static final EnumDye[] VALUES;
    public final int meta;
    public final String name = this.name().toLowerCase(Locale.ENGLISH);

    private EnumDye() {
        this.meta = this.ordinal();
    }

    @Override
    public ItemStack asStack(int size) {
        return new ItemStack(Items.field_151100_aR, size, this.meta);
    }

    @Override
    public ItemStack asStack() {
        return this.asStack(1);
    }

    public String getOreName() {
        return String.format("dye%s", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name()));
    }

    public static EnumDye getByMeta(int meta) {
        if (meta < 0 || meta >= VALUES.length) {
            return BLACK;
        }
        return VALUES[meta];
    }

    static {
        INK_SAC = BLACK;
        CACTUS_GREEN = GREEN;
        COCOA_BEANS = BROWN;
        LAPIS_LAZULI = BLUE;
        BONE_MEAL = WHITE;
        VALUES = EnumDye.values();
    }
}

