/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.fluids.user;

import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.fluids.FluidTag;
import growthcraft.api.core.fluids.IFluidDictionary;
import growthcraft.api.core.fluids.IFluidTagsRegistry;
import growthcraft.api.core.fluids.user.UserFluidDictionaryEntries;
import growthcraft.api.core.fluids.user.UserFluidDictionaryEntry;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraftforge.fluids.Fluid;

public class UserFluidDictionaryConfig
extends AbstractUserJSONConfig {
    private final UserFluidDictionaryEntries defaultEntries = new UserFluidDictionaryEntries();
    private UserFluidDictionaryEntries entries;

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.entries = (UserFluidDictionaryEntries)this.gson.fromJson((Reader)reader, UserFluidDictionaryEntries.class);
    }

    private void addFluidDictionaryEntry(UserFluidDictionaryEntry entry) {
        if (entry == null) {
            this.logger.error("Entry was invalid", new Object[0]);
            return;
        }
        if (entry.getFluid() == null) {
            this.logger.error("Entry fluid is invalid! %s", entry);
            return;
        }
        if (entry.tags == null) {
            this.logger.error("Entry tags are invalid! %s", entry);
            return;
        }
        IFluidTagsRegistry fluidTags = CoreRegistry.instance().fluidTags();
        IFluidDictionary fluidDict = CoreRegistry.instance().fluidDictionary();
        Fluid fluid = entry.getFluid();
        for (String tagName : entry.tags) {
            FluidTag fluidTag = fluidTags.findTag(tagName);
            if (fluidTag == null) {
                this.logger.warn("Creating new FluidTag '%s'", tagName);
                fluidTag = fluidTags.createTag(tagName);
            }
            fluidDict.addFluidTags(fluid, fluidTag);
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d fluid dictionary entries.", this.entries.data.size());
                for (UserFluidDictionaryEntry entry : this.entries.data) {
                    this.addFluidDictionaryEntry(entry);
                }
            } else {
                this.logger.error("Invalid fluid dictionary entries data", new Object[0]);
            }
        }
    }
}

