/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.fluids;

import growthcraft.api.core.definition.IFluidStackFactory;
import growthcraft.api.core.nbt.NBTHelper;
import growthcraft.api.core.util.HashKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidKey
extends HashKey
implements IFluidStackFactory {
    public final Fluid fluid;
    public final NBTTagCompound compoundTag;

    public FluidKey(@Nonnull Fluid pfluid, @Nullable NBTTagCompound tag) {
        this.fluid = pfluid;
        this.compoundTag = NBTHelper.compoundTagPresence(tag);
        this.generateHashCode();
    }

    public FluidKey(@Nonnull Fluid pfluid) {
        this(pfluid, null);
    }

    public FluidKey(@Nonnull FluidStack pfluidStack) {
        this(pfluidStack.getFluid(), pfluidStack.tag);
    }

    private void generateHashCode() {
        this.hash = this.fluid.hashCode();
        this.hash = 31 * this.hash + (this.compoundTag != null ? this.compoundTag.hashCode() : 0);
    }

    @Override
    public FluidStack asFluidStack(int size) {
        return new FluidStack(this.fluid, size, NBTHelper.copyCompoundTag(this.compoundTag));
    }

    @Override
    public FluidStack asFluidStack() {
        return this.asFluidStack(1);
    }
}

