/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.pressing.user;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.common.Residue;
import growthcraft.api.cellar.pressing.user.UserPressingRecipe;
import growthcraft.api.cellar.pressing.user.UserPressingRecipes;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.schema.FluidStackSchema;
import growthcraft.api.core.schema.ItemKeySchema;
import growthcraft.api.core.schema.ResidueSchema;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraftforge.fluids.FluidStack;

public class UserPressingRecipesConfig
extends AbstractUserJSONConfig {
    private final UserPressingRecipes defaultRecipes = new UserPressingRecipes();
    private UserPressingRecipes recipes;

    public void addDefault(UserPressingRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
    }

    public void addDefault(ItemKeySchema itm, FluidStackSchema fl, int tm, ResidueSchema res) {
        this.addDefault(new UserPressingRecipe(itm, fl, tm, res));
    }

    public void addDefault(Object stack, FluidStack fluid, int time, Residue res) {
        for (ItemKeySchema itemKey : ItemKeySchema.createMulti(stack)) {
            this.addDefault(itemKey, new FluidStackSchema(fluid), time, res == null ? null : new ResidueSchema(res));
        }
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserPressingRecipes)this.gson.fromJson((Reader)reader, UserPressingRecipes.class);
    }

    protected void addPressingRecipe(UserPressingRecipe recipe) {
        if (recipe == null) {
            this.logger.error("NULL RECIPE", new Object[0]);
            return;
        }
        if (recipe.item == null || recipe.item.isInvalid()) {
            this.logger.error("Item is invalid for recipe {%s}", recipe);
            return;
        }
        if (recipe.fluid == null) {
            this.logger.error("No result fluid for recipe {%s}", recipe);
            return;
        }
        FluidStack fluidStack = recipe.fluid.asFluidStack();
        if (fluidStack == null) {
            this.logger.error("Invalid fluid for recipe {%s}", recipe);
            return;
        }
        Residue residue = null;
        if (recipe.residue != null && (residue = recipe.residue.asResidue()) == null) {
            this.logger.error("Not a valid residue found for {%s}", recipe);
            return;
        }
        this.logger.debug("Adding pressing recipe {%s}", recipe);
        for (IMultiItemStacks item : recipe.item.getMultiItemStacks()) {
            CellarRegistry.instance().pressing().addRecipe(item, fluidStack, recipe.time, residue);
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                this.logger.debug("Adding %d user pressing recipes.", this.recipes.data.size());
                for (UserPressingRecipe recipe : this.recipes.data) {
                    this.addPressingRecipe(recipe);
                }
            } else {
                this.logger.error("Recipe data is invalid!", new Object[0]);
            }
        }
    }
}

