/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.fermenting;

import growthcraft.api.cellar.fermenting.IFermentationRecipe;
import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.item.ItemTest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FermentationRecipe
implements IFermentationRecipe {
    private final IMultiItemStacks fermentingItem;
    private final IMultiFluidStacks inputFluidStack;
    private final FluidStack outputFluidStack;
    private final int time;

    public FermentationRecipe(@Nonnull IMultiFluidStacks pInputFluidStack, @Nonnull IMultiItemStacks pFermentingItem, @Nonnull FluidStack pOutputFluidStack, int pTime) {
        this.fermentingItem = pFermentingItem;
        this.inputFluidStack = pInputFluidStack;
        this.outputFluidStack = pOutputFluidStack;
        this.time = pTime;
    }

    @Override
    public IMultiFluidStacks getInputFluidStack() {
        return this.inputFluidStack;
    }

    @Override
    public FluidStack getOutputFluidStack() {
        return this.outputFluidStack;
    }

    @Override
    public IMultiItemStacks getFermentingItemStack() {
        return this.fermentingItem;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean matchesRecipe(@Nullable FluidStack fluidStack, @Nullable ItemStack itemStack) {
        if (FluidTest.isValid(fluidStack) && ItemTest.isValid(itemStack) && FluidTest.hasEnough(this.inputFluidStack, fluidStack)) {
            return ItemTest.hasEnough(this.fermentingItem, itemStack);
        }
        return false;
    }

    @Override
    public boolean matchesIngredient(@Nullable FluidStack fluidStack) {
        return FluidTest.fluidMatches(this.inputFluidStack, fluidStack);
    }

    @Override
    public boolean matchesIngredient(@Nullable ItemStack stack) {
        return ItemTest.itemMatches(this.fermentingItem, stack);
    }
}

