/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.culturing.user;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.culturing.user.UserCultureRecipe;
import growthcraft.api.cellar.culturing.user.UserCultureRecipes;
import growthcraft.api.core.schema.FluidStackSchema;
import growthcraft.api.core.schema.ItemKeySchema;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UserCultureRecipesConfig
extends AbstractUserJSONConfig {
    private final UserCultureRecipes defaultRecipes = new UserCultureRecipes();
    private UserCultureRecipes recipes;

    public void addDefault(UserCultureRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
    }

    public void addDefault(FluidStack inp, ItemStack stack, float heat, int time) {
        this.addDefault(new UserCultureRecipe(new FluidStackSchema(inp), new ItemKeySchema(stack), heat, time));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserCultureRecipes)this.gson.fromJson((Reader)reader, UserCultureRecipes.class);
    }

    private void addRecipe(UserCultureRecipe recipe) {
        if (recipe == null) {
            this.logger.error("Invalid recipe", new Object[0]);
            return;
        }
        if (recipe.output_item == null || recipe.output_item.isInvalid()) {
            this.logger.error("Invalid output_item for recipe {%s}", recipe);
            return;
        }
        if (recipe.input_fluid == null || recipe.input_fluid.isInvalid()) {
            this.logger.error("Invalid input_fluid {%s}", recipe);
            return;
        }
        FluidStack inputFluidStack = recipe.input_fluid.asFluidStack();
        this.logger.debug("Adding user culturing recipe {%s}", recipe);
        CellarRegistry.instance().culturing().addRecipe(inputFluidStack, recipe.output_item.asStack(), recipe.required_heat, recipe.time);
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                this.logger.debug("Adding %d user culturing recipes.", this.recipes.data.size());
                for (UserCultureRecipe recipe : this.recipes.data) {
                    this.addRecipe(recipe);
                }
            } else {
                this.logger.error("Recipes data is invalid!", new Object[0]);
            }
        }
    }
}

