/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.legacy;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import growthcraft.core.shared.item.ItemUtils;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class FluidContainerRegistry {
    private static Map<ContainerKey, FluidContainerData> containerFluidMap = Maps.newHashMap();
    private static Map<ContainerKey, FluidContainerData> filledContainerMap = Maps.newHashMap();
    private static Set<ContainerKey> emptyContainers = Sets.newHashSet();
    public static final int BUCKET_VOLUME = 1000;
    public static final int BOTTLE_VOLUME = 250;
    public static final ItemStack EMPTY_BUCKET = new ItemStack(Items.field_151133_ar);
    public static final ItemStack EMPTY_BOTTLE = new ItemStack(Items.field_151069_bo);
    private static final ItemStack NULL_EMPTYCONTAINER = new ItemStack(Items.field_151133_ar);

    private FluidContainerRegistry() {
    }

    public static boolean addBucketForFluid(Fluid fluid) {
        if (!FluidRegistry.addBucketForFluid((Fluid)fluid)) {
            return false;
        }
        UniversalBucket universalBucket = ForgeModContainer.getInstance().universalBucket;
        ItemStack emptyContainer = new ItemStack(Items.field_151133_ar, 1);
        ItemStack filledContainer = UniversalBucket.getFilledBucket((UniversalBucket)universalBucket, (Fluid)fluid);
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer, emptyContainer);
    }

    public static boolean registerFluidContainer(FluidStack stack, ItemStack filledContainer, ItemStack emptyContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, emptyContainer));
    }

    public static boolean registerFluidContainer(Fluid fluid, ItemStack filledContainer, ItemStack emptyContainer) {
        if (!FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            FluidRegistry.registerFluid((Fluid)fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer, emptyContainer);
    }

    public static boolean registerFluidContainer(FluidStack stack, ItemStack filledContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, null, true));
    }

    public static boolean registerFluidContainer(Fluid fluid, ItemStack filledContainer) {
        if (!FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            FluidRegistry.registerFluid((Fluid)fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer);
    }

    public static boolean registerFluidContainer(FluidContainerData data) {
        if (FluidContainerRegistry.isFilledContainer(data.filledContainer) || data.filledContainer == null) {
            return false;
        }
        if (data.fluid == null || data.fluid.getFluid() == null) {
            FMLLog.bigWarning((String)"Invalid registration attempt for a fluid container item %s has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", (Object[])new Object[]{data.filledContainer.func_77973_b().func_77667_c(data.filledContainer)});
            return false;
        }
        containerFluidMap.put(new ContainerKey(data.filledContainer), data);
        if (data.emptyContainer != null && data.emptyContainer != NULL_EMPTYCONTAINER) {
            filledContainerMap.put(new ContainerKey(data.emptyContainer, data.fluid), data);
            emptyContainers.add(new ContainerKey(data.emptyContainer));
        }
        MinecraftForge.EVENT_BUS.post((Event)new FluidContainerRegisterEvent(data));
        return true;
    }

    public static ItemStack getContainerItemWithFallback(ItemStack stack) {
        ItemStack result = ForgeHooks.getContainerItem((ItemStack)stack);
        if (!ItemUtils.isEmpty(result)) {
            return result;
        }
        result = FluidContainerRegistry.drainFluidContainer(stack);
        if (!ItemUtils.isEmpty(result)) {
            return result;
        }
        return ItemStack.field_190927_a;
    }

    public static FluidStack getFluidForFilledItem(ItemStack container) {
        if (container == null) {
            return null;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data == null ? null : data.fluid.copy();
    }

    public static ItemStack fillFluidContainer(FluidStack fluid, ItemStack container) {
        if (ItemUtils.isEmpty(container) || fluid == null) {
            return null;
        }
        FluidContainerData data = filledContainerMap.get(new ContainerKey(container, fluid));
        if (data != null && fluid.amount >= data.fluid.amount) {
            return data.filledContainer.func_77946_l();
        }
        return null;
    }

    public static ItemStack drainFluidContainer(ItemStack container) {
        if (ItemUtils.isEmpty(container)) {
            return null;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        if (data != null) {
            return data.emptyContainer.func_77946_l();
        }
        return null;
    }

    public static int getContainerCapacity(ItemStack container) {
        return FluidContainerRegistry.getContainerCapacity(null, container);
    }

    public static int getContainerCapacity(FluidStack fluid, ItemStack container) {
        if (container == null) {
            return 0;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        if (data != null) {
            return data.fluid.amount;
        }
        if (fluid != null && (data = filledContainerMap.get(new ContainerKey(container, fluid))) != null) {
            return data.fluid.amount;
        }
        return 0;
    }

    public static boolean containsFluid(ItemStack container, FluidStack fluid) {
        if (container == null || fluid == null) {
            return false;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data == null ? false : data.fluid.containsFluid(fluid);
    }

    public static boolean isBucket(ItemStack container) {
        if (container == null) {
            return false;
        }
        if (container.func_77969_a(EMPTY_BUCKET)) {
            return true;
        }
        FluidContainerData data = containerFluidMap.get(new ContainerKey(container));
        return data != null && data.emptyContainer.func_77969_a(EMPTY_BUCKET);
    }

    public static boolean isContainer(ItemStack container) {
        return FluidContainerRegistry.isEmptyContainer(container) || FluidContainerRegistry.isFilledContainer(container);
    }

    public static boolean isEmptyContainer(ItemStack container) {
        return container != null && emptyContainers.contains(new ContainerKey(container));
    }

    public static boolean isFilledContainer(ItemStack container) {
        return container != null && FluidContainerRegistry.getFluidForFilledItem(container) != null;
    }

    public static FluidContainerData[] getRegisteredFluidContainerData() {
        return containerFluidMap.values().toArray(new FluidContainerData[containerFluidMap.size()]);
    }

    static {
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new ItemStack(Items.field_151131_as), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.LAVA, new ItemStack(Items.field_151129_at), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(new FluidStack(FluidRegistry.WATER, 250), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b), EMPTY_BOTTLE);
    }

    public static class FluidContainerRegisterEvent
    extends Event {
        public final FluidContainerData data;

        public FluidContainerRegisterEvent(FluidContainerData data) {
            this.data = data.copy();
        }
    }

    public static class FluidContainerData {
        public final FluidStack fluid;
        public final ItemStack filledContainer;
        public final ItemStack emptyContainer;

        public FluidContainerData(FluidStack stack, ItemStack filledContainer, ItemStack emptyContainer) {
            this(stack, filledContainer, emptyContainer, false);
        }

        public FluidContainerData(FluidStack stack, ItemStack filledContainer, ItemStack emptyContainer, boolean nullEmpty) {
            this.fluid = stack;
            this.filledContainer = filledContainer;
            ItemStack itemStack = this.emptyContainer = emptyContainer == null ? NULL_EMPTYCONTAINER : emptyContainer;
            if (stack == null || filledContainer == null || emptyContainer == null && !nullEmpty) {
                throw new RuntimeException("Invalid FluidContainerData - a parameter was null.");
            }
        }

        public FluidContainerData copy() {
            return new FluidContainerData(this.fluid, this.filledContainer, this.emptyContainer, true);
        }
    }

    private static class ContainerKey {
        ItemStack container;
        FluidStack stack;

        private ContainerKey(ItemStack container) {
            this.container = container;
        }

        private ContainerKey(ItemStack container, FluidStack stack) {
            this(container);
            this.stack = stack;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.container.func_77973_b().hashCode();
            code = 31 * code + this.container.func_77952_i();
            if (this.container.func_77978_p() != null) {
                code = 31 * code + this.container.func_77978_p().hashCode();
            }
            if (this.stack != null) {
                code = 31 * code + this.stack.getFluid().hashCode();
            }
            return code;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ContainerKey)) {
                return false;
            }
            ContainerKey ck = (ContainerKey)o;
            if (!ItemStack.func_179545_c((ItemStack)this.container, (ItemStack)ck.container)) {
                return false;
            }
            if (!ItemStack.func_77970_a((ItemStack)this.container, (ItemStack)ck.container)) {
                return false;
            }
            if (this.stack == null && ck.stack != null) {
                return false;
            }
            if (this.stack != null && ck.stack == null) {
                return false;
            }
            if (this.stack == null && ck.stack == null) {
                return true;
            }
            if (this.stack.getFluid() != ck.stack.getFluid()) {
                return false;
            }
            return FluidStack.areFluidStackTagsEqual((FluidStack)this.stack, (FluidStack)this.stack);
        }
    }
}

