/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.pressing.user;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.config.schema.ResidueSchema;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.cellar.shared.processing.pressing.user.UserPressingRecipe;
import growthcraft.cellar.shared.processing.pressing.user.UserPressingRecipes;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import growthcraft.core.shared.config.schema.FluidStackSchema;
import growthcraft.core.shared.config.schema.ItemKeySchema;
import growthcraft.core.shared.definition.IMultiItemStacks;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraftforge.fluids.FluidStack;

public class UserPressingRecipesConfig
extends AbstractUserJSONConfig {
    private final UserPressingRecipes defaultRecipes = new UserPressingRecipes();
    private UserPressingRecipes recipes;

    public void addDefault(UserPressingRecipe recipe) {
        this.defaultRecipes.data.add(recipe);
    }

    public void addDefault(ItemKeySchema itm, FluidStackSchema fl, int tm, ResidueSchema res) {
        this.addDefault(new UserPressingRecipe(itm, fl, tm, res));
    }

    public void addDefault(Object stack, FluidStack fluid, int time, Residue res) {
        for (ItemKeySchema itemKey : ItemKeySchema.createMulti(stack)) {
            this.addDefault(itemKey, new FluidStackSchema(fluid), time, res == null ? null : new ResidueSchema(res));
        }
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserPressingRecipes)this.gson.fromJson((Reader)reader, UserPressingRecipes.class);
    }

    protected void addPressingRecipe(UserPressingRecipe recipe) {
        if (recipe == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("NULL RECIPE");
            return;
        }
        if (recipe.item == null || recipe.item.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Item is invalid for recipe {%s}", (Object)recipe);
            return;
        }
        if (recipe.fluid == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("No result fluid for recipe {%s}", (Object)recipe);
            return;
        }
        FluidStack fluidStack = recipe.fluid.asFluidStack();
        if (fluidStack == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Invalid fluid for recipe {%s}", (Object)recipe);
            return;
        }
        Residue residue = null;
        if (recipe.residue != null && (residue = recipe.residue.asResidue()) == null) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").error("Not a valid residue found for {%s}", (Object)recipe);
            return;
        }
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding pressing recipe {%s}", (Object)recipe);
        for (IMultiItemStacks item : recipe.item.getMultiItemStacks()) {
            CellarRegistry.instance().pressing().addRecipe(item, fluidStack, recipe.time, residue);
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding %d user pressing recipes.", (Object)this.recipes.data.size());
                for (UserPressingRecipe recipe : this.recipes.data) {
                    this.addPressingRecipe(recipe);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_cellar").error("Recipe data is invalid!");
            }
        }
    }
}

