/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.booze;

import growthcraft.cellar.shared.booze.BoozePotionEffectFactory;
import growthcraft.cellar.shared.booze.effect.EffectTipsy;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.effect.AbstractEffect;
import growthcraft.core.shared.effect.EffectAddPotionEffect;
import growthcraft.core.shared.effect.EffectList;
import growthcraft.core.shared.effect.IEffect;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BoozeEffect
extends AbstractEffect {
    private EffectTipsy tipsyEffect;
    private EffectList effects = new BoozeEffectList();
    private Fluid booze;

    public BoozeEffect(@Nonnull Fluid flu) {
        this.booze = flu;
    }

    public BoozeEffect() {
    }

    public BoozeEffect clearEffects() {
        this.effects.clear();
        return this;
    }

    public BoozeEffect addEffect(IEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public EffectAddPotionEffect createPotionEntry(@Nonnull Potion p, int time, int level) {
        BoozePotionEffectFactory factory = new BoozePotionEffectFactory(this.booze, p, time, level);
        EffectAddPotionEffect effect = new EffectAddPotionEffect(factory);
        this.addEffect(effect);
        return effect;
    }

    public BoozeEffect addPotionEntry(@Nonnull Potion p, int time, int level) {
        this.createPotionEntry(p, time, level);
        return this;
    }

    public EffectTipsy getTipsyEffect() {
        return this.tipsyEffect;
    }

    public BoozeEffect setTipsyEffect(EffectTipsy tipsy) {
        this.tipsyEffect = tipsy;
        return this;
    }

    public BoozeEffect setTipsy(float chance, int time) {
        this.setTipsyEffect(new EffectTipsy().setTipsy(chance, time));
        return this;
    }

    public BoozeEffect clearTipsy() {
        this.tipsyEffect = null;
        return this;
    }

    public EffectList getEffects() {
        return this.effects;
    }

    public boolean canCauseTipsy() {
        return this.tipsyEffect != null && this.tipsyEffect.canCauseTipsy();
    }

    public boolean hasEffects() {
        return this.effects.size() > 0;
    }

    public boolean isValid() {
        return this.canCauseTipsy() || this.hasEffects();
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        if (this.tipsyEffect != null) {
            this.tipsyEffect.apply(world, entity, random, data);
        }
        this.effects.apply(world, entity, random, data);
    }

    @Override
    protected void getActualDescription(List<String> list) {
        if (this.tipsyEffect != null) {
            this.tipsyEffect.getDescription(list);
        }
        this.effects.getDescription(list);
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        this.booze = null;
        this.tipsyEffect = null;
        if (data.func_74764_b("tipsy_effect")) {
            this.tipsyEffect = (EffectTipsy)CoreRegistry.instance().getEffectsRegistry().loadEffectFromNBT(data, "tipsy_effect");
        }
        this.effects = (BoozeEffectList)CoreRegistry.instance().getEffectsRegistry().loadEffectFromNBT(data, "effects");
        if (data.func_74764_b("fluid.name")) {
            this.booze = FluidRegistry.getFluid((String)data.func_74779_i("fluid.name"));
        }
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        if (this.tipsyEffect != null) {
            this.tipsyEffect.writeToNBT(data, "tipsy_effect");
        }
        this.effects.writeToNBT(data, "effects");
        if (this.booze != null) {
            data.func_74778_a("fluid.name", this.booze.getName());
        }
    }

    public static class BoozeEffectList
    extends EffectList {
        @Override
        public void getDescription(List<String> list) {
            for (IEffect effect : this.effects) {
                effect.getDescription(list);
            }
        }
    }
}

