/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared;

import growthcraft.cellar.shared.booze.BoozeEntry;
import growthcraft.cellar.shared.booze.BoozeRegistry;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.processing.brewing.BrewingRegistry;
import growthcraft.cellar.shared.processing.culturing.CulturingRegistry;
import growthcraft.cellar.shared.processing.fermenting.FermentingRegistry;
import growthcraft.cellar.shared.processing.heatsource.HeatSourceRegistry;
import growthcraft.cellar.shared.processing.pressing.PressingRegistry;
import growthcraft.cellar.shared.processing.yeast.YeastRegistry;
import growthcraft.core.shared.GrowthcraftLogger;

public class CellarRegistry {
    private static final CellarRegistry INSTANCE = new CellarRegistry();
    private final BoozeRegistry boozeRegistry = new BoozeRegistry();
    private final BrewingRegistry brewingRegistry = new BrewingRegistry();
    private final CulturingRegistry culturingRegistry = new CulturingRegistry();
    private final FermentingRegistry fermentingRegistry = new FermentingRegistry();
    private final HeatSourceRegistry heatSourceRegistry = new HeatSourceRegistry();
    private final PressingRegistry pressingRegistry = new PressingRegistry();
    private final YeastRegistry yeastRegistry = new YeastRegistry();

    public static final CellarRegistry instance() {
        return INSTANCE;
    }

    public BoozeRegistry booze() {
        return this.boozeRegistry;
    }

    public BrewingRegistry brewing() {
        return this.brewingRegistry;
    }

    public CulturingRegistry culturing() {
        return this.culturingRegistry;
    }

    public PressingRegistry pressing() {
        return this.pressingRegistry;
    }

    public FermentingRegistry fermenting() {
        return this.fermentingRegistry;
    }

    public HeatSourceRegistry heatSource() {
        return this.heatSourceRegistry;
    }

    public YeastRegistry yeast() {
        return this.yeastRegistry;
    }

    public static void onPostInit() {
        if (!GrowthcraftCellarConfig.boozeEffectsEnabled) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Stripping ALL booze effects except tipsy");
            for (BoozeEntry entry : CellarRegistry.instance().booze().getBoozeEntries()) {
                entry.getEffect().clearEffects();
            }
        }
    }
}

