/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.effect;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.effect.AbstractEffect;
import growthcraft.core.shared.effect.IPotionEffectFactory;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EffectAddPotionEffect
extends AbstractEffect {
    private IPotionEffectFactory potionFactory;

    public EffectAddPotionEffect(@Nonnull IPotionEffectFactory factory) {
        this.potionFactory = factory;
    }

    public EffectAddPotionEffect() {
    }

    public EffectAddPotionEffect setPotionFactory(@Nonnull IPotionEffectFactory factory) {
        this.potionFactory = factory;
        return this;
    }

    public IPotionEffectFactory getPotionFactory() {
        return this.potionFactory;
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        if (this.potionFactory == null) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            PotionEffect effect = this.potionFactory.createPotionEffect(world, entity, random, data);
            ((EntityLivingBase)entity).func_70690_d(effect);
        }
    }

    @Override
    protected void getActualDescription(List<String> list) {
        if (this.potionFactory == null) {
            return;
        }
        this.potionFactory.getDescription(list);
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("potion_factory")) {
            this.potionFactory = CoreRegistry.instance().getPotionEffectFactoryRegistry().loadPotionEffectFactoryFromNBT(data, "potion_factory");
        }
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        if (this.potionFactory != null) {
            this.potionFactory.writeToNBT(data, "potion_factory");
        }
    }
}

