/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config;

import growthcraft.core.shared.GrowthcraftLogger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GrowthcraftConfiguration
extends Configuration {
    private Configuration configuration;
    private static final String categoryGeneral = "general";
    private Level logLevel = Level.INFO;

    public void preInit(FMLPreInitializationEvent event, String configFilePath) {
        File directory = event.getModConfigurationDirectory();
        this.configuration = new Configuration(new File(directory.getPath(), configFilePath));
        this.readConfig(configFilePath);
    }

    protected void readConfig(String configFilePath) {
        try {
            this.configuration.load();
            this.initGeneralConfig();
        }
        catch (Exception e) {
            GrowthcraftLogger.getLogger("growthcraft").log(Level.ERROR, String.format("Unable to read configuration file at: %s", configFilePath));
        }
        finally {
            if (this.configuration.hasChanged()) {
                this.configuration.save();
            }
        }
    }

    protected void initGeneralConfig() {
        this.initDebugConfig();
    }

    private void initDebugConfig() {
        this.logLevel = Level.getLevel((String)this.configuration.getString("logLevel", categoryGeneral, this.logLevel.toString(), "Set standard logging levels, such as INFO, DEBUG, ERROR"));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }
}

