/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.events.EventBrewed;
import growthcraft.cellar.shared.init.GrowthcraftCellarItems;
import growthcraft.cellar.shared.processing.brewing.IBrewingRecipe;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.fluids.GrowthcraftFluidUtils;
import growthcraft.core.shared.tileentity.component.TileHeatingComponent;
import growthcraft.core.shared.tileentity.device.DeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BrewKettle
extends DeviceBase {
    private float grain;
    private double time;
    private double timeMax;
    private DeviceInventorySlot brewingSlot;
    private DeviceInventorySlot residueSlot;
    private DeviceInventorySlot lidSlot;
    private DeviceFluidSlot inputFluidSlot;
    private DeviceFluidSlot outputFluidSlot;
    private TileHeatingComponent heatComponent;

    public BrewKettle(TileEntityCellarDevice te, int brewSlotId, int residueSlotId, int lidSlotId, int inputFluidSlotId, int outputFluidSlotId) {
        super(te);
        this.brewingSlot = new DeviceInventorySlot((IInventory)te, brewSlotId);
        this.residueSlot = new DeviceInventorySlot((IInventory)te, residueSlotId);
        this.lidSlot = new DeviceInventorySlot((IInventory)te, lidSlotId);
        this.inputFluidSlot = new DeviceFluidSlot(te, inputFluidSlotId);
        this.outputFluidSlot = new DeviceFluidSlot(te, outputFluidSlotId);
        this.heatComponent = new TileHeatingComponent(te, 0.5f);
    }

    public void setGrain(float g) {
        this.grain = g;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double t) {
        this.time = t;
    }

    public double getTimeMax() {
        return this.timeMax;
    }

    public void setTimeMax(double t) {
        this.timeMax = t;
    }

    public boolean resetTime() {
        if (this.time != 0.0) {
            this.setTime(0.0);
            return true;
        }
        return false;
    }

    public float getProgress() {
        if (this.timeMax == 0.0) {
            return 0.0f;
        }
        return (float)(this.time / this.timeMax);
    }

    public int getProgressScaled(int scale) {
        return (int)(this.getProgress() * (float)scale);
    }

    public BrewKettle setHeatMultiplier(float h) {
        this.heatComponent.setHeatMultiplier(h);
        return this;
    }

    public float getHeatMultiplier() {
        return this.heatComponent.getHeatMultiplier();
    }

    public boolean isHeated() {
        return this.getHeatMultiplier() > 0.0f;
    }

    public boolean hasFluid() {
        return this.inputFluidSlot.hasContent() || this.outputFluidSlot.hasContent();
    }

    private IBrewingRecipe findRecipe() {
        boolean hasLid = GrowthcraftCellarItems.brewKettleLid.equals(this.lidSlot.get().func_77973_b());
        return CellarRegistry.instance().brewing().findRecipe(GrowthcraftFluidUtils.removeStackTags(this.inputFluidSlot.get()), this.brewingSlot.get(), hasLid);
    }

    public IBrewingRecipe getWorkingRecipe() {
        IMultiItemStacks expected;
        if (!this.isHeated()) {
            return null;
        }
        IBrewingRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return null;
        }
        if (this.brewingSlot.isEmpty()) {
            return null;
        }
        if (!CellarRegistry.instance().brewing().isFallbackRecipe(recipe) && !this.brewingSlot.hasEnough(expected = recipe.getInputItemStack())) {
            return null;
        }
        FluidStack inputFluid = recipe.getInputFluidStack();
        if (!this.inputFluidSlot.hasEnough(inputFluid)) {
            return null;
        }
        if (this.outputFluidSlot.isEmpty()) {
            return recipe;
        }
        FluidStack outputFluid = recipe.asFluidStack();
        if (!this.outputFluidSlot.hasCapacityFor(outputFluid)) {
            return null;
        }
        return recipe;
    }

    public boolean canBrew() {
        return this.getWorkingRecipe() != null;
    }

    private void produceGrain(IBrewingRecipe recipe) {
        Residue res = recipe.getResidue();
        if (res != null) {
            this.grain += res.pomaceRate;
            while (this.grain >= 1.0f) {
                this.grain -= 1.0f;
                this.residueSlot.increaseStack(res.residueItem);
            }
        }
    }

    private void brewItem(IBrewingRecipe recipe) {
        this.produceGrain(recipe);
        this.inputFluidSlot.consume(GrowthcraftFluidUtils.replaceFluidStackTags(recipe.getInputFluidStack(), this.inputFluidSlot.get()), true);
        this.outputFluidSlot.fill(recipe.asFluidStack(), true);
        if (!CellarRegistry.instance().brewing().isFallbackRecipe(recipe)) {
            this.brewingSlot.consume(recipe.getInputItemStack());
        } else {
            this.brewingSlot.consume(1);
        }
        this.markForUpdate(true);
        MinecraftForge.EVENT_BUS.post((Event)new EventBrewed(this.parent, recipe));
    }

    public void update() {
        this.heatComponent.update();
        IBrewingRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            this.timeMax = recipe.getTime();
            float multiplier = this.getHeatMultiplier();
            this.time += (double)(multiplier * 1.0f);
            if (this.time >= this.timeMax) {
                this.resetTime();
                this.brewItem(recipe);
            }
        } else if (this.resetTime()) {
            this.markForUpdate(true);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.time = data.func_74769_h("time");
        this.grain = data.func_74760_g("grain");
        this.heatComponent.readFromNBT(data, "heat_component");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74780_a("time", this.time);
        data.func_74776_a("grain", this.grain);
        this.heatComponent.writeToNBT(data, "heat_component");
    }

    @Override
    public boolean readFromStream(ByteBuf buf) {
        super.readFromStream(buf);
        this.time = buf.readDouble();
        this.timeMax = buf.readDouble();
        this.grain = buf.readFloat();
        this.heatComponent.readFromStream(buf);
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf buf) {
        super.writeToStream(buf);
        buf.writeDouble(this.time);
        buf.writeDouble(this.timeMax);
        buf.writeFloat(this.grain);
        this.heatComponent.writeToStream(buf);
        return false;
    }
}

