/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common;

import growthcraft.bees.GrowthcraftBees;
import growthcraft.bees.common.block.BlockBeeBox;
import growthcraft.bees.common.block.BlockBeeHive;
import growthcraft.bees.common.fluids.FluidHoney;
import growthcraft.bees.common.items.ItemBee;
import growthcraft.bees.common.items.ItemBeesWax;
import growthcraft.bees.common.items.ItemHoneyCombEmpty;
import growthcraft.bees.common.items.ItemHoneyCombFilled;
import growthcraft.bees.common.items.ItemHoneyJar;
import growthcraft.bees.common.lib.config.BeesFluidTag;
import growthcraft.bees.common.lib.config.BeesRegistry;
import growthcraft.bees.common.tileentity.TileEntityBeeBox;
import growthcraft.bees.shared.config.GrowthcraftBeesConfig;
import growthcraft.bees.shared.init.GrowthcraftBeesBlocks;
import growthcraft.bees.shared.init.GrowthcraftBeesFluids;
import growthcraft.bees.shared.init.GrowthcraftBeesItems;
import growthcraft.cellar.shared.GrowthcraftCellarApis;
import growthcraft.cellar.shared.booze.BoozeRegistryHelper;
import growthcraft.cellar.shared.booze.BoozeTag;
import growthcraft.cellar.shared.booze.BoozeUtils;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.definition.BlockBoozeDefinition;
import growthcraft.cellar.shared.definition.BoozeDefinition;
import growthcraft.cellar.shared.fluids.Booze;
import growthcraft.cellar.shared.item.ItemBoozeBottle;
import growthcraft.core.GrowthcraftCore;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.GrowthcraftCoreApis;
import growthcraft.core.shared.client.render.utils.ItemRenderUtils;
import growthcraft.core.shared.definition.BlockDefinition;
import growthcraft.core.shared.definition.ItemDefinition;
import growthcraft.core.shared.definition.ItemTypeDefinition;
import growthcraft.core.shared.effect.EffectAddPotionEffect;
import growthcraft.core.shared.effect.EffectWeightedRandomList;
import growthcraft.core.shared.effect.SimplePotionEffectFactory;
import growthcraft.core.shared.fluids.FluidFactory;
import growthcraft.core.shared.fluids.TaggedFluidStacks;
import growthcraft.core.shared.item.ItemFoodBottleFluid;
import growthcraft.core.shared.item.OreItemStacks;
import growthcraft.core.shared.item.recipes.ShapelessMultiRecipe;
import growthcraft.core.shared.utils.LootUtils;
import growthcraft.core.shared.utils.TickUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;

public class Init {
    private Init() {
    }

    public static void preInitBlocks() {
        GrowthcraftBeesBlocks.beeBox = new BlockDefinition(new BlockBeeBox("beebox"));
        GrowthcraftBeesBlocks.beeHive = new BlockDefinition(new BlockBeeHive("beehive"));
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftBeesBlocks.beeBox.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesBlocks.beeBox.registerBlock(registry);
        GrowthcraftBeesBlocks.beeHive.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesBlocks.beeHive.registerBlock(registry);
    }

    public static void registerBlockItems(IForgeRegistry<Item> registry) {
        GrowthcraftBeesBlocks.beeBox.registerBlockItem(registry);
        GrowthcraftBeesBlocks.beeHive.registerBlockItem(registry);
    }

    public static void registerBlockRender() {
        GrowthcraftBeesBlocks.beeBox.registerItemRender();
        GrowthcraftBeesBlocks.beeHive.registerItemRender();
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBeeBox.class, (String)"growthcraft_bees:bee_box");
    }

    public static void preInitItems() {
        GrowthcraftBeesItems.honeyCombEmpty = new ItemDefinition(new ItemHoneyCombEmpty("honey_comb_empty"));
        GrowthcraftBeesItems.honeyCombFilled = new ItemDefinition(new ItemHoneyCombFilled("honey_comb_filled"));
        GrowthcraftBeesItems.honeyJar = new ItemDefinition((Item)new ItemHoneyJar("honey_jar"));
        GrowthcraftBeesItems.bee = new ItemDefinition(new ItemBee("bee"));
        GrowthcraftBeesItems.beesWax = new ItemDefinition(new ItemBeesWax("bees_wax"));
        GrowthcraftBeesItems.honeyMeadBottle = new ItemTypeDefinition<ItemBoozeBottle>(new ItemBoozeBottle());
    }

    public static void registerItemOres() {
        OreDictionary.registerOre((String)"materialWax", GrowthcraftBeesItems.beesWax.getItem());
        OreDictionary.registerOre((String)"materialBeeswax", GrowthcraftBeesItems.beesWax.getItem());
        OreDictionary.registerOre((String)"materialBeeswaxBlack", (ItemStack)GrowthcraftBeesItems.BeesWaxTypes.BLACK.asStack());
        OreDictionary.registerOre((String)"materialBeeswaxRed", (ItemStack)GrowthcraftBeesItems.BeesWaxTypes.RED.asStack());
        OreDictionary.registerOre((String)"materialBeeswaxBlue", (ItemStack)GrowthcraftBeesItems.BeesWaxTypes.BLUE.asStack());
        OreDictionary.registerOre((String)"materialBeeswaxWhite", (ItemStack)GrowthcraftBeesItems.BeesWaxTypes.WHITE.asStack());
        OreDictionary.registerOre((String)"materialBeeswaxNormal", (ItemStack)GrowthcraftBeesItems.BeesWaxTypes.NORMAL.asStack());
        OreDictionary.registerOre((String)"materialWaxcomb", GrowthcraftBeesItems.honeyCombEmpty.getItem());
        OreDictionary.registerOre((String)"beecomb", GrowthcraftBeesItems.honeyCombEmpty.getItem());
        OreDictionary.registerOre((String)"materialHoneycomb", GrowthcraftBeesItems.honeyCombFilled.getItem());
        OreDictionary.registerOre((String)"beecomb", GrowthcraftBeesItems.honeyCombFilled.getItem());
        OreDictionary.registerOre((String)"honeyDrop", GrowthcraftBeesItems.honeyJar.getItem());
        OreDictionary.registerOre((String)"dropHoney", GrowthcraftBeesItems.honeyJar.getItem());
        OreDictionary.registerOre((String)"jarHoney", GrowthcraftBeesItems.honeyJar.getItem());
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        GrowthcraftBeesItems.honeyCombEmpty.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesItems.honeyCombEmpty.registerItem(registry);
        GrowthcraftBeesItems.honeyCombFilled.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesItems.honeyCombFilled.registerItem(registry);
        GrowthcraftBeesItems.honeyJar.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesItems.honeyJar.registerItem(registry);
        GrowthcraftBeesItems.bee.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesItems.bee.registerItem(registry);
        GrowthcraftBeesItems.beesWax.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesItems.beesWax.registerItem(registry);
        GrowthcraftBeesItems.honeyMeadBottle.registerItem(registry, new ResourceLocation("growthcraft_bees", "mead"));
        GrowthcraftBeesItems.honeyMeadBottle.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftBeesItems.honeyMeadBottle.getItem().setBoozes(GrowthcraftBeesFluids.meadBooze);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders() {
        GrowthcraftBeesItems.honeyCombEmpty.registerRender();
        GrowthcraftBeesItems.honeyCombFilled.registerRender();
        GrowthcraftBeesItems.honeyJar.registerRender();
        GrowthcraftBeesItems.bee.registerRender();
        GrowthcraftBeesItems.beesWax.registerRenders(GrowthcraftBeesItems.BeesWaxTypes.class);
        GrowthcraftBeesItems.honeyMeadBottle.registerRenders(GrowthcraftBeesItems.MeadTypes.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemColorHandlers() {
        ItemRenderUtils.registerItemColorHandler((Item)GrowthcraftBeesItems.honeyMeadBottle.getItem());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemVariants() {
        GrowthcraftBeesItems.beesWax.registerModelBakeryVariants(GrowthcraftBeesItems.BeesWaxTypes.class);
        GrowthcraftBeesItems.honeyMeadBottle.registerModelBakeryVariants(GrowthcraftBeesItems.MeadTypes.class);
    }

    public static void preInitFluids() {
        if (GrowthcraftBeesConfig.honeyEnabled) {
            FluidHoney fluidHoney = new FluidHoney("fluid_honey");
            ItemFoodBottleFluid foodBottleHoney = new ItemFoodBottleFluid(fluidHoney, 2, 0.2f, false);
            GrowthcraftBeesFluids.honey = new FluidFactory.FluidDetailsBuilder(fluidHoney, 13).setFoodBottle(foodBottleHoney).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft);
            GrowthcraftBeesFluids.honey.refreshItemColor();
        }
        GrowthcraftBeesFluids.meadBooze = new BoozeDefinition[GrowthcraftBeesItems.MeadTypes.values().length];
        BoozeRegistryHelper.initializeAndRegisterBoozeFluids(GrowthcraftBeesFluids.meadBooze, GrowthcraftBeesItems.MeadTypes.class, "");
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_YOUNG.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_FERMENTED.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_ETHEREAL.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_INTOXICATED.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_POISONED.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
        ((Booze)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_HYPEREXTENDED.ordinal()].getFluid()).setColor(GrowthcraftBeesConfig.honeyMeadColor).setDensity(1000).setViscosity(1200);
    }

    public static void initBoozes() {
        BoozeRegistryHelper.initBoozeContainers(GrowthcraftBeesFluids.meadBooze, GrowthcraftBeesItems.honeyMeadBottle, "growthcraft_bees", "meadbooze", GrowthcraftBeesItems.MeadTypes.class);
        Init.registerFermentations();
    }

    public static void registerFluidOres() {
        if (GrowthcraftBeesFluids.honey != null) {
            OreDictionary.registerOre((String)"bottleHoney", (ItemStack)GrowthcraftBeesFluids.honey.asBottleItemStack());
            OreDictionary.registerOre((String)"honeyDrop", (ItemStack)GrowthcraftBeesFluids.honey.asBucketItemStack());
        }
    }

    public static void registerFluidBlocks(IForgeRegistry<Block> registry) {
        if (GrowthcraftBeesFluids.honey != null) {
            GrowthcraftBeesFluids.honey.registerBlocks(registry, "growthcraft_bees", "honey");
            CoreRegistry.instance().fluidDictionary().addFluidTags(GrowthcraftBeesFluids.honey.getFluid(), BeesFluidTag.HONEY);
        }
        GrowthcraftBeesBlocks.meadBoozeFluidBlocks = new BlockBoozeDefinition[GrowthcraftBeesFluids.meadBooze.length];
        BoozeRegistryHelper.initializeBooze(GrowthcraftBeesFluids.meadBooze, GrowthcraftBeesBlocks.meadBoozeFluidBlocks);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftBeesFluids.meadBooze, 1, -0.45f);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftBeesFluids.meadBooze[0], 1, 0.45f);
        BoozeRegistryHelper.registerBoozeBlocks(registry, GrowthcraftBeesFluids.meadBooze, GrowthcraftBeesBlocks.meadBoozeFluidBlocks, "growthcraft_bees", "mead", GrowthcraftBeesItems.MeadTypes.class);
    }

    public static void registerFluidItems(IForgeRegistry<Item> registry) {
        if (GrowthcraftBeesFluids.honey != null) {
            GrowthcraftBeesFluids.honey.registerItems(registry, "growthcraft_bees", "honey");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidRender() {
        if (GrowthcraftBeesFluids.honey != null) {
            GrowthcraftBeesFluids.honey.registerRenderer();
        }
        BoozeRegistryHelper.registerBoozeRenderers(GrowthcraftBeesFluids.meadBooze, GrowthcraftBeesBlocks.meadBoozeFluidBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidColorHandlers() {
        if (GrowthcraftBeesFluids.honey != null) {
            GrowthcraftBeesFluids.honey.registerColorHandlers();
        }
    }

    private static void registerFermentations() {
        int fermentTime = GrowthcraftCellarConfig.fermentTime;
        FluidStack[] fs = new FluidStack[GrowthcraftBeesFluids.meadBooze.length];
        for (int i = 0; i < GrowthcraftBeesFluids.meadBooze.length; ++i) {
            fs[i] = GrowthcraftBeesFluids.meadBooze[i].asFluidStack();
        }
        FluidStack[] spoilInputFs = new FluidStack[GrowthcraftBeesFluids.meadBooze.length];
        for (int i = 0; i < GrowthcraftBeesFluids.meadBooze.length; ++i) {
            spoilInputFs[i] = GrowthcraftBeesFluids.meadBooze[i].asFluidStack(40);
        }
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_YOUNG.ordinal()].getFluid()).tags(BeesFluidTag.MEAD, BoozeTag.YOUNG).fermentsFrom(new FluidStack(FluidRegistry.getFluid((String)"fluid_honey"), 250), new OreItemStacks("yeastBrewers"), fermentTime);
        TaggedFluidStacks youngMead = new TaggedFluidStacks(1, BoozeTag.YOUNG.getName(), BeesFluidTag.MEAD.getName());
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_FERMENTED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BeesFluidTag.MEAD).fermentsFrom(youngMead, new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(youngMead, new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76428_l, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.POTENT, BeesFluidTag.MEAD).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_FERMENTED.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.17f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76428_l, TickUtils.seconds(90), 1);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.EXTENDED, BeesFluidTag.MEAD).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_FERMENTED.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76428_l, TickUtils.seconds(180), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_HYPEREXTENDED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.EXTENDED, BeesFluidTag.MEAD).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76428_l, TickUtils.seconds(480), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_ETHEREAL.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.MAGICAL, BeesFluidTag.MEAD).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addPotionEntry(MobEffects.field_76428_l, TickUtils.seconds(90), 2);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_INTOXICATED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.INTOXICATED, BeesFluidTag.MEAD).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76428_l, TickUtils.seconds(90), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76436_u, TickUtils.seconds(90), 2))));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftBeesFluids.meadBooze[GrowthcraftBeesItems.MeadTypes.MEAD_POISONED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.POISONED, BeesFluidTag.MEAD).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_FERMENTED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftBeesItems.MeadTypes.MEAD_FERMENTED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftBeesItems.MeadTypes.MEAD_FERMENTED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftBeesItems.MeadTypes.MEAD_EXTENDED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftBeesItems.MeadTypes.MEAD_POTENT.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_ETHEREAL.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftBeesItems.MeadTypes.MEAD_ETHEREAL.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftBeesItems.MeadTypes.MEAD_ETHEREAL.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftBeesItems.MeadTypes.MEAD_INTOXICATED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftBeesItems.MeadTypes.MEAD_INTOXICATED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftBeesItems.MeadTypes.MEAD_INTOXICATED.ordinal()], TickUtils.minutes(1), null).fermentsFromFallback(fs[GrowthcraftBeesItems.MeadTypes.MEAD_POISONED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftBeesItems.MeadTypes.MEAD_POISONED.ordinal()], TickUtils.minutes(1), null).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.15f), TickUtils.seconds(90)).createPotionEntry(MobEffects.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthcraftCore.config.getHidePoisonedBooze());
    }

    public static void initUserApisDefaults() {
        GrowthcraftBees.userBeesConfig.addDefault(GrowthcraftBeesItems.bee.asStack()).setComment("Growthcraft's default bee");
        BeesRegistry.instance().addHoneyComb(GrowthcraftBeesItems.honeyCombEmpty.asStack(), GrowthcraftBeesItems.honeyCombFilled.asStack());
        GrowthcraftBees.userFlowersConfig.addDefault((Block)Blocks.field_150328_O);
        GrowthcraftBees.userFlowersConfig.addDefault((Block)Blocks.field_150327_N);
    }

    public static void registerRecipes() {
    }

    public static void registerCraftingRecipes(IForgeRegistry<IRecipe> registry) {
        ResourceLocation group = new ResourceLocation("growthcraft_bees", "bees");
        UniversalBucket universalBucket = ForgeModContainer.getInstance().universalBucket;
        ItemStack meadBucket = UniversalBucket.getFilledBucket((UniversalBucket)universalBucket, GrowthcraftBeesFluids.meadBooze[0].getFluid());
        ItemStack meadBottle = GrowthcraftBeesItems.honeyMeadBottle.asStack();
        ItemStack meadBottle4 = GrowthcraftBeesItems.honeyMeadBottle.asStack(4);
        registry.register(new ShapelessMultiRecipe(group.toString(), meadBottle, Items.field_151069_bo, new TaggedFluidStacks(250, BeesFluidTag.HONEY.getName()), new FluidStack(FluidRegistry.WATER, 250)).setRegistryName(Init.toRegName("mead_fluid_to_bottle_1")));
        ItemStack honeyStack = GrowthcraftBeesItems.honeyCombFilled.asStack();
        registry.register(new ShapelessRecipes(group.toString(), GrowthcraftBeesItems.honeyJar.asStack(), NonNullList.func_193580_a((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193367_a((Item)Items.field_151162_bE)})).setRegistryName(Init.toRegName("honey_comb_filled_1")));
        registry.register(new ShapelessMultiRecipe(group.toString(), GrowthcraftBeesFluids.honey.asBucketItemStack(), honeyStack, honeyStack, honeyStack, honeyStack, honeyStack, honeyStack, Items.field_151133_ar).setRegistryName(Init.toRegName("honey_comb_filled_2")));
        registry.register(new ShapelessRecipes(group.toString(), GrowthcraftBeesFluids.honey.asBottleItemStack(2), NonNullList.func_193580_a((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{honeyStack}), Ingredient.func_193367_a((Item)Items.field_151069_bo), Ingredient.func_193367_a((Item)Items.field_151069_bo)})).setRegistryName(Init.toRegName("honey_comb_filled_3")));
        registry.register(new ShapelessMultiRecipe(group.toString(), GrowthcraftBeesItems.honeyJar.asStack(), new TaggedFluidStacks(1000, BeesFluidTag.HONEY.getName()), Items.field_151162_bE).setRegistryName(Init.toRegName("honey_fluid_to_jar_1")));
        registry.register(new ShapelessOreRecipe(group, GrowthcraftBeesItems.honeyJar.asStack(), new Object[]{Items.field_151162_bE, "jarHoney"}).setRegistryName(Init.toRegName("honey_ore_to_jar")));
        registry.register(new ShapelessMultiRecipe(group.toString(), GrowthcraftBeesFluids.honey.asBucketItemStack(), Items.field_151133_ar, new TaggedFluidStacks(1000, BeesFluidTag.HONEY.getName())).setRegistryName(Init.toRegName("honey_fluid_to_bucket")));
        registry.register(new ShapelessOreRecipe(group, GrowthcraftBeesFluids.honey.asBucketItemStack(), new Object[]{"jarHoney", Items.field_151133_ar}).setRegistryName(Init.toRegName("honey_ore_to_bucket")));
    }

    private static ResourceLocation toRegName(String name) {
        return new ResourceLocation("growthcraft_bees", name);
    }

    public static void lootLoad(LootTableLoadEvent evt) {
        boolean isVillageBlacksmith = evt.getName().toString().equals("minecraft:chests/village_blacksmith");
        if (isVillageBlacksmith) {
            LootPool pool = LootUtils.getOrCreateLootPool(evt.getTable(), "growthcraft");
            LootUtils.addLootEntry(pool, GrowthcraftBeesItems.bee.getItem(), 1, 2, 10);
        }
    }
}

